#!/usr/bin/python -u
# coding:utf-8

"""
Copyright (C) 2017 Jacksgong(jacksgong.com)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
from distutils import errors
import os
import re
import sys

from os import environ, getcwd

from os.path import exists

__author__ = 'JacksGong'

LOG_LEVELS = 'VDIWEF'
LOG_LEVELS_MAP = dict([(LOG_LEVELS[i], i) for i in range(len(LOG_LEVELS))])

NO_HOME_PATH = re.compile(r'~/(.*)')
HOME_PATH = environ['HOME']


# get the home case path
def handle_home_case(path):
    path = path.strip()
    if path.startswith('~/'):
        path = HOME_PATH + '/' + NO_HOME_PATH.match(path).groups()[0]
    return path


# 调整is path的逻辑，支持文件名模糊匹配, 对于正则表达式，返回匹配的文件列表
def getFilePaths(logs):
    fileList = list()
    for logPath in logs:
        indexOfLastBackSlant = logPath.rfind("/")
        candidateFiles = list() 
        fileName = logPath
        logFileDir = os.getcwd()
        if (indexOfLastBackSlant == -1):
            # 单文件，直接返回当前文件
            candidateFiles = os.listdir(logFileDir)
        else:
            # 包含目录
            logFileDir = logPath[0 : indexOfLastBackSlant]
            candidateFiles = os.listdir(logFileDir)
            fileName = logPath[indexOfLastBackSlant + 1 :]
        for subFile in candidateFiles:
            if re.match(fileName, subFile):
                fileList.append(os.path.join(logFileDir, subFile))
    return fileList


def get_conf_path(conf_name):
    if not conf_name.endswith('.yml'):
        conf_name = conf_name + '.yml'

    cur_path_yml = '%s/%s' % (getcwd(), conf_name)
    if exists(cur_path_yml):
        result = cur_path_yml
    else:
        result = '~/.okcat/' + conf_name

    print('using config on %s' % result)
    return result


def print_unicode(line):
    if sys.version_info >= (3, 0):
        print(bytes.decode(line))
    else:
        print(line)

def line_rstrip(line):
    if sys.version_info >= (3, 0):
        return line.rstrip()
    else:
        return line.decode('utf-8', errors='ignore').rstrip()
def init_baseyml():
    config_path = HOME_PATH
    config_path = os.path.join(config_path, ".okcat")
    if not os.path.exists(config_path):
        os.makedirs(config_path)
    if os.path.isdir(config_path):
        # init base.yml
        print("init base yml")
        
        with open(os.path.join(config_path, "base.yml"), 'w') as baseyml:
            baseyml.write("# PLEASE DO NOT EDIT THIS FILE, IT WILL BE OVERWRITE BY DUCAT!! 请不要编辑此文件，此文件随时会被覆盖")
            baseyml.write("\n")
            baseyml.write("tag-keyword-list:")
            baseyml.write("\n")
            baseyml.write("  'AndroidRuntime': W,E")
            baseyml.write("\n")
            baseyml.write("  'ActivityManager': E")
            baseyml.write("\n")
            baseyml.write("  'DEBUG': F")
            baseyml.write("\n")
            baseyml.write('log-line-regex: \'date,time,process,thread,level,tag,message = "(.\S*) *(.\S*) *(\d*) *(\d*) *([A-Z]) *([^:]*):\s*(.*)$"\'')
            baseyml.write("\n")
            baseyml.write('trans-msg-map:')
            baseyml.write("\n")
            baseyml.write('  \'event=SEND_EVENT.*name":"(\w*)\': "上报事件"')
            baseyml.write("\n")
            baseyml.write('  \'^((?!FinishHandleDirectives)\w*)\s*receive directive:\': "收到指令"')
            baseyml.write("\n")
            baseyml.write('  \'Start proc (\d+):([\w\.]+)\': "启动进程"')
            baseyml.write("\n")
            baseyml.write('  \'eventType:ACTIVITY_RESUMED, packageName:([\w\.]+)\': "页面进前台"')
            baseyml.write("\n")
            baseyml.write('  \'eventType:ACTIVITY_PAUSED, packageName:([\w\.]+)\': "页面进后台"')
            baseyml.write("\n")
            baseyml.write('  \'FATAL EXCEPTION:\': "Java崩溃"')
            baseyml.write("\n")
            baseyml.write('  \'START u\d+ \{flg=0x[01]+ cmp=([\w\.]+)\': "启动页面"')
            baseyml.write("\n")
            baseyml.write('  \'Fatal signal \d+\s+.*pid\s+(\d+)\s+(.*)\': "Native崩溃"')
            baseyml.write("\n")
            baseyml.write('  \'ANR in ([\w\.]+)\': "无响应ANR"')
            baseyml.write("\n")
            baseyml.write('  \'onPartialResult = (\S+)\': "用户query"')
            baseyml.write("\n")
            baseyml.flush()
            baseyml.close()
        
    else:
        print("init base yml fail, ~/.okcat is not dir")
        