import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { Grant } from './grant';
import { IManagedPolicy } from './managed-policy';
import { Policy } from './policy';
import { PolicyStatement } from './policy-statement';
import { AddToPrincipalPolicyResult, IPrincipal, PrincipalPolicyFragment } from './principals';
import { IRole, RoleProps } from './role';
/**
 * Properties for defining a LazyRole.
 *
 * @stability stable
 */
export interface LazyRoleProps extends RoleProps {
}
/**
 * An IAM role that only gets attached to the construct tree once it gets used, not before.
 *
 * This construct can be used to simplify logic in other constructs
 * which need to create a role but only if certain configurations occur
 * (such as when AutoScaling is configured). The role can be configured in one
 * place, but if it never gets used it doesn't get instantiated and will
 * not be synthesized or deployed.
 *
 * @stability stable
 * @resource AWS::IAM::Role
 */
export declare class LazyRole extends cdk.Resource implements IRole {
    private readonly props;
    /**
     * The principal to grant permissions to.
     *
     * @stability stable
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * The AWS account ID of this principal.
     *
     * Can be undefined when the account is not known
     * (for example, for service principals).
     * Can be a Token - in that case,
     * it's assumed to be AWS::AccountId.
     *
     * @stability stable
     */
    readonly principalAccount: string | undefined;
    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @stability stable
     */
    readonly assumeRoleAction: string;
    private role?;
    private readonly statements;
    private readonly policies;
    private readonly managedPolicies;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: LazyRoleProps);
    /**
     * Adds a permission to the role's default policy document.
     *
     * If there is no default policy attached to this role, it will be created.
     *
     * @param statement The permission statement to add to the policy document.
     * @stability stable
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
    /**
     * Add to the policy of this principal.
     *
     * @stability stable
     */
    addToPolicy(statement: PolicyStatement): boolean;
    /**
     * Attaches a policy to this role.
     *
     * @param policy The policy to attach.
     * @stability stable
     */
    attachInlinePolicy(policy: Policy): void;
    /**
     * Attaches a managed policy to this role.
     *
     * @param policy The managed policy to attach.
     * @stability stable
     */
    addManagedPolicy(policy: IManagedPolicy): void;
    /**
     * Returns the ARN of this role.
     *
     * @stability stable
     */
    get roleArn(): string;
    /**
     * Returns the stable and unique string identifying the role (i.e. AIDAJQABLZS4A3QDU576Q).
     *
     * @stability stable
     * @attribute true
     */
    get roleId(): string;
    /**
     * Returns the name of this role.
     *
     * @stability stable
     */
    get roleName(): string;
    /**
     * Return the policy fragment that identifies this principal in a Policy.
     *
     * @stability stable
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * Grant the actions defined in actions to the identity Principal on this resource.
     *
     * @stability stable
     */
    grant(identity: IPrincipal, ...actions: string[]): Grant;
    /**
     * Grant permissions to the given principal to pass this role.
     *
     * @stability stable
     */
    grantPassRole(identity: IPrincipal): Grant;
    private instantiate;
}
