import * as cxschema from '@aws-cdk/cloud-assembly-schema';
import { CloudAssembly } from './cloud-assembly';
import { MetadataEntryResult, SynthesisMessage } from './metadata';
/**
 * (experimental) Artifact properties for CloudFormation stacks.
 *
 * @experimental
 */
export interface AwsCloudFormationStackProperties {
    /**
     * (experimental) A file relative to the assembly root which contains the CloudFormation template for this stack.
     *
     * @experimental
     */
    readonly templateFile: string;
    /**
     * (experimental) Values for CloudFormation stack parameters that should be passed when the stack is deployed.
     *
     * @experimental
     */
    readonly parameters?: {
        [id: string]: string;
    };
    /**
     * (experimental) The name to use for the CloudFormation stack.
     *
     * @default - name derived from artifact ID
     * @experimental
     */
    readonly stackName?: string;
    /**
     * (experimental) Whether to enable termination protection for this stack.
     *
     * @default false
     * @experimental
     */
    readonly terminationProtection?: boolean;
}
/**
 * (experimental) Represents an artifact within a cloud assembly.
 *
 * @experimental
 */
export declare class CloudArtifact {
    readonly assembly: CloudAssembly;
    readonly id: string;
    /**
     * (experimental) Returns a subclass of `CloudArtifact` based on the artifact type defined in the artifact manifest.
     *
     * @param assembly The cloud assembly from which to load the artifact.
     * @param id The artifact ID.
     * @param artifact The artifact manifest.
     * @returns the `CloudArtifact` that matches the artifact type or `undefined` if it's an artifact type that is unrecognized by this module.
     * @experimental
     */
    static fromManifest(assembly: CloudAssembly, id: string, artifact: cxschema.ArtifactManifest): CloudArtifact | undefined;
    /**
     * (experimental) The artifact's manifest.
     *
     * @experimental
     */
    readonly manifest: cxschema.ArtifactManifest;
    /**
     * (experimental) The set of messages extracted from the artifact's metadata.
     *
     * @experimental
     */
    readonly messages: SynthesisMessage[];
    /**
     * IDs of all dependencies. Used when topologically sorting the artifacts within the cloud assembly.
     * @internal
     */
    readonly _dependencyIDs: string[];
    /**
     * Cache of resolved dependencies.
     */
    private _deps?;
    /**
     * @experimental
     */
    protected constructor(assembly: CloudAssembly, id: string, manifest: cxschema.ArtifactManifest);
    /**
     * (experimental) Returns all the artifacts that this artifact depends on.
     *
     * @experimental
     */
    get dependencies(): CloudArtifact[];
    /**
     * @returns all the metadata entries of a specific type in this artifact.
     * @experimental
     */
    findMetadataByType(type: string): MetadataEntryResult[];
    private renderMessages;
}
