/**
 * (experimental) Load balancer ip address type.
 *
 * @experimental
 */
export declare enum LoadBalancerIpAddressType {
    /**
     * (experimental) IPV4 ip address.
     *
     * @experimental
     */
    IPV4 = "ipv4",
    /**
     * (experimental) Dual stack address.
     *
     * @experimental
     */
    DUAL_STACK = "dualstack"
}
/**
 * (experimental) Properties of a discovered load balancer.
 *
 * @experimental
 */
export interface LoadBalancerContextResponse {
    /**
     * (experimental) The ARN of the load balancer.
     *
     * @experimental
     */
    readonly loadBalancerArn: string;
    /**
     * (experimental) The hosted zone ID of the load balancer's name.
     *
     * @experimental
     */
    readonly loadBalancerCanonicalHostedZoneId: string;
    /**
     * (experimental) Load balancer's DNS name.
     *
     * @experimental
     */
    readonly loadBalancerDnsName: string;
    /**
     * (experimental) Type of IP address.
     *
     * @experimental
     */
    readonly ipAddressType: LoadBalancerIpAddressType;
    /**
     * (experimental) Load balancer's security groups.
     *
     * @experimental
     */
    readonly securityGroupIds: string[];
    /**
     * (experimental) Load balancer's VPC.
     *
     * @experimental
     */
    readonly vpcId: string;
}
/**
 * (experimental) Properties of a discovered load balancer listener.
 *
 * @experimental
 */
export interface LoadBalancerListenerContextResponse {
    /**
     * (experimental) The ARN of the listener.
     *
     * @experimental
     */
    readonly listenerArn: string;
    /**
     * (experimental) The port the listener is listening on.
     *
     * @experimental
     */
    readonly listenerPort: number;
    /**
     * (experimental) The security groups of the load balancer.
     *
     * @experimental
     */
    readonly securityGroupIds: string[];
}
