"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Applicationinsights = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [applicationinsights](https://docs.aws.amazon.com/service-authorization/latest/reference/list_cloudwatchapplicationinsights.html).
 *
 * @experimental
 */
class Applicationinsights extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [applicationinsights](https://docs.aws.amazon.com/service-authorization/latest/reference/list_cloudwatchapplicationinsights.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'applicationinsights';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CreateApplication",
                "CreateComponent",
                "DeleteApplication",
                "DeleteComponent",
                "UpdateApplication",
                "UpdateComponent",
                "UpdateComponentConfiguration"
            ],
            "Read": [
                "DescribeApplication",
                "DescribeComponent",
                "DescribeComponentConfiguration",
                "DescribeComponentConfigurationRecommendation",
                "DescribeObservation",
                "DescribeProblem",
                "DescribeProblemObservations"
            ],
            "List": [
                "ListApplications",
                "ListComponents",
                "ListProblems"
            ]
        };
    }
    /**
     * (experimental) Creates an application from a resource group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_CreateApplication.html
     *
     * @experimental
     */
    toCreateApplication() {
        this.to('applicationinsights:CreateApplication');
        return this;
    }
    /**
     * (experimental) Creates a component from a group of resources.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_CreateComponent.html
     *
     * @experimental
     */
    toCreateComponent() {
        this.to('applicationinsights:CreateComponent');
        return this;
    }
    /**
     * (experimental) Deletes an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DeleteApplication.html
     *
     * @experimental
     */
    toDeleteApplication() {
        this.to('applicationinsights:DeleteApplication');
        return this;
    }
    /**
     * (experimental) Deletes a component.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DeleteComponent.html
     *
     * @experimental
     */
    toDeleteComponent() {
        this.to('applicationinsights:DeleteComponent');
        return this;
    }
    /**
     * (experimental) Describes an application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeApplication.html
     *
     * @experimental
     */
    toDescribeApplication() {
        this.to('applicationinsights:DescribeApplication');
        return this;
    }
    /**
     * (experimental) Describes a component.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponent.html
     *
     * @experimental
     */
    toDescribeComponent() {
        this.to('applicationinsights:DescribeComponent');
        return this;
    }
    /**
     * (experimental) Describes a component configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponentConfiguration.html
     *
     * @experimental
     */
    toDescribeComponentConfiguration() {
        this.to('applicationinsights:DescribeComponentConfiguration');
        return this;
    }
    /**
     * (experimental) Describe the recommended application component configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponentConfigurationRecommendation.html
     *
     * @experimental
     */
    toDescribeComponentConfigurationRecommendation() {
        this.to('applicationinsights:DescribeComponentConfigurationRecommendation');
        return this;
    }
    /**
     * (experimental) Describes an observation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeObservation.html
     *
     * @experimental
     */
    toDescribeObservation() {
        this.to('applicationinsights:DescribeObservation');
        return this;
    }
    /**
     * (experimental) Describes a problem.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeProblem.html
     *
     * @experimental
     */
    toDescribeProblem() {
        this.to('applicationinsights:DescribeProblem');
        return this;
    }
    /**
     * (experimental) Describes the observation in a problem.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeProblemObservations.html
     *
     * @experimental
     */
    toDescribeProblemObservations() {
        this.to('applicationinsights:DescribeProblemObservations');
        return this;
    }
    /**
     * (experimental) Lists all applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListApplications.html
     *
     * @experimental
     */
    toListApplications() {
        this.to('applicationinsights:ListApplications');
        return this;
    }
    /**
     * (experimental) List an application's components.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListComponents.html
     *
     * @experimental
     */
    toListComponents() {
        this.to('applicationinsights:ListComponents');
        return this;
    }
    /**
     * (experimental) Lists the problems in an application.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListProblems.html
     *
     * @experimental
     */
    toListProblems() {
        this.to('applicationinsights:ListProblems');
        return this;
    }
    /**
     * (experimental) Updates an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateApplication.html
     *
     * @experimental
     */
    toUpdateApplication() {
        this.to('applicationinsights:UpdateApplication');
        return this;
    }
    /**
     * (experimental) Updates a component.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateComponent.html
     *
     * @experimental
     */
    toUpdateComponent() {
        this.to('applicationinsights:UpdateComponent');
        return this;
    }
    /**
     * (experimental) Updates a component configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateComponentConfiguration.html
     *
     * @experimental
     */
    toUpdateComponentConfiguration() {
        this.to('applicationinsights:UpdateComponentConfiguration');
        return this;
    }
}
exports.Applicationinsights = Applicationinsights;
//# sourceMappingURL=data:application/json;base64,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