"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElementalSupportCases = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [elemental-support-cases](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elementalsupportcases.html).
 *
 * @experimental
 */
class ElementalSupportCases extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [elemental-support-cases](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elementalsupportcases.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'elemental-support-cases';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CreateCase",
                "UpdateCase"
            ],
            "Read": [
                "GetCase",
                "GetCases"
            ]
        };
    }
    /**
     * (experimental) Grant the permission to create a support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     *
     * @experimental
     */
    toCreateCase() {
        this.to('elemental-support-cases:CreateCase');
        return this;
    }
    /**
     * (experimental) Grant the permission to describe a support case in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     *
     * @experimental
     */
    toGetCase() {
        this.to('elemental-support-cases:GetCase');
        return this;
    }
    /**
     * (experimental) Grant the permission to list the support cases in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     *
     * @experimental
     */
    toGetCases() {
        this.to('elemental-support-cases:GetCases');
        return this;
    }
    /**
     * (experimental) Grant the permission to update a support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     *
     * @experimental
     */
    toUpdateCase() {
        this.to('elemental-support-cases:UpdateCase');
        return this;
    }
}
exports.ElementalSupportCases = ElementalSupportCases;
//# sourceMappingURL=data:application/json;base64,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