"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Launchwizard = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [launchwizard](https://docs.aws.amazon.com/service-authorization/latest/reference/list_launchwizard.html).
 *
 * @experimental
 */
class Launchwizard extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [launchwizard](https://docs.aws.amazon.com/service-authorization/latest/reference/list_launchwizard.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'launchwizard';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "DeleteApp",
                "StartProvisioning"
            ],
            "Read": [
                "DescribeProvisionedApp",
                "DescribeProvisioningEvents",
                "GetInfrastructureSuggestion",
                "GetIpAddress",
                "GetResourceCostEstimate"
            ],
            "List": [
                "ListProvisionedApps"
            ]
        };
    }
    /**
     * (experimental) Delete an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toDeleteApp() {
        this.to('launchwizard:DeleteApp');
        return this;
    }
    /**
     * (experimental) Describe provisioning applications.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toDescribeProvisionedApp() {
        this.to('launchwizard:DescribeProvisionedApp');
        return this;
    }
    /**
     * (experimental) Describe provisioning events.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toDescribeProvisioningEvents() {
        this.to('launchwizard:DescribeProvisioningEvents');
        return this;
    }
    /**
     * (experimental) Get infrastructure suggestion.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toGetInfrastructureSuggestion() {
        this.to('launchwizard:GetInfrastructureSuggestion');
        return this;
    }
    /**
     * (experimental) Get customer's ip address.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toGetIpAddress() {
        this.to('launchwizard:GetIpAddress');
        return this;
    }
    /**
     * (experimental) Get resource cost estimate.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toGetResourceCostEstimate() {
        this.to('launchwizard:GetResourceCostEstimate');
        return this;
    }
    /**
     * (experimental) List provisioning applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toListProvisionedApps() {
        this.to('launchwizard:ListProvisionedApps');
        return this;
    }
    /**
     * (experimental) Start a provisioning.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toStartProvisioning() {
        this.to('launchwizard:StartProvisioning');
        return this;
    }
}
exports.Launchwizard = Launchwizard;
//# sourceMappingURL=data:application/json;base64,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