"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mobileanalytics = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [mobileanalytics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmobileanalytics.html).
 *
 * @experimental
 */
class Mobileanalytics extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [mobileanalytics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmobileanalytics.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'mobileanalytics';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Read": [
                "GetFinancialReports",
                "GetReports"
            ],
            "Write": [
                "PutEvents"
            ]
        };
    }
    /**
     * (experimental) Grant access to financial metrics for an app.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetFinancialReports() {
        this.to('mobileanalytics:GetFinancialReports');
        return this;
    }
    /**
     * (experimental) Grant access to standard metrics for an app.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetReports() {
        this.to('mobileanalytics:GetReports');
        return this;
    }
    /**
     * (experimental) The PutEvents operation records one or more events.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html
     *
     * @experimental
     */
    toPutEvents() {
        this.to('mobileanalytics:PutEvents');
        return this;
    }
}
exports.Mobileanalytics = Mobileanalytics;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9iaWxlYW5hbHl0aWNzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibW9iaWxlYW5hbHl0aWNzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHNDQUE0Qzs7Ozs7O0FBUTVDLE1BQWEsZUFBZ0IsU0FBUSx3QkFBZTs7Ozs7O0lBaURsRCxZQUFhLEtBQTRCO1FBQ3ZDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQzs7Ozs7O1FBakRSLGtCQUFhLEdBQUcsaUJBQWlCLENBQUM7Ozs7UUFrQy9CLG9CQUFlLEdBQW9CO1lBQzNDLE1BQU0sRUFBRTtnQkFDTixxQkFBcUI7Z0JBQ3JCLFlBQVk7YUFDYjtZQUNELE9BQU8sRUFBRTtnQkFDUCxXQUFXO2FBQ1o7U0FDRixDQUFDO0lBUUYsQ0FBQzs7Ozs7Ozs7SUEzQ00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMscUNBQXFDLENBQUMsQ0FBQztRQUMvQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7O0lBT00sWUFBWTtRQUNqQixJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDdEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00sV0FBVztRQUNoQixJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7UUFDckMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0NBbUJGO0FBcERELDBDQW9EQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gXCIuLi9zaGFyZWQvYWNjZXNzLWxldmVsXCI7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tIFwiLi4vc2hhcmVkXCI7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnRQcm9wcyB9IGZyb20gXCJAYXdzLWNkay9hd3MtaWFtXCI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgTW9iaWxlYW5hbHl0aWNzIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnbW9iaWxlYW5hbHl0aWNzJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldEZpbmFuY2lhbFJlcG9ydHMoKSB7XG4gICAgdGhpcy50bygnbW9iaWxlYW5hbHl0aWNzOkdldEZpbmFuY2lhbFJlcG9ydHMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRSZXBvcnRzKCkge1xuICAgIHRoaXMudG8oJ21vYmlsZWFuYWx5dGljczpHZXRSZXBvcnRzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvUHV0RXZlbnRzKCkge1xuICAgIHRoaXMudG8oJ21vYmlsZWFuYWx5dGljczpQdXRFdmVudHMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBcIlJlYWRcIjogW1xuICAgICAgXCJHZXRGaW5hbmNpYWxSZXBvcnRzXCIsXG4gICAgICBcIkdldFJlcG9ydHNcIlxuICAgIF0sXG4gICAgXCJXcml0ZVwiOiBbXG4gICAgICBcIlB1dEV2ZW50c1wiXG4gICAgXVxuICB9O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3IgKHByb3BzPzogUG9saWN5U3RhdGVtZW50UHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gIH1cbn1cbiJdfQ==