"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Support = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
 *
 * @experimental
 */
class Support extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'support';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AddAttachmentsToSet",
                "AddCommunicationToCase",
                "CreateCase",
                "InitiateCallForCase",
                "InitiateChatForCase",
                "PutCaseAttributes",
                "RateCaseCommunication",
                "RefreshTrustedAdvisorCheck",
                "ResolveCase"
            ],
            "Read": [
                "DescribeAttachment",
                "DescribeCaseAttributes",
                "DescribeCases",
                "DescribeCommunications",
                "DescribeIssueTypes",
                "DescribeServices",
                "DescribeSeverityLevels",
                "DescribeSupportLevel",
                "DescribeTrustedAdvisorCheckRefreshStatuses",
                "DescribeTrustedAdvisorCheckResult",
                "DescribeTrustedAdvisorCheckSummaries",
                "DescribeTrustedAdvisorChecks",
                "SearchForCases"
            ]
        };
    }
    /**
     * (experimental) Adds one or more attachments to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html
     *
     * @experimental
     */
    toAddAttachmentsToSet() {
        this.to('support:AddAttachmentsToSet');
        return this;
    }
    /**
     * (experimental) Adds a customer communication to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html
     *
     * @experimental
     */
    toAddCommunicationToCase() {
        this.to('support:AddCommunicationToCase');
        return this;
    }
    /**
     * (experimental) Creates a new AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html
     *
     * @experimental
     */
    toCreateCase() {
        this.to('support:CreateCase');
        return this;
    }
    /**
     * (experimental) Returns the description for an attachment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html
     *
     * @experimental
     */
    toDescribeAttachment() {
        this.to('support:DescribeAttachment');
        return this;
    }
    /**
     * (experimental) This is an internally managed function which allows secondary services to read AWS Support case attributes.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeCaseAttributes() {
        this.to('support:DescribeCaseAttributes');
        return this;
    }
    /**
     * (experimental) Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html
     *
     * @experimental
     */
    toDescribeCases() {
        this.to('support:DescribeCases');
        return this;
    }
    /**
     * (experimental) Returns the communications and attachments for one or more AWS Support cases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html
     *
     * @experimental
     */
    toDescribeCommunications() {
        this.to('support:DescribeCommunications');
        return this;
    }
    /**
     * (experimental) Returns issue types for AWS Support cases.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeIssueTypes() {
        this.to('support:DescribeIssueTypes');
        return this;
    }
    /**
     * (experimental) Returns the current list of AWS services and categories that applies to each service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html
     *
     * @experimental
     */
    toDescribeServices() {
        this.to('support:DescribeServices');
        return this;
    }
    /**
     * (experimental) Returns the list of severity levels that can be assigned to an AWS Support case.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html
     *
     * @experimental
     */
    toDescribeSeverityLevels() {
        this.to('support:DescribeSeverityLevels');
        return this;
    }
    /**
     * (experimental) Returns the support level for an AWS Account identifier.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeSupportLevel() {
        this.to('support:DescribeSupportLevel');
        return this;
    }
    /**
     * (experimental) Returns the status of a Trusted Advisor refresh check based on a list of check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorCheckRefreshStatuses() {
        this.to('support:DescribeTrustedAdvisorCheckRefreshStatuses');
        return this;
    }
    /**
     * (experimental) Returns the results of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorCheckResult() {
        this.to('support:DescribeTrustedAdvisorCheckResult');
        return this;
    }
    /**
     * (experimental) Returns the summaries of the results of the Trusted Advisor checks that have the specified check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorCheckSummaries() {
        this.to('support:DescribeTrustedAdvisorCheckSummaries');
        return this;
    }
    /**
     * (experimental) Returns a list of all available Trusted Advisor checks, including name, identifier, category and description.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorChecks() {
        this.to('support:DescribeTrustedAdvisorChecks');
        return this;
    }
    /**
     * (experimental) This is an internally managed function to initiate a call on AWS Support Center.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toInitiateCallForCase() {
        this.to('support:InitiateCallForCase');
        return this;
    }
    /**
     * (experimental) This is an internally managed function to initiate a chat on AWS Support Center.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toInitiateChatForCase() {
        this.to('support:InitiateChatForCase');
        return this;
    }
    /**
     * (experimental) This is an internally managed function which allows secondary services to attach attributes to AWS Support cases.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toPutCaseAttributes() {
        this.to('support:PutCaseAttributes');
        return this;
    }
    /**
     * (experimental) Rate an AWS Support case communication.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toRateCaseCommunication() {
        this.to('support:RateCaseCommunication');
        return this;
    }
    /**
     * (experimental) Requests a refresh of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html
     *
     * @experimental
     */
    toRefreshTrustedAdvisorCheck() {
        this.to('support:RefreshTrustedAdvisorCheck');
        return this;
    }
    /**
     * (experimental) Resolves an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html
     *
     * @experimental
     */
    toResolveCase() {
        this.to('support:ResolveCase');
        return this;
    }
    /**
     * (experimental) Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toSearchForCases() {
        this.to('support:SearchForCases');
        return this;
    }
}
exports.Support = Support;
//# sourceMappingURL=data:application/json;base64,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