"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wellarchitected = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [wellarchitected](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswell-architectedtool.html).
 *
 * @experimental
 */
class Wellarchitected extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [wellarchitected](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswell-architectedtool.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'wellarchitected';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AssociateLenses",
                "CreateMilestone",
                "CreateWorkload",
                "CreateWorkloadShare",
                "DeleteWorkload",
                "DeleteWorkloadShare",
                "DisassociateLenses",
                "UpdateAnswer",
                "UpdateLensReview",
                "UpdateShareInvitation",
                "UpdateWorkload",
                "UpdateWorkloadShare",
                "UpgradeLensReview"
            ],
            "Read": [
                "GetAnswer",
                "GetLensReview",
                "GetLensReviewReport",
                "GetLensVersionDifference",
                "GetMilestone",
                "GetWorkload"
            ],
            "List": [
                "ListAnswers",
                "ListLensReviewImprovements",
                "ListLensReviews",
                "ListLenses",
                "ListMilestones",
                "ListNotifications",
                "ListShareInvitations",
                "ListWorkloadShares",
                "ListWorkloads"
            ]
        };
    }
    /**
     * (experimental) Grants permission to associate a lens to the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-add.html
     *
     * @experimental
     */
    toAssociateLenses() {
        this.to('wellarchitected:AssociateLenses');
        return this;
    }
    /**
     * (experimental) Grants permission to create a new milestone for the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/milestones-save.html
     *
     * @experimental
     */
    toCreateMilestone() {
        this.to('wellarchitected:CreateMilestone');
        return this;
    }
    /**
     * (experimental) Grants permission to create a new workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html
     *
     * @experimental
     */
    toCreateWorkload() {
        this.to('wellarchitected:CreateWorkload');
        return this;
    }
    /**
     * (experimental) Grants permission to share a workload with another account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html
     *
     * @experimental
     */
    toCreateWorkloadShare() {
        this.to('wellarchitected:CreateWorkloadShare');
        return this;
    }
    /**
     * (experimental) Grants permission to delete an existing workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-delete.html
     *
     * @experimental
     */
    toDeleteWorkload() {
        this.to('wellarchitected:DeleteWorkload');
        return this;
    }
    /**
     * (experimental) Grants permission to delete an existing workload share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/sharing-remove.html
     *
     * @experimental
     */
    toDeleteWorkloadShare() {
        this.to('wellarchitected:DeleteWorkloadShare');
        return this;
    }
    /**
     * (experimental) Grants permission to disassociate a lens from the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-remove.html
     *
     * @experimental
     */
    toDisassociateLenses() {
        this.to('wellarchitected:DisassociateLenses');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve the specified answer from the specified lens review.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/start-workflow-review.html
     *
     * @experimental
     */
    toGetAnswer() {
        this.to('wellarchitected:GetAnswer');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve the specified lens review of the specified workload.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/start-workflow-review.html
     *
     * @experimental
     */
    toGetLensReview() {
        this.to('wellarchitected:GetLensReview');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve the report for the specified lens review.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-report.html
     *
     * @experimental
     */
    toGetLensReviewReport() {
        this.to('wellarchitected:GetLensReviewReport');
        return this;
    }
    /**
     * (experimental) Grants permission to get the difference between the specified lens version and latest available lens version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-upgrading.html
     *
     * @experimental
     */
    toGetLensVersionDifference() {
        this.to('wellarchitected:GetLensVersionDifference');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve the specified milestone of the specified workload.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/milestones-view.html
     *
     * @experimental
     */
    toGetMilestone() {
        this.to('wellarchitected:GetMilestone');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve the specified workload.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-page.html
     *
     * @experimental
     */
    toGetWorkload() {
        this.to('wellarchitected:GetWorkload');
        return this;
    }
    /**
     * (experimental) Grants permission to list the answers from the specified lens review.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/start-workflow-review.html
     *
     * @experimental
     */
    toListAnswers() {
        this.to('wellarchitected:ListAnswers');
        return this;
    }
    /**
     * (experimental) Grants permission to list the improvements of the specified lens review.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/tutorial-step3.html
     *
     * @experimental
     */
    toListLensReviewImprovements() {
        this.to('wellarchitected:ListLensReviewImprovements');
        return this;
    }
    /**
     * (experimental) Grants permission to list the lens reviews of the specified workload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-details.html
     *
     * @experimental
     */
    toListLensReviews() {
        this.to('wellarchitected:ListLensReviews');
        return this;
    }
    /**
     * (experimental) Grants permission to list the lenses available to this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses.html
     *
     * @experimental
     */
    toListLenses() {
        this.to('wellarchitected:ListLenses');
        return this;
    }
    /**
     * (experimental) Grants permission to list the milestones of the specified workload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/details-milestones.html
     *
     * @experimental
     */
    toListMilestones() {
        this.to('wellarchitected:ListMilestones');
        return this;
    }
    /**
     * (experimental) Grants permission to list notifications related to the account or specified resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-notifications.html
     *
     * @experimental
     */
    toListNotifications() {
        this.to('wellarchitected:ListNotifications');
        return this;
    }
    /**
     * (experimental) Grants permission to list the workload share invitations of the specified account or user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/invitations.html
     *
     * @experimental
     */
    toListShareInvitations() {
        this.to('wellarchitected:ListShareInvitations');
        return this;
    }
    /**
     * (experimental) Grants permission to list the workload shares of the specified workload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html
     *
     * @experimental
     */
    toListWorkloadShares() {
        this.to('wellarchitected:ListWorkloadShares');
        return this;
    }
    /**
     * (experimental) Grants permission to list the workloads in this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-page.html
     *
     * @experimental
     */
    toListWorkloads() {
        this.to('wellarchitected:ListWorkloads');
        return this;
    }
    /**
     * (experimental) Grants permission to update properties of the specified answer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/start-workflow-review.html
     *
     * @experimental
     */
    toUpdateAnswer() {
        this.to('wellarchitected:UpdateAnswer');
        return this;
    }
    /**
     * (experimental) Grants permission to update properties of the specified lens review.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-details.html
     *
     * @experimental
     */
    toUpdateLensReview() {
        this.to('wellarchitected:UpdateLensReview');
        return this;
    }
    /**
     * (experimental) Grants permission to update status of the specified workload share invitation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workload-sharing.html
     *
     * @experimental
     */
    toUpdateShareInvitation() {
        this.to('wellarchitected:UpdateShareInvitation');
        return this;
    }
    /**
     * (experimental) Grants permission to update properties of the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workload-edit.html
     *
     * @experimental
     */
    toUpdateWorkload() {
        this.to('wellarchitected:UpdateWorkload');
        return this;
    }
    /**
     * (experimental) Grants permission to update properties of the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workload-sharing.html
     *
     * @experimental
     */
    toUpdateWorkloadShare() {
        this.to('wellarchitected:UpdateWorkloadShare');
        return this;
    }
    /**
     * (experimental) Grants permission to upgrade the specified lens review to use the latest version of the associated lens.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-upgrading.html
     *
     * @experimental
     */
    toUpgradeLensReview() {
        this.to('wellarchitected:UpgradeLensReview');
        return this;
    }
    /**
     * (experimental) Adds a resource of type workload to the statement.
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/iam-auth-access.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onWorkload(resourceId, account, region, partition) {
        var arn = 'arn:${Partition}:wellarchitected:${Region}:${Account}:workload/${ResourceId}';
        arn = arn.replace('${ResourceId}', resourceId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
}
exports.Wellarchitected = Wellarchitected;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid2VsbC1hcmNoaXRlY3RlZHRvb2wuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ3ZWxsLWFyY2hpdGVjdGVkdG9vbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSxzQ0FBNEM7Ozs7OztBQVE1QyxNQUFhLGVBQWdCLFNBQVEsd0JBQWU7Ozs7OztJQStZbEQsWUFBYSxLQUE0QjtRQUN2QyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7Ozs7OztRQS9ZUixrQkFBYSxHQUFHLGlCQUFpQixDQUFDOzs7O1FBa1YvQixvQkFBZSxHQUFvQjtZQUMzQyxPQUFPLEVBQUU7Z0JBQ1AsaUJBQWlCO2dCQUNqQixpQkFBaUI7Z0JBQ2pCLGdCQUFnQjtnQkFDaEIscUJBQXFCO2dCQUNyQixnQkFBZ0I7Z0JBQ2hCLHFCQUFxQjtnQkFDckIsb0JBQW9CO2dCQUNwQixjQUFjO2dCQUNkLGtCQUFrQjtnQkFDbEIsdUJBQXVCO2dCQUN2QixnQkFBZ0I7Z0JBQ2hCLHFCQUFxQjtnQkFDckIsbUJBQW1CO2FBQ3BCO1lBQ0QsTUFBTSxFQUFFO2dCQUNOLFdBQVc7Z0JBQ1gsZUFBZTtnQkFDZixxQkFBcUI7Z0JBQ3JCLDBCQUEwQjtnQkFDMUIsY0FBYztnQkFDZCxhQUFhO2FBQ2Q7WUFDRCxNQUFNLEVBQUU7Z0JBQ04sYUFBYTtnQkFDYiw0QkFBNEI7Z0JBQzVCLGlCQUFpQjtnQkFDakIsWUFBWTtnQkFDWixnQkFBZ0I7Z0JBQ2hCLG1CQUFtQjtnQkFDbkIsc0JBQXNCO2dCQUN0QixvQkFBb0I7Z0JBQ3BCLGVBQWU7YUFDaEI7U0FDRixDQUFDO0lBMkJGLENBQUM7Ozs7Ozs7Ozs7SUF2WU0saUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxFQUFFLENBQUMsaUNBQWlDLENBQUMsQ0FBQztRQUMzQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7Ozs7SUFTTSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO1FBQzNDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7OztJQVNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsRUFBRSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDMUMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMscUNBQXFDLENBQUMsQ0FBQztRQUMvQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7Ozs7SUFTTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQzFDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7OztJQVNNLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsRUFBRSxDQUFDLHFDQUFxQyxDQUFDLENBQUM7UUFDL0MsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00sb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxFQUFFLENBQUMsb0NBQW9DLENBQUMsQ0FBQztRQUM5QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7Ozs7SUFTTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztRQUNyQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7Ozs7SUFTTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztRQUN6QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7Ozs7SUFTTSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDO1FBQy9DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7OztJQVNNLDBCQUEwQjtRQUMvQixJQUFJLENBQUMsRUFBRSxDQUFDLDBDQUEwQyxDQUFDLENBQUM7UUFDcEQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00sY0FBYztRQUNuQixJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7UUFDeEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00sYUFBYTtRQUNsQixJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7UUFDdkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00sYUFBYTtRQUNsQixJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7UUFDdkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00sNEJBQTRCO1FBQ2pDLElBQUksQ0FBQyxFQUFFLENBQUMsNENBQTRDLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7Ozs7SUFTTSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO1FBQzNDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7OztJQVNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLEVBQUUsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7OztJQVNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsRUFBRSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDMUMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00sbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztRQUM3QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7Ozs7SUFTTSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDO1FBQ2hELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7OztJQVNNLG9CQUFvQjtRQUN6QixJQUFJLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxDQUFDLENBQUM7UUFDOUMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00sZUFBZTtRQUNwQixJQUFJLENBQUMsRUFBRSxDQUFDLCtCQUErQixDQUFDLENBQUM7UUFDekMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00sY0FBYztRQUNuQixJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7UUFDeEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztRQUM1QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7Ozs7SUFTTSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDO1FBQ2pELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7OztJQVNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsRUFBRSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDMUMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7Ozs7O0lBU00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMscUNBQXFDLENBQUMsQ0FBQztRQUMvQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7Ozs7SUFTTSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDO1FBQzdDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7Ozs7O0lBaURNLFVBQVUsQ0FBQyxVQUFrQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3pGLElBQUksR0FBRyxHQUFHLDhFQUE4RSxDQUFDO1FBQ3pGLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGVBQWUsRUFBRSxVQUFVLENBQUMsQ0FBQztRQUMvQyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7UUFDOUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsSUFBSSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztDQVNGO0FBbFpELDBDQWtaQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gXCIuLi9zaGFyZWQvYWNjZXNzLWxldmVsXCI7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tIFwiLi4vc2hhcmVkXCI7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnRQcm9wcyB9IGZyb20gXCJAYXdzLWNkay9hd3MtaWFtXCI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBXZWxsYXJjaGl0ZWN0ZWQgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICd3ZWxsYXJjaGl0ZWN0ZWQnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9Bc3NvY2lhdGVMZW5zZXMoKSB7XG4gICAgdGhpcy50bygnd2VsbGFyY2hpdGVjdGVkOkFzc29jaWF0ZUxlbnNlcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NyZWF0ZU1pbGVzdG9uZSgpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6Q3JlYXRlTWlsZXN0b25lJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9DcmVhdGVXb3JrbG9hZCgpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6Q3JlYXRlV29ya2xvYWQnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NyZWF0ZVdvcmtsb2FkU2hhcmUoKSB7XG4gICAgdGhpcy50bygnd2VsbGFyY2hpdGVjdGVkOkNyZWF0ZVdvcmtsb2FkU2hhcmUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZWxldGVXb3JrbG9hZCgpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6RGVsZXRlV29ya2xvYWQnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVsZXRlV29ya2xvYWRTaGFyZSgpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6RGVsZXRlV29ya2xvYWRTaGFyZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGlzYXNzb2NpYXRlTGVuc2VzKCkge1xuICAgIHRoaXMudG8oJ3dlbGxhcmNoaXRlY3RlZDpEaXNhc3NvY2lhdGVMZW5zZXMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvR2V0QW5zd2VyKCkge1xuICAgIHRoaXMudG8oJ3dlbGxhcmNoaXRlY3RlZDpHZXRBbnN3ZXInKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvR2V0TGVuc1JldmlldygpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6R2V0TGVuc1JldmlldycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldExlbnNSZXZpZXdSZXBvcnQoKSB7XG4gICAgdGhpcy50bygnd2VsbGFyY2hpdGVjdGVkOkdldExlbnNSZXZpZXdSZXBvcnQnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldExlbnNWZXJzaW9uRGlmZmVyZW5jZSgpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6R2V0TGVuc1ZlcnNpb25EaWZmZXJlbmNlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRNaWxlc3RvbmUoKSB7XG4gICAgdGhpcy50bygnd2VsbGFyY2hpdGVjdGVkOkdldE1pbGVzdG9uZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRXb3JrbG9hZCgpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6R2V0V29ya2xvYWQnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0QW5zd2VycygpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6TGlzdEFuc3dlcnMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0xpc3RMZW5zUmV2aWV3SW1wcm92ZW1lbnRzKCkge1xuICAgIHRoaXMudG8oJ3dlbGxhcmNoaXRlY3RlZDpMaXN0TGVuc1Jldmlld0ltcHJvdmVtZW50cycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdExlbnNSZXZpZXdzKCkge1xuICAgIHRoaXMudG8oJ3dlbGxhcmNoaXRlY3RlZDpMaXN0TGVuc1Jldmlld3MnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0TGVuc2VzKCkge1xuICAgIHRoaXMudG8oJ3dlbGxhcmNoaXRlY3RlZDpMaXN0TGVuc2VzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0xpc3RNaWxlc3RvbmVzKCkge1xuICAgIHRoaXMudG8oJ3dlbGxhcmNoaXRlY3RlZDpMaXN0TWlsZXN0b25lcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0xpc3ROb3RpZmljYXRpb25zKCkge1xuICAgIHRoaXMudG8oJ3dlbGxhcmNoaXRlY3RlZDpMaXN0Tm90aWZpY2F0aW9ucycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdFNoYXJlSW52aXRhdGlvbnMoKSB7XG4gICAgdGhpcy50bygnd2VsbGFyY2hpdGVjdGVkOkxpc3RTaGFyZUludml0YXRpb25zJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0V29ya2xvYWRTaGFyZXMoKSB7XG4gICAgdGhpcy50bygnd2VsbGFyY2hpdGVjdGVkOkxpc3RXb3JrbG9hZFNoYXJlcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0V29ya2xvYWRzKCkge1xuICAgIHRoaXMudG8oJ3dlbGxhcmNoaXRlY3RlZDpMaXN0V29ya2xvYWRzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1VwZGF0ZUFuc3dlcigpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6VXBkYXRlQW5zd2VyJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVMZW5zUmV2aWV3KCkge1xuICAgIHRoaXMudG8oJ3dlbGxhcmNoaXRlY3RlZDpVcGRhdGVMZW5zUmV2aWV3Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVTaGFyZUludml0YXRpb24oKSB7XG4gICAgdGhpcy50bygnd2VsbGFyY2hpdGVjdGVkOlVwZGF0ZVNoYXJlSW52aXRhdGlvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVXb3JrbG9hZCgpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6VXBkYXRlV29ya2xvYWQnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvVXBkYXRlV29ya2xvYWRTaGFyZSgpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6VXBkYXRlV29ya2xvYWRTaGFyZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGdyYWRlTGVuc1JldmlldygpIHtcbiAgICB0aGlzLnRvKCd3ZWxsYXJjaGl0ZWN0ZWQ6VXBncmFkZUxlbnNSZXZpZXcnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBcIldyaXRlXCI6IFtcbiAgICAgIFwiQXNzb2NpYXRlTGVuc2VzXCIsXG4gICAgICBcIkNyZWF0ZU1pbGVzdG9uZVwiLFxuICAgICAgXCJDcmVhdGVXb3JrbG9hZFwiLFxuICAgICAgXCJDcmVhdGVXb3JrbG9hZFNoYXJlXCIsXG4gICAgICBcIkRlbGV0ZVdvcmtsb2FkXCIsXG4gICAgICBcIkRlbGV0ZVdvcmtsb2FkU2hhcmVcIixcbiAgICAgIFwiRGlzYXNzb2NpYXRlTGVuc2VzXCIsXG4gICAgICBcIlVwZGF0ZUFuc3dlclwiLFxuICAgICAgXCJVcGRhdGVMZW5zUmV2aWV3XCIsXG4gICAgICBcIlVwZGF0ZVNoYXJlSW52aXRhdGlvblwiLFxuICAgICAgXCJVcGRhdGVXb3JrbG9hZFwiLFxuICAgICAgXCJVcGRhdGVXb3JrbG9hZFNoYXJlXCIsXG4gICAgICBcIlVwZ3JhZGVMZW5zUmV2aWV3XCJcbiAgICBdLFxuICAgIFwiUmVhZFwiOiBbXG4gICAgICBcIkdldEFuc3dlclwiLFxuICAgICAgXCJHZXRMZW5zUmV2aWV3XCIsXG4gICAgICBcIkdldExlbnNSZXZpZXdSZXBvcnRcIixcbiAgICAgIFwiR2V0TGVuc1ZlcnNpb25EaWZmZXJlbmNlXCIsXG4gICAgICBcIkdldE1pbGVzdG9uZVwiLFxuICAgICAgXCJHZXRXb3JrbG9hZFwiXG4gICAgXSxcbiAgICBcIkxpc3RcIjogW1xuICAgICAgXCJMaXN0QW5zd2Vyc1wiLFxuICAgICAgXCJMaXN0TGVuc1Jldmlld0ltcHJvdmVtZW50c1wiLFxuICAgICAgXCJMaXN0TGVuc1Jldmlld3NcIixcbiAgICAgIFwiTGlzdExlbnNlc1wiLFxuICAgICAgXCJMaXN0TWlsZXN0b25lc1wiLFxuICAgICAgXCJMaXN0Tm90aWZpY2F0aW9uc1wiLFxuICAgICAgXCJMaXN0U2hhcmVJbnZpdGF0aW9uc1wiLFxuICAgICAgXCJMaXN0V29ya2xvYWRTaGFyZXNcIixcbiAgICAgIFwiTGlzdFdvcmtsb2Fkc1wiXG4gICAgXVxuICB9O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIG9uV29ya2xvYWQocmVzb3VyY2VJZDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHZhciBhcm4gPSAnYXJuOiR7UGFydGl0aW9ufTp3ZWxsYXJjaGl0ZWN0ZWQ6JHtSZWdpb259OiR7QWNjb3VudH06d29ya2xvYWQvJHtSZXNvdXJjZUlkfSc7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UmVzb3VyY2VJZH0nLCByZXNvdXJjZUlkKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBjb25zdHJ1Y3RvciAocHJvcHM/OiBQb2xpY3lTdGF0ZW1lbnRQcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgfVxufVxuIl19