"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithEffect = void 0;
// This file is used in the CDK variant of the package: cdk-iam-floyd
// @ts-ignore only available running bin/mkcdk
const iam = require("@aws-cdk/aws-iam");
const _4_resources_1 = require("./4-resources");
/**
 * (experimental) Adds "effect" functionality to the Policy Statement.
 *
 * @experimental
 */
class PolicyStatementWithEffect extends _4_resources_1.PolicyStatementWithResources {
    /**
     * (experimental) Injects effect into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     *
     * @experimental
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            return super.toJSON();
        }
        const statement = super.toJSON();
        // @ts-ignore only available after swapping 1-base
        statement.Effect = this.effect;
        return statement;
    }
    /**
     * (experimental) Allow the actions in this statement.
     *
     * @experimental
     */
    allow() {
        // @ts-ignore only available after swapping 1-base
        this.effect = iam.Effect.ALLOW;
        return this;
    }
    /**
     * (experimental) Deny the actions in this statement.
     *
     * @experimental
     */
    deny() {
        // @ts-ignore only available after swapping 1-base
        this.effect = iam.Effect.DENY;
        return this;
    }
}
exports.PolicyStatementWithEffect = PolicyStatementWithEffect;
//# sourceMappingURL=data:application/json;base64,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