import ibis.expr.types as ir
from typing import Any, Callable, Sequence
from vinyl.lib.column import VinylColumn as VinylColumn
from vinyl.lib.column_methods import ColumnBuilder as ColumnBuilder, ColumnListBuilder as ColumnListBuilder, column_type as column_type
from vinyl.lib.enums import FillOptions as FillOptions, WindowType as WindowType
from vinyl.lib.table import VinylTable as VinylTable

class Metric:
    def __init__(self, tbl: VinylTable, agg: Callable[..., Any], ts: Callable[..., Any], by: column_type, fill=...) -> None: ...

class MetricStore:
    __dict__: dict[str, Any]
    def __init__(self, metrics: Sequence[Metric] = [], derived_metrics: dict[str, ir.Deferred] = {}, default_tbl: VinylTable | None = None) -> None: ...
    def __getattr__(self, name) -> VinylColumn: ...
    def copy(self) -> MetricStore: ...
    def __add__(self, other: MetricStore) -> MetricStore: ...
    def __radd__(self, other: MetricStore) -> MetricStore: ...
    def __call__(self): ...
    def __enter__(self): ...
    def __exit__(self, exc_type: type[BaseException] | None, exc_value: BaseException | None, traceback: types.TracebackType | None) -> None: ...
    def select(self, cols: column_type, trailing: list[int | None] = [None]) -> VinylTable: ...
    def metric(self, cols: ir.Scalar | Callable[..., ir.Scalar] | list[ir.Scalar | Callable[..., ir.Scalar]] | dict[str, ir.Scalar | Callable[..., ir.Scalar]], ts: ir.TimestampValue | Callable[..., ir.TimestampValue], by: ir.Value | Callable[..., ir.Value] | Sequence[ir.Value | Callable[..., ir.Value]] = [], fill: FillOptions | Callable[..., Any] = ..., tbl: VinylTable | None = None): ...
    def derive(self, metrics: ir.Scalar | Callable[..., ir.Scalar] | list[ir.Scalar | Callable[..., ir.Scalar]] | dict[str, ir.Scalar | Callable[..., ir.Scalar]]):
        """
        Add a derived metric to the MetricStore. Derived metrics are calculated from existing metrics in the MetricStore.

        Please do not include any other columns in the derived metric. This could cause unexpected behavior.
        """
    def trailing(self, intervals: list[int | None] = [None]): ...

class MetricSelect:
    def __init__(self, MetricStore: MetricStore, cols: list[ir.Value], intervals: list[int | None] = [None]) -> None: ...
