from django.urls import path
from . import views

urlpatterns = [
    path('auth/', views.FacebookAuthURLView.as_view(), name='facebook_auth'),
    path('auth/callback/', views.FacebookAuthCallbackView.as_view(), name='facebook_auth_callback'),
    path('webhook/', views.webhook, name='facebook_webhook'),
    path('scrap-group-members/', views.scrap_facebook_group_members_api, name='scrap_group_members_api'),
    path('send-first-message/', views.send_first_message_api, name='send_first_message_api'),
    path('scrap-group-members-view/', views.scrap_facebook_group_members_view, name='scrap_group_members_view'),
    path('send-first-message-view/', views.send_first_message_view, name='send_first_message_view'),
    path('users/<str:user_id>/', views.FacebookUserView.as_view(), name='facebook_user'),
    path('users/me/', views.FacebookUserView.as_view(), name='facebook_user_me'),
    path('users/<str:user_id>/accounts/', views.FacebookUserAccountsView.as_view(), name='facebook_user_accounts'),
    path('users/<str:user_id>/permissions/', views.FacebookUserPermissionsView.as_view(), name='facebook_user_permissions'),
    path('pages/<str:page_id>/', views.FacebookPageView.as_view(), name='facebook_page'),
    path('pages/<str:page_id>/insights/', views.FacebookPageInsightsView.as_view(), name='facebook_page_insights'),
    path('pages/<str:page_id>/conversations/', views.FacebookPageConversationsView.as_view(), name='facebook_page_conversations'),
    path('pages/<str:page_id>/posts/', views.FacebookPostsView.as_view(), name='facebook_posts'),
    path('posts/<str:post_id>/', views.FacebookPostView.as_view(), name='facebook_post'),
    path('posts/<str:post_id>/likes/', views.FacebookPostLikesView.as_view(), name='facebook_post_likes'),
    path('posts/<str:post_id>/comments/', views.FacebookPostCommentsView.as_view(), name='facebook_post_comments'),
    path('comments/<str:comment_id>/', views.FacebookCommentView.as_view(), name='facebook_comment'),
    path('messages/', views.FacebookMessagesView.as_view(), name='facebook_messages'),
    path('messenger-profile/', views.FacebookMessengerProfileView.as_view(), name='facebook_messenger_profile'),
    path('pages/<str:page_id>/photos/', views.FacebookPhotosView.as_view(), name='facebook_photos'),
    path('pages/<str:page_id>/videos/', views.FacebookVideosView.as_view(), name='facebook_videos'),
    path('pages/<str:page_id>/albums/', views.FacebookAlbumsView.as_view(), name='facebook_albums'),
    path('pages/<str:page_id>/events/', views.FacebookEventsView.as_view(), name='facebook_events'),
    path('events/<str:event_id>/', views.FacebookEventView.as_view(), name='facebook_event'),
    path('groups/<str:group_id>/', views.FacebookGroupView.as_view(), name='facebook_group'),
    path('groups/<str:group_id>/feed/', views.FacebookGroupFeedView.as_view(), name='facebook_group_feed'),
    path('pages/<str:page_id>/subscriptions/', views.FacebookWebhookSubscriptionsView.as_view(), name='facebook_webhook_subscriptions'),
    path('pages/<str:page_id>/leadgen-forms/', views.FacebookLeadGenFormsView.as_view(), name='facebook_leadgen_forms'),
    path('leadgen-forms/<str:form_id>/leads/', views.FacebookLeadsView.as_view(), name='facebook_leads'),
    path('pages/<str:page_id>/instagram-account/', views.FacebookInstagramAccountView.as_view(), name='facebook_instagram_account'),
    path('instagram/<str:instagram_account_id>/media/', views.FacebookInstagramMediaView.as_view(), name='facebook_instagram_media'),
    path('debug-token/', views.FacebookDebugTokenView.as_view(), name='facebook_debug_token'),
    path('batch/', views.FacebookBatchRequestView.as_view(), name='facebook_batch'),
]