from django.urls import path
from . import views

urlpatterns = [
    path('accounts/', views.LinkedInAccountsView.as_view(), name='linkedin_accounts'),
    path('accounts/checkpoint/', views.LinkedInSolveCheckpointView.as_view(), name='linkedin_account_checkpoint'),
    path('accounts/<str:account_id>/', views.LinkedInAccountView.as_view(), name='linkedin_account'),    
    path('accounts/<str:account_id>/chats/', views.LinkedInChatsView.as_view(), name='linkedin_chats'),
    path('accounts/chats/all_attendees/', views.LinkedinChatAttendeesView.as_view(), name='linkedin_chat_attendees'),
    path('accounts/chats/all_attendees/<str:attendee_id>/', views.LinkedInChatAttendeeView.as_view(), name='linkedin_chat_attendee'),
    path('accounts/chats/all_attendees/<str:attendee_id>/chats/', views.LinkedInChatAttendeeChatView.as_view(), name='linkedin_chat_attendee_chats'),
    path('accounts/chats/all_attendees/<str:sender_id>/messages/', views.LinkedInChatAttendeeMessagesView.as_view(), name='linkedin_chat_attendee_messages'),
    path('accounts/<str:account_id>/messages/<str:message_id>/', views.LinkedInMessageView.as_view(), name='linkedin_message'),
    path('accounts/<str:account_id>/chats/<str:chat_id>/', views.LinkedInChatView.as_view(), name='linkedin_chat'),
    path('accounts/<str:account_id>/chats/<str:chat_id>/messages/', views.LinkedInMessagesView.as_view(), name='linkedin_messages'),
    path('accounts/<str:account_id>/chats/<str:chat_id>/attendees/', views.LinkedInListAttendeesChatView.as_view(), name='linkedin_chat_attendees_messages'),
    path('accounts/<str:account_id>/chats/<str:chat_id>/sync/', views.LinkedInChatSyncView.as_view(), name='linkedin_chat_sync'),
    path('accounts/<str:account_id>/messages/<str:message_id>/attachments/<str:attachment_id>/', views.LinkedinRetrieveAttachmentView.as_view(), name='linkedin_message_attachments'),
    path('accounts/<str:account_id>/users/invitations/sent/', views.LinkedInUserInvitationsSentView.as_view(), name='linkedin_user_invitations_sent'),
    path('accounts/<str:account_id>/users/invitations/received/', views.LinkedInUserInvitationReceivedView.as_view(), name='linkedin_user_invitations_received'),
    path('users/invitations/<str:invitation_id>/handle/', views.LinkedInUserInvitationHandleView.as_view(), name='linkedin_user_invitation_handle'),
    path('accounts/<str:account_id>/users/invitations/send/', views.LinkedInUsersSendInvitationView.as_view(), name='linkedin_users_send_invitation'),
    path('accounts/<str:account_id>/users/profile/', views.LinkedInUserProfileView.as_view(), name='linkedin_user_profile'),
    path('accounts/<str:account_id>/users/profile/edit/', views.LinkedInUserProfileEditView.as_view(), name='linkedin_user_profile_edit'),
    path('accounts/<str:account_id>/users/relations/', views.LinkedInUserRelationsView.as_view(), name='linkedin_user_relations'),
    path('accounts/<str:account_id>/users/followers/', views.LinkedInUserFollowersView.as_view(), name='linkedin_user_followers'),
    path('accounts/<str:account_id>/users/<str:identifier>/profile/', views.LinkedInUserRetrieveProfileView.as_view(), name='linkedin_user_retrieve_profile'),
    path('accounts/<str:account_id>/users/<str:identifier>/posts/', views.LinkedInUserPostsView.as_view(), name='linkedin_user_posts'),
    path('accounts/<str:account_id>/users/<str:identifier>/comments/', views.LinkedInUserCommentsView.as_view(), name='linkedin_user_comments'),
    path('accounts/<str:account_id>/users/<str:identifier>/reactions/', views.LinkedInUserReactionsView.as_view(), name='linkedin_user_reactions'),
    path('accounts/<str:account_id>/posts/<str:post_id>/', views.LinkedInPostRetrieveView.as_view(), name='linkedin_post_retrieve'),
    path('accounts/<str:account_id>/posts/', views.LinkedInPostView.as_view(), name='linkedin_create_post'),
    path('accounts/<str:account_id>/posts/<str:post_id>/comments/', views.LinkedInPostCommentsView.as_view(), name='linkedin_post_comments'),
    path('accounts/<str:account_id>/posts/<str:post_id>/reactions/', views.LinkedInPostReactionsView.as_view(), name='linkedin_post_reactions'),
    path('accounts/<str:account_id>/company/<str:identifier>/', views.LinkedInCompanyProfileView.as_view(), name='linkedin_company_profile'),
    path('accounts/<str:account_id>/inmail/balance/', views.LinkedInInMailBalanceView.as_view(), name='linkedin_inmail_balance'),
    path('accounts/<str:account_id>/search/parameters/', views.LinkedInSearchParametersView.as_view(), name='linkedin_search_parameters'),
    path('accounts/<str:account_id>/search/', views.LinkedInSearchView.as_view(), name='linkedin_search'),
    path('accounts/<str:account_id>/jobs/', views.LinkedInJobPostingsView.as_view(), name='linkedin_job_postings'),
    path('accounts/<str:account_id>/jobs/<str:job_id>/applicants/', views.LinkedInJobApplicantsView.as_view(), name='linkedin_job_applicants'),
    path('accounts/<str:account_id>/webhooks/', views.LinkedInWebhooksView.as_view(), name='linkedin_webhooks'),
    path('accounts/<str:account_id>/webhooks/<str:webhook_id>/', views.LinkedInWebhookView.as_view(), name='linkedin_webhook'),
]