## Device IP配置说明

此脚本的作用是修改NPU板卡IP地址，可利用ansible工具的批量部署能力实现批量配置，以下内容仅供有批量配置使用场景的用户参考使用。

### 数据准备

- 服务器的操作系统IP（OS IP）地址文件
- 服务器的操作系统用户名和密码
- 待配置的Device IP地址文件
- Device IP配置脚本（DeviceIP-conf.sh）

### 说明

- Device IP指的是待修改的NPU板卡IP地址。
- 服务器的操作系统IP（OS IP）地址文件和待配置的Device IP地址文件的格式请参考<a href="#IP格式说明">OS IP地址和Device IP地址格式说明</a>。
- 批量操作不支持混合设备类型，即所选设备的设备类型、NPU标卡数量及配置的IP地址个数、工作模式必须一致。
- 每台服务器有2块NPU板，每块NPU板有4个NPU芯片。SMP模式下每块NPU板上的4个NPU芯片需要配置4个不同网段的IP地址。

### 操作步骤

1. 将OS IP地址文件、Device IP地址文件、Device IP配置脚本上传到目标主机的指定目录（例如分别是/root/uploadosip、/root/uploaddeviceip、/root/uploaddeviceip）。

2. 在目标主机指定目录（例如/root/uploaddeviceip）执行命令
   
   ```
   bash DeviceIP-conf.sh [ 设备类型 ] [ NPU标卡数量 ] [ NPU标卡IP配置 ] [ 工作模式 ] [ OS IP地址文件 ] [ Device IP地址文件 ]
   ```
   
   以8个非标NPU板卡的采用SMP模式的A800-9000为例，命令为
   
   ```
   bash DeviceIP-conf.sh 1 0 0 SMP /root/uploadosip/OS_IP /root/uploaddeviceip/Device_IP
   ```

| 参数        | 参数说明            | 参数取值 | 备注                                        |
|:---------:|:---------------:|:----:|:-----------------------------------------:|
| 设备类型      | 8个NPU的A800-9000 | 1    | npu-smi info查询NPU数量为8，则输入1，查询NPU数量为4，则输入2 |
| NPU标卡数量   | 不是NPU标卡         | 0    | 同NPU标卡数量，A800-9000请设置为0                   |
| NPU标卡IP配置 | 不是NPU标卡         | 0    | 同NPU标卡IP数量，A800-9000请设置为0                 |
| 工作模式      | SMP             | 0    | 根据实际配置，SMP(对称多处理器模式）、AMP（非对称多处理器模式）       |

### <a name="IP格式说明">OS IP地址和Device IP地址格式说明</a>

需要将这2个文件转换为UNIX格式

1. OS IP地址文件
- 格式1（推荐）
  IP地址段，类似这个IPx-IPy，以回车结束，例如：
  
  ```
  10.80.100.101~10.80.100.104
  ```

- 格式2
  IP地址清单，逐一给出OS IP地址，以回车结束，例如：
  
  ```
  10.80.100.101
  10.80.100.102
  10.80.100.103
  10.80.100.104
  ```
2. Device IP地址文件
- 格式1（推荐）
  IP地址段，类似这个IPx-IPy/Netmask/Gateway的格式，SMP模式下每块NPU板上的4个NPU芯片需要配置4个不同网段的Device IP地址，以回车结束，例如：
  
  ```
  172.168.1.100~172.168.1.107/255.255.255.0/172.168.1.1
  172.168.2.100~172.168.2.107/255.255.255.0/172.168.2.1
  172.168.3.100~172.168.3.107/255.255.255.0/172.168.3.1
  172.168.4.100~172.168.4.107/255.255.255.0/172.168.4.1
  ```

- 格式2
  IP地址清单，类似这个IP/Netmask/Gateway的格式，逐一给出OS IP地址，以回车结束，例如：
  
  ```
  172.168.1.100/255.255.255.0/172.168.1.1
  172.168.2.100/255.255.255.0/172.168.2.1
  172.168.3.100/255.255.255.0/172.168.3.1
  172.168.4.100/255.255.255.0/172.168.4.1
  ```
