import sqlalchemy as sa
from sqlalchemy.orm import Mapped, mapped_column

from profcomff_definitions.base import Base


class OrgInfo(Base):
    id: Mapped[str] = mapped_column(primary_key=True)
    login: Mapped[str | None]
    node_id: Mapped[str | None]
    url: Mapped[str | None]
    repos_url: Mapped[str | None]
    events_url: Mapped[str | None]
    hooks_url: Mapped[str | None]
    issues_url: Mapped[str | None]
    members_url: Mapped[str | None]
    public_members_url: Mapped[str | None]
    avatar_url: Mapped[str | None]
    description: Mapped[str | None]
    name: Mapped[str | None]
    company: Mapped[str | None]
    blog: Mapped[str | None]
    location: Mapped[str | None]
    email: Mapped[str | None]
    twitter_username: Mapped[str | None]
    is_verified: Mapped[str | None]
    has_organization_projects: Mapped[str | None]
    has_repository_projects: Mapped[str | None]
    public_repos: Mapped[str | None]
    public_gists: Mapped[str | None]
    followers: Mapped[str | None]
    following: Mapped[str | None]
    html_url: Mapped[str | None]
    created_at: Mapped[str | None]
    updated_at: Mapped[str | None]
    archived_at: Mapped[str | None]
    type: Mapped[str | None]
    total_private_repos: Mapped[str | None]
    owned_private_repos: Mapped[str | None]
    private_gists: Mapped[str | None]
    disk_usage: Mapped[str | None]
    collaborators: Mapped[str | None]
    billing_email: Mapped[str | None]
    default_repository_permission: Mapped[str | None]
    members_can_create_repositories: Mapped[str | None]
    two_factor_requirement_enabled: Mapped[str | None]
    members_allowed_repository_creation_type: Mapped[str | None]
    members_can_create_public_repositories: Mapped[str | None]
    members_can_create_private_repositories: Mapped[str | None]
    members_can_create_internal_repositories: Mapped[str | None]
    members_can_create_pages: Mapped[str | None]
    members_can_fork_private_repositories: Mapped[str | None]
    web_commit_signoff_required: Mapped[str | None]
    members_can_create_public_pages: Mapped[str | None]
    members_can_create_private_pages: Mapped[str | None]
    plan_name: Mapped[str | None]
    plan_space: Mapped[str | None]
    plan_private_repos: Mapped[str | None]
    plan_filled_seats: Mapped[str | None]
    plan_seats: Mapped[str | None]
    advanced_security_enabled_for_new_repositories: Mapped[str | None]
    dependabot_alerts_enabled_for_new_repositories: Mapped[str | None]
    dependabot_security_updates_enabled_for_new_repositories: Mapped[str | None]
    dependency_graph_enabled_for_new_repositories: Mapped[str | None]
    secret_scanning_enabled_for_new_repositories: Mapped[str | None]
    secret_scanning_push_protection_enabled_for_new_repositories: Mapped[str | None]
    secret_scanning_push_protection_custom_link_enabled: Mapped[str | None]
    secret_scanning_push_protection_custom_link: Mapped[str | None]
    secret_scanning_validity_checks_enabled: Mapped[str | None]


class ProfcomffInvation(Base):
    id: Mapped[int] = mapped_column(primary_key=True)
    node_id: Mapped[str | None]
    login: Mapped[str | None]
    email: Mapped[str | None]
    role: Mapped[str | None]
    created_at: Mapped[str | None]
    failed_at: Mapped[str | None]
    failed_reason: Mapped[str | None]
    inviter_login: Mapped[str | None]
    inviter_id: Mapped[int | None]
    inviter_node_id: Mapped[str | None]
    inviter_avatar_url: Mapped[str | None]
    inviter_gravatar_id: Mapped[str | None]
    inviter_url: Mapped[str | None]
    inviter_html_url: Mapped[str | None]
    inviter_followers_url: Mapped[str | None]
    inviter_following_url: Mapped[str | None]
    inviter_gists_url: Mapped[str | None]
    inviter_starred_url: Mapped[str | None]
    inviter_subscriptions_url: Mapped[str | None]
    inviter_organizations_url: Mapped[str | None]
    inviter_repos_url: Mapped[str | None]
    inviter_events_url: Mapped[str | None]
    inviter_received_events_url: Mapped[str | None]
    inviter_type: Mapped[str | None]
    inviter_site_admin: Mapped[bool | None]
    team_count: Mapped[int | None]
    invitation_teams_url: Mapped[str | None]
    invitation_source: Mapped[str | None]


class ProfcomffMember(Base):
    id: Mapped[int] = mapped_column(primary_key=True)
    login: Mapped[str | None]
    node_id: Mapped[str | None]
    avatar_url: Mapped[str | None]
    gravatar_id: Mapped[str | None]
    url: Mapped[str | None]
    html_url: Mapped[str | None]
    followers_url: Mapped[str | None]
    following_url: Mapped[str | None]
    gists_url: Mapped[str | None]
    starred_url: Mapped[str | None]
    subscriptions_url: Mapped[str | None]
    organizations_url: Mapped[str | None]
    repos_url: Mapped[str | None]
    events_url: Mapped[str | None]
    received_events_url: Mapped[str | None]
    type: Mapped[str | None]
    site_admin: Mapped[bool | None]


class ProfcomffRepo(Base):
    id: Mapped[int] = mapped_column(primary_key=True)
    node_id: Mapped[str | None]
    name: Mapped[str | None]
    full_name: Mapped[str | None]
    private: Mapped[bool | None]
    owner_login: Mapped[str | None]
    owner_id: Mapped[int | None]
    owner_node_id: Mapped[str | None]
    owner_avatar_url: Mapped[str | None]
    owner_gravatar_id: Mapped[str | None]
    owner_url: Mapped[str | None]
    owner_html_url: Mapped[str | None]
    owner_followers_url: Mapped[str | None]
    owner_following_url: Mapped[str | None]
    owner_gists_url: Mapped[str | None]
    owner_starred_url: Mapped[str | None]
    owner_subscriptions_url: Mapped[str | None]
    owner_organizations_url: Mapped[str | None]
    owner_repos_url: Mapped[str | None]
    owner_events_url: Mapped[str | None]
    owner_received_events_url: Mapped[str | None]
    owner_type: Mapped[str | None]
    owner_site_admin: Mapped[bool | None]
    html_url: Mapped[str | None]
    description: Mapped[str | None]
    fork: Mapped[bool | None]
    url: Mapped[str | None]
    forks_url: Mapped[str | None]
    keys_url: Mapped[str | None]
    collaborators_url: Mapped[str | None]
    teams_url: Mapped[str | None]
    hooks_url: Mapped[str | None]
    issue_events_url: Mapped[str | None]
    events_url: Mapped[str | None]
    assignees_url: Mapped[str | None]
    branches_url: Mapped[str | None]
    tags_url: Mapped[str | None]
    blobs_url: Mapped[str | None]
    git_tags_url: Mapped[str | None]
    git_refs_url: Mapped[str | None]
    trees_url: Mapped[str | None]
    statuses_url: Mapped[str | None]
    languages_url: Mapped[str | None]
    stargazers_url: Mapped[str | None]
    contributors_url: Mapped[str | None]
    subscribers_url: Mapped[str | None]
    subscription_url: Mapped[str | None]
    commits_url: Mapped[str | None]
    git_commits_url: Mapped[str | None]
    comments_url: Mapped[str | None]
    issue_comment_url: Mapped[str | None]
    contents_url: Mapped[str | None]
    compare_url: Mapped[str | None]
    merges_url: Mapped[str | None]
    archive_url: Mapped[str | None]
    downloads_url: Mapped[str | None]
    issues_url: Mapped[str | None]
    pulls_url: Mapped[str | None]
    milestones_url: Mapped[str | None]
    notifications_url: Mapped[str | None]
    labels_url: Mapped[str | None]
    releases_url: Mapped[str | None]
    deployments_url: Mapped[str | None]
    created_at: Mapped[str | None]
    updated_at: Mapped[str | None]
    pushed_at: Mapped[str | None]
    git_url: Mapped[str | None]
    ssh_url: Mapped[str | None]
    clone_url: Mapped[str | None]
    svn_url: Mapped[str | None]
    homepage: Mapped[str | None]
    size: Mapped[int | None]
    stargazers_count: Mapped[int | None]
    watchers_count: Mapped[int | None]
    language: Mapped[str | None]
    has_issues: Mapped[bool | None]
    has_projects: Mapped[bool | None]
    has_downloads: Mapped[bool | None]
    has_wiki: Mapped[bool | None]
    has_pages: Mapped[bool | None]
    has_discussions: Mapped[bool | None]
    forks_count: Mapped[int | None]
    mirror_url: Mapped[str | None]
    archived: Mapped[bool | None]
    disabled: Mapped[bool | None]
    open_issues_count: Mapped[int | None]
    license: Mapped[int | None]
    allow_forking: Mapped[bool | None]
    is_template: Mapped[bool | None]
    web_commit_signoff_required: Mapped[bool | None]
    topics: Mapped[str | None]
    visibility: Mapped[str | None]
    forks: Mapped[int | None]
    open_issues: Mapped[int | None]
    watchers: Mapped[int | None]
    default_branch: Mapped[str | None]
    permissions_admin: Mapped[bool | None]
    permissions_maintain: Mapped[bool | None]
    permissions_push: Mapped[bool | None]
    permissions_triage: Mapped[bool | None]
    permissions_pull: Mapped[bool | None]
    license_key: Mapped[str | None]
    license_name: Mapped[str | None]
    license_spdx_id: Mapped[str | None]
    license_url: Mapped[str | None]
    license_node_id: Mapped[str | None]
    security_and_analysis_secret_scanning_status: Mapped[str | None]
    security_and_analysis_secret_scanning_push_protection_status: Mapped[str | None]
    security_and_analysis_dependabot_security_updates_status: Mapped[str | None]
    security_and_analysis_secret_scanning_validity_checks_status: Mapped[str | None]


class ProfcomffTeam(Base):
    id: Mapped[int] = mapped_column(primary_key=True)
    name: Mapped[str | None]
    node_id: Mapped[str | None]
    slug: Mapped[str | None]
    description: Mapped[str | None]
    privacy: Mapped[str | None]
    notification_setting: Mapped[str | None]
    url: Mapped[str | None]
    html_url: Mapped[str | None]
    members_url: Mapped[str | None]
    repositories_url: Mapped[str | None]
    permission: Mapped[str | None]
    parent: Mapped[str | None]


class ProfcomffTeamMember(Base):
    id: Mapped[int] = mapped_column(primary_key=True)
    team_id: Mapped[int] = mapped_column(primary_key=True)
    login: Mapped[str | None]
    node_id: Mapped[str | None]
    avatar_url: Mapped[str | None]
    gravatar_id: Mapped[str | None]
    url: Mapped[str | None]
    html_url: Mapped[str | None]
    followers_url: Mapped[str | None]
    following_url: Mapped[str | None]
    gists_url: Mapped[str | None]
    starred_url: Mapped[str | None]
    subscriptions_url: Mapped[str | None]
    organizations_url: Mapped[str | None]
    repos_url: Mapped[str | None]
    events_url: Mapped[str | None]
    received_events_url: Mapped[str | None]
    type: Mapped[str | None]
    site_admin: Mapped[bool | None]


class ProfcomffTeamRepo(Base):
    id: Mapped[int] = mapped_column(primary_key=True)
    team_id: Mapped[int] = mapped_column(primary_key=True)
    node_id: Mapped[str | None]
    name: Mapped[str | None]
    full_name: Mapped[str | None]
    private: Mapped[str | None]
    owner_login: Mapped[str | None]
    owner_id: Mapped[int | None]
    owner_node_id: Mapped[str | None]
    owner_avatar_url: Mapped[str | None]
    owner_gravatar_id: Mapped[str | None]
    owner_url: Mapped[str | None]
    owner_html_url: Mapped[str | None]
    owner_followers_url: Mapped[str | None]
    owner_following_url: Mapped[str | None]
    owner_gists_url: Mapped[str | None]
    owner_starred_url: Mapped[str | None]
    owner_subscriptions_url: Mapped[str | None]
    owner_organizations_url: Mapped[str | None]
    owner_repos_url: Mapped[str | None]
    owner_events_url: Mapped[str | None]
    owner_received_events_url: Mapped[str | None]
    owner_type: Mapped[str | None]
    owner_site_admin: Mapped[str | None]
    html_url: Mapped[str | None]
    description: Mapped[str | None]
    fork: Mapped[str | None]
    url: Mapped[str | None]
    forks_url: Mapped[str | None]
    keys_url: Mapped[str | None]
    collaborators_url: Mapped[str | None]
    teams_url: Mapped[str | None]
    hooks_url: Mapped[str | None]
    issue_events_url: Mapped[str | None]
    events_url: Mapped[str | None]
    assignees_url: Mapped[str | None]
    branches_url: Mapped[str | None]
    tags_url: Mapped[str | None]
    blobs_url: Mapped[str | None]
    git_tags_url: Mapped[str | None]
    git_refs_url: Mapped[str | None]
    trees_url: Mapped[str | None]
    statuses_url: Mapped[str | None]
    languages_url: Mapped[str | None]
    stargazers_url: Mapped[str | None]
    contributors_url: Mapped[str | None]
    subscribers_url: Mapped[str | None]
    subscription_url: Mapped[str | None]
    commits_url: Mapped[str | None]
    git_commits_url: Mapped[str | None]
    comments_url: Mapped[str | None]
    issue_comment_url: Mapped[str | None]
    contents_url: Mapped[str | None]
    compare_url: Mapped[str | None]
    merges_url: Mapped[str | None]
    archive_url: Mapped[str | None]
    downloads_url: Mapped[str | None]
    issues_url: Mapped[str | None]
    pulls_url: Mapped[str | None]
    milestones_url: Mapped[str | None]
    notifications_url: Mapped[str | None]
    labels_url: Mapped[str | None]
    releases_url: Mapped[str | None]
    deployments_url: Mapped[str | None]
    created_at: Mapped[str | None]
    updated_at: Mapped[str | None]
    pushed_at: Mapped[str | None]
    git_url: Mapped[str | None]
    ssh_url: Mapped[str | None]
    clone_url: Mapped[str | None]
    svn_url: Mapped[str | None]
    homepage: Mapped[str | None]
    size: Mapped[int | None]
    stargazers_count: Mapped[int | None]
    watchers_count: Mapped[int | None]
    language: Mapped[str | None]
    has_issues: Mapped[str | None]
    has_projects: Mapped[str | None]
    has_downloads: Mapped[str | None]
    has_wiki: Mapped[str | None]
    has_pages: Mapped[str | None]
    forks_count: Mapped[int | None]
    mirror_url: Mapped[str | None]
    archived: Mapped[str | None]
    disabled: Mapped[str | None]
    open_issues_count: Mapped[int | None]
    license_key: Mapped[str | None]
    license_name: Mapped[str | None]
    license_spdx_id: Mapped[str | None]
    license_url: Mapped[str | None]
    license_node_id: Mapped[str | None]
    allow_forking: Mapped[str | None]
    topics: Mapped[str | None]
    visibility: Mapped[str | None]
    forks: Mapped[int | None]
    open_issues: Mapped[int | None]
    watchers: Mapped[int | None]
    default_branch: Mapped[str | None]
    permissions_admin: Mapped[str | None]
    permissions_maintain: Mapped[str | None]
    permissions_push: Mapped[str | None]
    permissions_triage: Mapped[str | None]
    permissions_pull: Mapped[str | None]
    role_name: Mapped[str | None]
    license: Mapped[str | None]


class ProfcomffCommit(Base):
    sha: Mapped[str] = mapped_column(primary_key=True)
    repo_id: Mapped[int] = mapped_column(primary_key=True)
    node_id: Mapped[str | None]
    commit_author_name: Mapped[str | None]
    commit_author_email: Mapped[str | None]
    commit_author_date: Mapped[str | None]
    commit_committer_name: Mapped[str | None]
    commit_committer_email: Mapped[str | None]
    commit_committer_date: Mapped[str | None]
    commit_message: Mapped[str | None]
    commit_tree_sha: Mapped[str | None]
    commit_tree_url: Mapped[str | None]
    commit_url: Mapped[str | None]
    commit_comment_count: Mapped[int | None]
    commit_verification_verified: Mapped[bool | None]
    commit_verification_reason: Mapped[str | None]
    commit_verification_signature: Mapped[str | None]
    commit_verification_payload: Mapped[str | None]
    url: Mapped[str | None]
    html_url: Mapped[str | None]
    comments_url: Mapped[str | None]
    author_login: Mapped[str | None]
    author_id: Mapped[int | None]
    author_node_id: Mapped[str | None]
    author_avatar_url: Mapped[str | None]
    author_gravatar_id: Mapped[str | None]
    author_url: Mapped[str | None]
    author_html_url: Mapped[str | None]
    author_followers_url: Mapped[str | None]
    author_following_url: Mapped[str | None]
    author_gists_url: Mapped[str | None]
    author_starred_url: Mapped[str | None]
    author_subscriptions_url: Mapped[str | None]
    author_organizations_url: Mapped[str | None]
    author_repos_url: Mapped[str | None]
    author_events_url: Mapped[str | None]
    author_received_events_url: Mapped[str | None]
    author_type: Mapped[str | None]
    author_site_admin: Mapped[str | None]
    committer_login: Mapped[str | None]
    committer_id: Mapped[int | None]
    committer_node_id: Mapped[str | None]
    committer_avatar_url: Mapped[str | None]
    committer_gravatar_id: Mapped[str | None]
    committer_url: Mapped[str | None]
    committer_html_url: Mapped[str | None]
    committer_followers_url: Mapped[str | None]
    committer_following_url: Mapped[str | None]
    committer_gists_url: Mapped[str | None]
    committer_starred_url: Mapped[str | None]
    committer_subscriptions_url: Mapped[str | None]
    committer_organizations_url: Mapped[str | None]
    committer_repos_url: Mapped[str | None]
    committer_events_url: Mapped[str | None]
    committer_received_events_url: Mapped[str | None]
    committer_type: Mapped[str | None]
    committer_site_admin: Mapped[str | None]
    parents: Mapped[str | None]
    author: Mapped[str | None]
    committer: Mapped[str | None]


class ProfcomffIssue(Base):
    id: Mapped[int] = mapped_column(sa.BIGINT, primary_key=True)
    repo_id: Mapped[int] = mapped_column(primary_key=True)
    url: Mapped[str | None]
    repository_url: Mapped[str | None]
    labels_url: Mapped[str | None]
    comments_url: Mapped[str | None]
    events_url: Mapped[str | None]
    html_url: Mapped[str | None]
    node_id: Mapped[str | None]
    number: Mapped[int | None]
    title: Mapped[str | None]
    user_login: Mapped[str | None]
    user_id: Mapped[int | None]
    user_node_id: Mapped[str | None]
    user_avatar_url: Mapped[str | None]
    user_gravatar_id: Mapped[str | None]
    user_url: Mapped[str | None]
    user_html_url: Mapped[str | None]
    user_followers_url: Mapped[str | None]
    user_following_url: Mapped[str | None]
    user_gists_url: Mapped[str | None]
    user_starred_url: Mapped[str | None]
    user_subscriptions_url: Mapped[str | None]
    user_organizations_url: Mapped[str | None]
    user_repos_url: Mapped[str | None]
    user_events_url: Mapped[str | None]
    user_received_events_url: Mapped[str | None]
    user_type: Mapped[str | None]
    user_site_admin: Mapped[str | None]
    labels: Mapped[str | None]
    state: Mapped[str | None]
    locked: Mapped[str | None]
    assignee: Mapped[str | None]
    assignees: Mapped[str | None]
    milestone: Mapped[str | None]
    comments: Mapped[int | None]
    created_at: Mapped[str | None]
    updated_at: Mapped[str | None]
    closed_at: Mapped[str | None]
    author_association: Mapped[str | None]
    active_lock_reason: Mapped[str | None]
    body: Mapped[str | None]
    reactions_url: Mapped[str | None]
    reactions_total_count: Mapped[int | None]
    reactions_like: Mapped[int | None]
    reactions_dislike: Mapped[int | None]
    reactions_laugh: Mapped[int | None]
    reactions_hooray: Mapped[int | None]
    reactions_confused: Mapped[int | None]
    reactions_heart: Mapped[int | None]
    reactions_rocket: Mapped[int | None]
    reactions_eyes: Mapped[int | None]
    timeline_url: Mapped[str | None]
    performed_via_github_app: Mapped[str | None]
    state_reason: Mapped[str | None]
    assignee_login: Mapped[str | None]
    assignee_id: Mapped[int | None]
    assignee_node_id: Mapped[str | None]
    assignee_avatar_url: Mapped[str | None]
    assignee_gravatar_id: Mapped[str | None]
    assignee_url: Mapped[str | None]
    assignee_html_url: Mapped[str | None]
    assignee_followers_url: Mapped[str | None]
    assignee_following_url: Mapped[str | None]
    assignee_gists_url: Mapped[str | None]
    assignee_starred_url: Mapped[str | None]
    assignee_subscriptions_url: Mapped[str | None]
    assignee_organizations_url: Mapped[str | None]
    assignee_repos_url: Mapped[str | None]
    assignee_events_url: Mapped[str | None]
    assignee_received_events_url: Mapped[str | None]
    assignee_type: Mapped[str | None]
    assignee_site_admin: Mapped[str | None]
    draft: Mapped[str | None]
    pull_request_url: Mapped[str | None]
    pull_request_html_url: Mapped[str | None]
    pull_request_diff_url: Mapped[str | None]
    pull_request_patch_url: Mapped[str | None]
    pull_request_merged_at: Mapped[str | None]
    milestone_url: Mapped[str | None]
    milestone_html_url: Mapped[str | None]
    milestone_labels_url: Mapped[str | None]
    milestone_id: Mapped[int | None]
    milestone_node_id: Mapped[str | None]
    milestone_number: Mapped[int | None]
    milestone_title: Mapped[str | None]
    milestone_description: Mapped[str | None]
    milestone_creator_login: Mapped[str | None]
    milestone_creator_id: Mapped[int | None]
    milestone_creator_node_id: Mapped[str | None]
    milestone_creator_avatar_url: Mapped[str | None]
    milestone_creator_gravatar_id: Mapped[str | None]
    milestone_creator_url: Mapped[str | None]
    milestone_creator_html_url: Mapped[str | None]
    milestone_creator_followers_url: Mapped[str | None]
    milestone_creator_following_url: Mapped[str | None]
    milestone_creator_gists_url: Mapped[str | None]
    milestone_creator_starred_url: Mapped[str | None]
    milestone_creator_subscriptions_url: Mapped[str | None]
    milestone_creator_organizations_url: Mapped[str | None]
    milestone_creator_repos_url: Mapped[str | None]
    milestone_creator_events_url: Mapped[str | None]
    milestone_creator_received_events_url: Mapped[str | None]
    milestone_creator_type: Mapped[str | None]
    milestone_creator_site_admin: Mapped[str | None]
    milestone_open_issues: Mapped[int | None]
    milestone_closed_issues: Mapped[int | None]
    milestone_state: Mapped[str | None]
    milestone_created_at: Mapped[str | None]
    milestone_updated_at: Mapped[str | None]
    milestone_due_on: Mapped[int | None]
    milestone_closed_at: Mapped[int | None]
