"""
Module to access application values that remain unchanged during runtime.

"""

import typing
import collections.abc

GenericType1 = typing.TypeVar("GenericType1")
GenericType2 = typing.TypeVar("GenericType2")
has_joystick: bool
""" True if the BGE has been built with joystick support.
"""

has_physics: bool
""" True if the BGE has been built with physics support.
"""

has_texture_ffmpeg: bool
""" True if the BGE has been built with FFmpeg support,
enabling use of `~bge.texture.ImageFFmpeg` and `~bge.texture.VideoFFmpeg`.
"""

version: typing.Any
""" The Blender/BGE version as a tuple of 3 ints, eg. (2, 75, 1).
"""

version_char: str
""" The Blender/BGE version character (for minor releases).
"""

version_string: str
""" The Blender/BGE version formatted as a string, eg. "2.75 (sub 1)".
"""
