import typing
import collections.abc
import bpy.types

GenericType1 = typing.TypeVar("GenericType1")
GenericType2 = typing.TypeVar("GenericType2")

def ndof(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Use a 3D mouse device to pan/zoom the view

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def pan(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    deltax: typing.Any | None = 0,
    deltay: typing.Any | None = 0,
):
    """Pan the view

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param deltax: Delta X
    :type deltax: typing.Any | None
    :param deltay: Delta Y
    :type deltay: typing.Any | None
    """

    ...

def reset(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Reset the view

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def scroll_down(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    deltax: typing.Any | None = 0,
    deltay: typing.Any | None = 0,
    page: bool | typing.Any | None = False,
):
    """Scroll the view down

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param deltax: Delta X
    :type deltax: typing.Any | None
    :param deltay: Delta Y
    :type deltay: typing.Any | None
    :param page: Page, Scroll down one page
    :type page: bool | typing.Any | None
    """

    ...

def scroll_left(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    deltax: typing.Any | None = 0,
    deltay: typing.Any | None = 0,
):
    """Scroll the view left

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param deltax: Delta X
    :type deltax: typing.Any | None
    :param deltay: Delta Y
    :type deltay: typing.Any | None
    """

    ...

def scroll_right(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    deltax: typing.Any | None = 0,
    deltay: typing.Any | None = 0,
):
    """Scroll the view right

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param deltax: Delta X
    :type deltax: typing.Any | None
    :param deltay: Delta Y
    :type deltay: typing.Any | None
    """

    ...

def scroll_up(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    deltax: typing.Any | None = 0,
    deltay: typing.Any | None = 0,
    page: bool | typing.Any | None = False,
):
    """Scroll the view up

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param deltax: Delta X
    :type deltax: typing.Any | None
    :param deltay: Delta Y
    :type deltay: typing.Any | None
    :param page: Page, Scroll up one page
    :type page: bool | typing.Any | None
    """

    ...

def scroller_activate(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Scroll view by mouse click and drag

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def smoothview(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    gesture_mode: typing.Any | None = 0,
    xmin: typing.Any | None = 0,
    xmax: typing.Any | None = 0,
    ymin: typing.Any | None = 0,
    ymax: typing.Any | None = 0,
):
    """Undocumented

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param gesture_mode: Gesture Mode
    :type gesture_mode: typing.Any | None
    :param xmin: X Min
    :type xmin: typing.Any | None
    :param xmax: X Max
    :type xmax: typing.Any | None
    :param ymin: Y Min
    :type ymin: typing.Any | None
    :param ymax: Y Max
    :type ymax: typing.Any | None
    """

    ...

def zoom(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    deltax: typing.Any | None = 0.0,
    deltay: typing.Any | None = 0.0,
):
    """Zoom in/out the view

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param deltax: Delta X
    :type deltax: typing.Any | None
    :param deltay: Delta Y
    :type deltay: typing.Any | None
    """

    ...

def zoom_border(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    gesture_mode: typing.Any | None = 0,
    xmin: typing.Any | None = 0,
    xmax: typing.Any | None = 0,
    ymin: typing.Any | None = 0,
    ymax: typing.Any | None = 0,
):
    """Zoom in the view to the nearest item contained in the border

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param gesture_mode: Gesture Mode
    :type gesture_mode: typing.Any | None
    :param xmin: X Min
    :type xmin: typing.Any | None
    :param xmax: X Max
    :type xmax: typing.Any | None
    :param ymin: Y Min
    :type ymin: typing.Any | None
    :param ymax: Y Max
    :type ymax: typing.Any | None
    """

    ...

def zoom_in(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    zoomfacx: typing.Any | None = 0.0,
    zoomfacy: typing.Any | None = 0.0,
):
    """Zoom in the view

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param zoomfacx: Zoom Factor X
    :type zoomfacx: typing.Any | None
    :param zoomfacy: Zoom Factor Y
    :type zoomfacy: typing.Any | None
    """

    ...

def zoom_out(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    zoomfacx: typing.Any | None = 0.0,
    zoomfacy: typing.Any | None = 0.0,
):
    """Zoom out the view

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param zoomfacx: Zoom Factor X
    :type zoomfacx: typing.Any | None
    :param zoomfacy: Zoom Factor Y
    :type zoomfacy: typing.Any | None
    """

    ...
