# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetModelTypeResult',
    'AwaitableGetModelTypeResult',
    'get_model_type',
    'get_model_type_output',
]

@pulumi.output_type
class GetModelTypeResult:
    """
    A collection of values returned by getModelType.
    """
    def __init__(__self__, capabilities=None, compartment_id=None, id=None, model_sub_type=None, model_type=None, versions=None):
        if capabilities and not isinstance(capabilities, str):
            raise TypeError("Expected argument 'capabilities' to be a str")
        pulumi.set(__self__, "capabilities", capabilities)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if model_sub_type and not isinstance(model_sub_type, str):
            raise TypeError("Expected argument 'model_sub_type' to be a str")
        pulumi.set(__self__, "model_sub_type", model_sub_type)
        if model_type and not isinstance(model_type, str):
            raise TypeError("Expected argument 'model_type' to be a str")
        pulumi.set(__self__, "model_type", model_type)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> _builtins.str:
        """
        Model information capabilities related to version
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modelSubType")
    def model_sub_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "model_sub_type")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> _builtins.str:
        return pulumi.get(self, "model_type")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence[_builtins.str]:
        """
        Model versions available for this model and submodel type
        """
        return pulumi.get(self, "versions")


class AwaitableGetModelTypeResult(GetModelTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelTypeResult(
            capabilities=self.capabilities,
            compartment_id=self.compartment_id,
            id=self.id,
            model_sub_type=self.model_sub_type,
            model_type=self.model_type,
            versions=self.versions)


def get_model_type(compartment_id: Optional[_builtins.str] = None,
                   model_sub_type: Optional[_builtins.str] = None,
                   model_type: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelTypeResult:
    """
    This data source provides details about a specific Model Type resource in Oracle Cloud Infrastructure Ai Document service.

    Gets model capabilities

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_type = oci.AiDocument.get_model_type(model_type=model_type_model_type,
        compartment_id=compartment_id,
        model_sub_type=model_type_model_sub_type)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str model_sub_type: The sub type based upon model selected.
    :param _builtins.str model_type: The type of the Document model.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['modelSubType'] = model_sub_type
    __args__['modelType'] = model_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiDocument/getModelType:getModelType', __args__, opts=opts, typ=GetModelTypeResult).value

    return AwaitableGetModelTypeResult(
        capabilities=pulumi.get(__ret__, 'capabilities'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        model_sub_type=pulumi.get(__ret__, 'model_sub_type'),
        model_type=pulumi.get(__ret__, 'model_type'),
        versions=pulumi.get(__ret__, 'versions'))
def get_model_type_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          model_sub_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          model_type: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelTypeResult]:
    """
    This data source provides details about a specific Model Type resource in Oracle Cloud Infrastructure Ai Document service.

    Gets model capabilities

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_type = oci.AiDocument.get_model_type(model_type=model_type_model_type,
        compartment_id=compartment_id,
        model_sub_type=model_type_model_sub_type)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str model_sub_type: The sub type based upon model selected.
    :param _builtins.str model_type: The type of the Document model.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['modelSubType'] = model_sub_type
    __args__['modelType'] = model_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiDocument/getModelType:getModelType', __args__, opts=opts, typ=GetModelTypeResult)
    return __ret__.apply(lambda __response__: GetModelTypeResult(
        capabilities=pulumi.get(__response__, 'capabilities'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        model_sub_type=pulumi.get(__response__, 'model_sub_type'),
        model_type=pulumi.get(__response__, 'model_type'),
        versions=pulumi.get(__response__, 'versions')))
