# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelArgs', 'Model']

@pulumi.input_type
class ModelArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 model_type: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 component_models: Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inference_units: Optional[pulumi.Input[_builtins.int]] = None,
                 is_quick_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['ModelLockArgs']]]] = None,
                 max_training_time_in_hours: Optional[pulumi.Input[_builtins.float]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 model_sub_type: Optional[pulumi.Input['ModelModelSubTypeArgs']] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_dataset: Optional[pulumi.Input['ModelTestingDatasetArgs']] = None,
                 training_dataset: Optional[pulumi.Input['ModelTrainingDatasetArgs']] = None,
                 validation_dataset: Optional[pulumi.Input['ModelValidationDatasetArgs']] = None):
        """
        The set of arguments for constructing a Model resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment identifier.
        :param pulumi.Input[_builtins.str] model_type: The type of the Document model.
        :param pulumi.Input[_builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        :param pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A human-friendly name for the model, which can be changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] inference_units: (Updatable) Number of replicas required for this model.
        :param pulumi.Input[_builtins.bool] is_quick_mode: Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        :param pulumi.Input[_builtins.str] language: The document language for model training, abbreviated according to the BCP 47 syntax.
        :param pulumi.Input[Sequence[pulumi.Input['ModelLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[_builtins.float] max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param pulumi.Input['ModelModelSubTypeArgs'] model_sub_type: Applicable to only PRE_TRAINED_KEY_VALUE_EXTRACTION, PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION.
        :param pulumi.Input[_builtins.str] model_version: The model version
        :param pulumi.Input['ModelTestingDatasetArgs'] testing_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input['ModelTrainingDatasetArgs'] training_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input['ModelValidationDatasetArgs'] validation_dataset: The base entity which is the input for creating and training a model.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "project_id", project_id)
        if component_models is not None:
            pulumi.set(__self__, "component_models", component_models)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if inference_units is not None:
            pulumi.set(__self__, "inference_units", inference_units)
        if is_quick_mode is not None:
            pulumi.set(__self__, "is_quick_mode", is_quick_mode)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if max_training_time_in_hours is not None:
            pulumi.set(__self__, "max_training_time_in_hours", max_training_time_in_hours)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if model_sub_type is not None:
            pulumi.set(__self__, "model_sub_type", model_sub_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if testing_dataset is not None:
            pulumi.set(__self__, "testing_dataset", testing_dataset)
        if training_dataset is not None:
            pulumi.set(__self__, "training_dataset", training_dataset)
        if validation_dataset is not None:
            pulumi.set(__self__, "validation_dataset", validation_dataset)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "model_type", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="componentModels")
    def component_models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        """
        return pulumi.get(self, "component_models")

    @component_models.setter
    def component_models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]]):
        pulumi.set(self, "component_models", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional description of the model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A human-friendly name for the model, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="inferenceUnits")
    def inference_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number of replicas required for this model.
        """
        return pulumi.get(self, "inference_units")

    @inference_units.setter
    def inference_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "inference_units", value)

    @_builtins.property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        """
        return pulumi.get(self, "is_quick_mode")

    @is_quick_mode.setter
    def is_quick_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_quick_mode", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The document language for model training, abbreviated according to the BCP 47 syntax.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @_builtins.property
    @pulumi.getter(name="maxTrainingTimeInHours")
    def max_training_time_in_hours(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum model training time in hours, expressed as a decimal fraction.
        """
        return pulumi.get(self, "max_training_time_in_hours")

    @max_training_time_in_hours.setter
    def max_training_time_in_hours(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_training_time_in_hours", value)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_id", value)

    @_builtins.property
    @pulumi.getter(name="modelSubType")
    def model_sub_type(self) -> Optional[pulumi.Input['ModelModelSubTypeArgs']]:
        """
        Applicable to only PRE_TRAINED_KEY_VALUE_EXTRACTION, PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION.
        """
        return pulumi.get(self, "model_sub_type")

    @model_sub_type.setter
    def model_sub_type(self, value: Optional[pulumi.Input['ModelModelSubTypeArgs']]):
        pulumi.set(self, "model_sub_type", value)

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model version
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_version", value)

    @_builtins.property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> Optional[pulumi.Input['ModelTestingDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "testing_dataset")

    @testing_dataset.setter
    def testing_dataset(self, value: Optional[pulumi.Input['ModelTestingDatasetArgs']]):
        pulumi.set(self, "testing_dataset", value)

    @_builtins.property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> Optional[pulumi.Input['ModelTrainingDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "training_dataset")

    @training_dataset.setter
    def training_dataset(self, value: Optional[pulumi.Input['ModelTrainingDatasetArgs']]):
        pulumi.set(self, "training_dataset", value)

    @_builtins.property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> Optional[pulumi.Input['ModelValidationDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "validation_dataset")

    @validation_dataset.setter
    def validation_dataset(self, value: Optional[pulumi.Input['ModelValidationDatasetArgs']]):
        pulumi.set(self, "validation_dataset", value)


@pulumi.input_type
class _ModelState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 component_models: Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inference_units: Optional[pulumi.Input[_builtins.int]] = None,
                 is_composed_model: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_quick_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['ModelLockArgs']]]] = None,
                 max_training_time_in_hours: Optional[pulumi.Input[_builtins.float]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricArgs']]]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 model_sub_type: Optional[pulumi.Input['ModelModelSubTypeArgs']] = None,
                 model_type: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_dataset: Optional[pulumi.Input['ModelTestingDatasetArgs']] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 trained_time_in_hours: Optional[pulumi.Input[_builtins.float]] = None,
                 training_dataset: Optional[pulumi.Input['ModelTrainingDatasetArgs']] = None,
                 validation_dataset: Optional[pulumi.Input['ModelValidationDatasetArgs']] = None):
        """
        Input properties used for looking up and filtering Model resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment identifier.
        :param pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A human-friendly name for the model, which can be changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] inference_units: (Updatable) Number of replicas required for this model.
        :param pulumi.Input[_builtins.bool] is_composed_model: Set to true when the model is created by using multiple key value extraction models.
        :param pulumi.Input[_builtins.bool] is_quick_mode: Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: The collection of labels used to train the custom model.
        :param pulumi.Input[_builtins.str] language: The document language for model training, abbreviated according to the BCP 47 syntax.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail, that can provide actionable information if training failed.
        :param pulumi.Input[Sequence[pulumi.Input['ModelLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[_builtins.float] max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricArgs']]] metrics: Trained Model Metrics.
        :param pulumi.Input['ModelModelSubTypeArgs'] model_sub_type: Applicable to only PRE_TRAINED_KEY_VALUE_EXTRACTION, PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION.
        :param pulumi.Input[_builtins.str] model_type: The type of the Document model.
        :param pulumi.Input[_builtins.str] model_version: The model version
        :param pulumi.Input[_builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        :param pulumi.Input[_builtins.str] state: The current state of the model.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param pulumi.Input[_builtins.str] tenancy_id: The tenancy id of the model.
        :param pulumi.Input['ModelTestingDatasetArgs'] testing_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input[_builtins.str] time_created: When the model was created, as an RFC3339 datetime string.
        :param pulumi.Input[_builtins.str] time_updated: When the model was updated, as an RFC3339 datetime string.
        :param pulumi.Input[_builtins.float] trained_time_in_hours: The total hours actually used for model training.
        :param pulumi.Input['ModelTrainingDatasetArgs'] training_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input['ModelValidationDatasetArgs'] validation_dataset: The base entity which is the input for creating and training a model.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if component_models is not None:
            pulumi.set(__self__, "component_models", component_models)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if inference_units is not None:
            pulumi.set(__self__, "inference_units", inference_units)
        if is_composed_model is not None:
            pulumi.set(__self__, "is_composed_model", is_composed_model)
        if is_quick_mode is not None:
            pulumi.set(__self__, "is_quick_mode", is_quick_mode)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if max_training_time_in_hours is not None:
            pulumi.set(__self__, "max_training_time_in_hours", max_training_time_in_hours)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if model_sub_type is not None:
            pulumi.set(__self__, "model_sub_type", model_sub_type)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)
        if testing_dataset is not None:
            pulumi.set(__self__, "testing_dataset", testing_dataset)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if trained_time_in_hours is not None:
            pulumi.set(__self__, "trained_time_in_hours", trained_time_in_hours)
        if training_dataset is not None:
            pulumi.set(__self__, "training_dataset", training_dataset)
        if validation_dataset is not None:
            pulumi.set(__self__, "validation_dataset", validation_dataset)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="componentModels")
    def component_models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        """
        return pulumi.get(self, "component_models")

    @component_models.setter
    def component_models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]]):
        pulumi.set(self, "component_models", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional description of the model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A human-friendly name for the model, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="inferenceUnits")
    def inference_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number of replicas required for this model.
        """
        return pulumi.get(self, "inference_units")

    @inference_units.setter
    def inference_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "inference_units", value)

    @_builtins.property
    @pulumi.getter(name="isComposedModel")
    def is_composed_model(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true when the model is created by using multiple key value extraction models.
        """
        return pulumi.get(self, "is_composed_model")

    @is_composed_model.setter
    def is_composed_model(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_composed_model", value)

    @_builtins.property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        """
        return pulumi.get(self, "is_quick_mode")

    @is_quick_mode.setter
    def is_quick_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_quick_mode", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The collection of labels used to train the custom model.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The document language for model training, abbreviated according to the BCP 47 syntax.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail, that can provide actionable information if training failed.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @_builtins.property
    @pulumi.getter(name="maxTrainingTimeInHours")
    def max_training_time_in_hours(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum model training time in hours, expressed as a decimal fraction.
        """
        return pulumi.get(self, "max_training_time_in_hours")

    @max_training_time_in_hours.setter
    def max_training_time_in_hours(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_training_time_in_hours", value)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricArgs']]]]:
        """
        Trained Model Metrics.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_id", value)

    @_builtins.property
    @pulumi.getter(name="modelSubType")
    def model_sub_type(self) -> Optional[pulumi.Input['ModelModelSubTypeArgs']]:
        """
        Applicable to only PRE_TRAINED_KEY_VALUE_EXTRACTION, PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION.
        """
        return pulumi.get(self, "model_sub_type")

    @model_sub_type.setter
    def model_sub_type(self, value: Optional[pulumi.Input['ModelModelSubTypeArgs']]):
        pulumi.set(self, "model_sub_type", value)

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_type", value)

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model version
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_version", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the model.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenancy id of the model.
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenancy_id", value)

    @_builtins.property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> Optional[pulumi.Input['ModelTestingDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "testing_dataset")

    @testing_dataset.setter
    def testing_dataset(self, value: Optional[pulumi.Input['ModelTestingDatasetArgs']]):
        pulumi.set(self, "testing_dataset", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the model was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="trainedTimeInHours")
    def trained_time_in_hours(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The total hours actually used for model training.
        """
        return pulumi.get(self, "trained_time_in_hours")

    @trained_time_in_hours.setter
    def trained_time_in_hours(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "trained_time_in_hours", value)

    @_builtins.property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> Optional[pulumi.Input['ModelTrainingDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "training_dataset")

    @training_dataset.setter
    def training_dataset(self, value: Optional[pulumi.Input['ModelTrainingDatasetArgs']]):
        pulumi.set(self, "training_dataset", value)

    @_builtins.property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> Optional[pulumi.Input['ModelValidationDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "validation_dataset")

    @validation_dataset.setter
    def validation_dataset(self, value: Optional[pulumi.Input['ModelValidationDatasetArgs']]):
        pulumi.set(self, "validation_dataset", value)


@pulumi.type_token("oci:AiDocument/model:Model")
class Model(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 component_models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelComponentModelArgs', 'ModelComponentModelArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inference_units: Optional[pulumi.Input[_builtins.int]] = None,
                 is_quick_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelLockArgs', 'ModelLockArgsDict']]]]] = None,
                 max_training_time_in_hours: Optional[pulumi.Input[_builtins.float]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 model_sub_type: Optional[pulumi.Input[Union['ModelModelSubTypeArgs', 'ModelModelSubTypeArgsDict']]] = None,
                 model_type: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_dataset: Optional[pulumi.Input[Union['ModelTestingDatasetArgs', 'ModelTestingDatasetArgsDict']]] = None,
                 training_dataset: Optional[pulumi.Input[Union['ModelTrainingDatasetArgs', 'ModelTrainingDatasetArgsDict']]] = None,
                 validation_dataset: Optional[pulumi.Input[Union['ModelValidationDatasetArgs', 'ModelValidationDatasetArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Ai Document service.

        Create a new model.

          Updates the model metadata only selected path parameter.

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiDocument/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment identifier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelComponentModelArgs', 'ModelComponentModelArgsDict']]]] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A human-friendly name for the model, which can be changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] inference_units: (Updatable) Number of replicas required for this model.
        :param pulumi.Input[_builtins.bool] is_quick_mode: Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        :param pulumi.Input[_builtins.str] language: The document language for model training, abbreviated according to the BCP 47 syntax.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelLockArgs', 'ModelLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[_builtins.float] max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param pulumi.Input[Union['ModelModelSubTypeArgs', 'ModelModelSubTypeArgsDict']] model_sub_type: Applicable to only PRE_TRAINED_KEY_VALUE_EXTRACTION, PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION.
        :param pulumi.Input[_builtins.str] model_type: The type of the Document model.
        :param pulumi.Input[_builtins.str] model_version: The model version
        :param pulumi.Input[_builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        :param pulumi.Input[Union['ModelTestingDatasetArgs', 'ModelTestingDatasetArgsDict']] testing_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input[Union['ModelTrainingDatasetArgs', 'ModelTrainingDatasetArgsDict']] training_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input[Union['ModelValidationDatasetArgs', 'ModelValidationDatasetArgsDict']] validation_dataset: The base entity which is the input for creating and training a model.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Ai Document service.

        Create a new model.

          Updates the model metadata only selected path parameter.

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiDocument/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param ModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 component_models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelComponentModelArgs', 'ModelComponentModelArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inference_units: Optional[pulumi.Input[_builtins.int]] = None,
                 is_quick_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelLockArgs', 'ModelLockArgsDict']]]]] = None,
                 max_training_time_in_hours: Optional[pulumi.Input[_builtins.float]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 model_sub_type: Optional[pulumi.Input[Union['ModelModelSubTypeArgs', 'ModelModelSubTypeArgsDict']]] = None,
                 model_type: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_dataset: Optional[pulumi.Input[Union['ModelTestingDatasetArgs', 'ModelTestingDatasetArgsDict']]] = None,
                 training_dataset: Optional[pulumi.Input[Union['ModelTrainingDatasetArgs', 'ModelTrainingDatasetArgsDict']]] = None,
                 validation_dataset: Optional[pulumi.Input[Union['ModelValidationDatasetArgs', 'ModelValidationDatasetArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelArgs.__new__(ModelArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["component_models"] = component_models
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["inference_units"] = inference_units
            __props__.__dict__["is_quick_mode"] = is_quick_mode
            __props__.__dict__["language"] = language
            __props__.__dict__["locks"] = locks
            __props__.__dict__["max_training_time_in_hours"] = max_training_time_in_hours
            __props__.__dict__["model_id"] = model_id
            __props__.__dict__["model_sub_type"] = model_sub_type
            if model_type is None and not opts.urn:
                raise TypeError("Missing required property 'model_type'")
            __props__.__dict__["model_type"] = model_type
            __props__.__dict__["model_version"] = model_version
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["testing_dataset"] = testing_dataset
            __props__.__dict__["training_dataset"] = training_dataset
            __props__.__dict__["validation_dataset"] = validation_dataset
            __props__.__dict__["is_composed_model"] = None
            __props__.__dict__["labels"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["metrics"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tenancy_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["trained_time_in_hours"] = None
        super(Model, __self__).__init__(
            'oci:AiDocument/model:Model',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            component_models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelComponentModelArgs', 'ModelComponentModelArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            inference_units: Optional[pulumi.Input[_builtins.int]] = None,
            is_composed_model: Optional[pulumi.Input[_builtins.bool]] = None,
            is_quick_mode: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            language: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelLockArgs', 'ModelLockArgsDict']]]]] = None,
            max_training_time_in_hours: Optional[pulumi.Input[_builtins.float]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelMetricArgs', 'ModelMetricArgsDict']]]]] = None,
            model_id: Optional[pulumi.Input[_builtins.str]] = None,
            model_sub_type: Optional[pulumi.Input[Union['ModelModelSubTypeArgs', 'ModelModelSubTypeArgsDict']]] = None,
            model_type: Optional[pulumi.Input[_builtins.str]] = None,
            model_version: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
            testing_dataset: Optional[pulumi.Input[Union['ModelTestingDatasetArgs', 'ModelTestingDatasetArgsDict']]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            trained_time_in_hours: Optional[pulumi.Input[_builtins.float]] = None,
            training_dataset: Optional[pulumi.Input[Union['ModelTrainingDatasetArgs', 'ModelTrainingDatasetArgsDict']]] = None,
            validation_dataset: Optional[pulumi.Input[Union['ModelValidationDatasetArgs', 'ModelValidationDatasetArgsDict']]] = None) -> 'Model':
        """
        Get an existing Model resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment identifier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelComponentModelArgs', 'ModelComponentModelArgsDict']]]] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A human-friendly name for the model, which can be changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] inference_units: (Updatable) Number of replicas required for this model.
        :param pulumi.Input[_builtins.bool] is_composed_model: Set to true when the model is created by using multiple key value extraction models.
        :param pulumi.Input[_builtins.bool] is_quick_mode: Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: The collection of labels used to train the custom model.
        :param pulumi.Input[_builtins.str] language: The document language for model training, abbreviated according to the BCP 47 syntax.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail, that can provide actionable information if training failed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelLockArgs', 'ModelLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[_builtins.float] max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelMetricArgs', 'ModelMetricArgsDict']]]] metrics: Trained Model Metrics.
        :param pulumi.Input[Union['ModelModelSubTypeArgs', 'ModelModelSubTypeArgsDict']] model_sub_type: Applicable to only PRE_TRAINED_KEY_VALUE_EXTRACTION, PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION.
        :param pulumi.Input[_builtins.str] model_type: The type of the Document model.
        :param pulumi.Input[_builtins.str] model_version: The model version
        :param pulumi.Input[_builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        :param pulumi.Input[_builtins.str] state: The current state of the model.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param pulumi.Input[_builtins.str] tenancy_id: The tenancy id of the model.
        :param pulumi.Input[Union['ModelTestingDatasetArgs', 'ModelTestingDatasetArgsDict']] testing_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input[_builtins.str] time_created: When the model was created, as an RFC3339 datetime string.
        :param pulumi.Input[_builtins.str] time_updated: When the model was updated, as an RFC3339 datetime string.
        :param pulumi.Input[_builtins.float] trained_time_in_hours: The total hours actually used for model training.
        :param pulumi.Input[Union['ModelTrainingDatasetArgs', 'ModelTrainingDatasetArgsDict']] training_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input[Union['ModelValidationDatasetArgs', 'ModelValidationDatasetArgsDict']] validation_dataset: The base entity which is the input for creating and training a model.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelState.__new__(_ModelState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["component_models"] = component_models
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["inference_units"] = inference_units
        __props__.__dict__["is_composed_model"] = is_composed_model
        __props__.__dict__["is_quick_mode"] = is_quick_mode
        __props__.__dict__["labels"] = labels
        __props__.__dict__["language"] = language
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["locks"] = locks
        __props__.__dict__["max_training_time_in_hours"] = max_training_time_in_hours
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["model_id"] = model_id
        __props__.__dict__["model_sub_type"] = model_sub_type
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["model_version"] = model_version
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenancy_id"] = tenancy_id
        __props__.__dict__["testing_dataset"] = testing_dataset
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["trained_time_in_hours"] = trained_time_in_hours
        __props__.__dict__["training_dataset"] = training_dataset
        __props__.__dict__["validation_dataset"] = validation_dataset
        return Model(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="componentModels")
    def component_models(self) -> pulumi.Output[Sequence['outputs.ModelComponentModel']]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        """
        return pulumi.get(self, "component_models")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) An optional description of the model.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A human-friendly name for the model, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="inferenceUnits")
    def inference_units(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Number of replicas required for this model.
        """
        return pulumi.get(self, "inference_units")

    @_builtins.property
    @pulumi.getter(name="isComposedModel")
    def is_composed_model(self) -> pulumi.Output[_builtins.bool]:
        """
        Set to true when the model is created by using multiple key value extraction models.
        """
        return pulumi.get(self, "is_composed_model")

    @_builtins.property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> pulumi.Output[_builtins.bool]:
        """
        Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        """
        return pulumi.get(self, "is_quick_mode")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The collection of labels used to train the custom model.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def language(self) -> pulumi.Output[_builtins.str]:
        """
        The document language for model training, abbreviated according to the BCP 47 syntax.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail, that can provide actionable information if training failed.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> pulumi.Output[Sequence['outputs.ModelLock']]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter(name="maxTrainingTimeInHours")
    def max_training_time_in_hours(self) -> pulumi.Output[_builtins.float]:
        """
        The maximum model training time in hours, expressed as a decimal fraction.
        """
        return pulumi.get(self, "max_training_time_in_hours")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Sequence['outputs.ModelMetric']]:
        """
        Trained Model Metrics.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter(name="modelSubType")
    def model_sub_type(self) -> pulumi.Output['outputs.ModelModelSubType']:
        """
        Applicable to only PRE_TRAINED_KEY_VALUE_EXTRACTION, PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION.
        """
        return pulumi.get(self, "model_sub_type")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> pulumi.Output[_builtins.str]:
        """
        The model version
        """
        return pulumi.get(self, "model_version")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the model.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The tenancy id of the model.
        """
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> pulumi.Output['outputs.ModelTestingDataset']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "testing_dataset")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        When the model was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="trainedTimeInHours")
    def trained_time_in_hours(self) -> pulumi.Output[_builtins.float]:
        """
        The total hours actually used for model training.
        """
        return pulumi.get(self, "trained_time_in_hours")

    @_builtins.property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> pulumi.Output['outputs.ModelTrainingDataset']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "training_dataset")

    @_builtins.property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> pulumi.Output['outputs.ModelValidationDataset']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "validation_dataset")

