# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetStreamGroupResult',
    'AwaitableGetStreamGroupResult',
    'get_stream_group',
    'get_stream_group_output',
]

@pulumi.output_type
class GetStreamGroupResult:
    """
    A collection of values returned by getStreamGroup.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_enabled=None, state=None, stream_group_id=None, stream_overlaps=None, stream_source_ids=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_group_id and not isinstance(stream_group_id, str):
            raise TypeError("Expected argument 'stream_group_id' to be a str")
        pulumi.set(__self__, "stream_group_id", stream_group_id)
        if stream_overlaps and not isinstance(stream_overlaps, list):
            raise TypeError("Expected argument 'stream_overlaps' to be a list")
        pulumi.set(__self__, "stream_overlaps", stream_overlaps)
        if stream_source_ids and not isinstance(stream_source_ids, list):
            raise TypeError("Expected argument 'stream_source_ids' to be a list")
        pulumi.set(__self__, "stream_source_ids", stream_source_ids)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of compartment
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A human-friendly name for the streamGroup.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the streamGroup.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Stream
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the streamGroup.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="streamGroupId")
    def stream_group_id(self) -> _builtins.str:
        return pulumi.get(self, "stream_group_id")

    @_builtins.property
    @pulumi.getter(name="streamOverlaps")
    def stream_overlaps(self) -> Sequence['outputs.GetStreamGroupStreamOverlapResult']:
        """
        List of streamSource OCIDs where the streamSource overlaps in field of view.
        """
        return pulumi.get(self, "stream_overlaps")

    @_builtins.property
    @pulumi.getter(name="streamSourceIds")
    def stream_source_ids(self) -> Sequence[_builtins.str]:
        """
        List of streamSource OCIDs associated with the stream group
        """
        return pulumi.get(self, "stream_source_ids")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the streamGroup was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        When the streamGroup was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetStreamGroupResult(GetStreamGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamGroupResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_enabled=self.is_enabled,
            state=self.state,
            stream_group_id=self.stream_group_id,
            stream_overlaps=self.stream_overlaps,
            stream_source_ids=self.stream_source_ids,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_stream_group(stream_group_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamGroupResult:
    """
    This data source provides details about a specific Stream Group resource in Oracle Cloud Infrastructure Ai Vision service.

    Get a  streamGroup

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_group = oci.AiVision.get_stream_group(stream_group_id=test_stream_group_oci_ai_vision_stream_group["id"])
    ```


    :param _builtins.str stream_group_id: StreamGroup Id.
    """
    __args__ = dict()
    __args__['streamGroupId'] = stream_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiVision/getStreamGroup:getStreamGroup', __args__, opts=opts, typ=GetStreamGroupResult).value

    return AwaitableGetStreamGroupResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        state=pulumi.get(__ret__, 'state'),
        stream_group_id=pulumi.get(__ret__, 'stream_group_id'),
        stream_overlaps=pulumi.get(__ret__, 'stream_overlaps'),
        stream_source_ids=pulumi.get(__ret__, 'stream_source_ids'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_stream_group_output(stream_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamGroupResult]:
    """
    This data source provides details about a specific Stream Group resource in Oracle Cloud Infrastructure Ai Vision service.

    Get a  streamGroup

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_group = oci.AiVision.get_stream_group(stream_group_id=test_stream_group_oci_ai_vision_stream_group["id"])
    ```


    :param _builtins.str stream_group_id: StreamGroup Id.
    """
    __args__ = dict()
    __args__['streamGroupId'] = stream_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiVision/getStreamGroup:getStreamGroup', __args__, opts=opts, typ=GetStreamGroupResult)
    return __ret__.apply(lambda __response__: GetStreamGroupResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_enabled=pulumi.get(__response__, 'is_enabled'),
        state=pulumi.get(__response__, 'state'),
        stream_group_id=pulumi.get(__response__, 'stream_group_id'),
        stream_overlaps=pulumi.get(__response__, 'stream_overlaps'),
        stream_source_ids=pulumi.get(__response__, 'stream_source_ids'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
