# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetStreamJobResult',
    'AwaitableGetStreamJobResult',
    'get_stream_job',
    'get_stream_job_output',
]

@pulumi.output_type
class GetStreamJobResult:
    """
    A collection of values returned by getStreamJob.
    """
    def __init__(__self__, agent_participant_id=None, compartment_id=None, defined_tags=None, display_name=None, features=None, freeform_tags=None, id=None, lifecycle_details=None, state=None, stream_job_id=None, stream_output_locations=None, stream_source_id=None, system_tags=None, time_created=None, time_updated=None):
        if agent_participant_id and not isinstance(agent_participant_id, str):
            raise TypeError("Expected argument 'agent_participant_id' to be a str")
        pulumi.set(__self__, "agent_participant_id", agent_participant_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if features and not isinstance(features, list):
            raise TypeError("Expected argument 'features' to be a list")
        pulumi.set(__self__, "features", features)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_job_id and not isinstance(stream_job_id, str):
            raise TypeError("Expected argument 'stream_job_id' to be a str")
        pulumi.set(__self__, "stream_job_id", stream_job_id)
        if stream_output_locations and not isinstance(stream_output_locations, list):
            raise TypeError("Expected argument 'stream_output_locations' to be a list")
        pulumi.set(__self__, "stream_output_locations", stream_output_locations)
        if stream_source_id and not isinstance(stream_source_id, str):
            raise TypeError("Expected argument 'stream_source_id' to be a str")
        pulumi.set(__self__, "stream_source_id", stream_source_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="agentParticipantId")
    def agent_participant_id(self) -> _builtins.str:
        """
        participant id of agent where results need to be sent
        """
        return pulumi.get(self, "agent_participant_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of compartment
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Stream job display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def features(self) -> Sequence['outputs.GetStreamJobFeatureResult']:
        """
        a list of document analysis features.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the streamJob.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional details about current state of streamJob
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Stream job.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="streamJobId")
    def stream_job_id(self) -> _builtins.str:
        return pulumi.get(self, "stream_job_id")

    @_builtins.property
    @pulumi.getter(name="streamOutputLocations")
    def stream_output_locations(self) -> Sequence['outputs.GetStreamJobStreamOutputLocationResult']:
        """
        Details about a where results will be Sent
        """
        return pulumi.get(self, "stream_output_locations")

    @_builtins.property
    @pulumi.getter(name="streamSourceId")
    def stream_source_id(self) -> _builtins.str:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the streamSource
        """
        return pulumi.get(self, "stream_source_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the streamJob was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        When the stream job was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetStreamJobResult(GetStreamJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamJobResult(
            agent_participant_id=self.agent_participant_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            features=self.features,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            stream_job_id=self.stream_job_id,
            stream_output_locations=self.stream_output_locations,
            stream_source_id=self.stream_source_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_stream_job(stream_job_id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamJobResult:
    """
    This data source provides details about a specific Stream Job resource in Oracle Cloud Infrastructure Ai Vision service.

    Get details of a stream analysis job.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_job = oci.AiVision.get_stream_job(stream_job_id=test_stream_job_oci_ai_vision_stream_job["id"])
    ```


    :param _builtins.str stream_job_id: Stream job id.
    """
    __args__ = dict()
    __args__['streamJobId'] = stream_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiVision/getStreamJob:getStreamJob', __args__, opts=opts, typ=GetStreamJobResult).value

    return AwaitableGetStreamJobResult(
        agent_participant_id=pulumi.get(__ret__, 'agent_participant_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        features=pulumi.get(__ret__, 'features'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        stream_job_id=pulumi.get(__ret__, 'stream_job_id'),
        stream_output_locations=pulumi.get(__ret__, 'stream_output_locations'),
        stream_source_id=pulumi.get(__ret__, 'stream_source_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_stream_job_output(stream_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamJobResult]:
    """
    This data source provides details about a specific Stream Job resource in Oracle Cloud Infrastructure Ai Vision service.

    Get details of a stream analysis job.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_job = oci.AiVision.get_stream_job(stream_job_id=test_stream_job_oci_ai_vision_stream_job["id"])
    ```


    :param _builtins.str stream_job_id: Stream job id.
    """
    __args__ = dict()
    __args__['streamJobId'] = stream_job_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiVision/getStreamJob:getStreamJob', __args__, opts=opts, typ=GetStreamJobResult)
    return __ret__.apply(lambda __response__: GetStreamJobResult(
        agent_participant_id=pulumi.get(__response__, 'agent_participant_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        features=pulumi.get(__response__, 'features'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        stream_job_id=pulumi.get(__response__, 'stream_job_id'),
        stream_output_locations=pulumi.get(__response__, 'stream_output_locations'),
        stream_source_id=pulumi.get(__response__, 'stream_source_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
