# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApiContentResult',
    'AwaitableGetApiContentResult',
    'get_api_content',
    'get_api_content_output',
]

@pulumi.output_type
class GetApiContentResult:
    """
    A collection of values returned by getApiContent.
    """
    def __init__(__self__, api_id=None, content=None, id=None):
        if api_id and not isinstance(api_id, str):
            raise TypeError("Expected argument 'api_id' to be a str")
        pulumi.set(__self__, "api_id", api_id)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> _builtins.str:
        return pulumi.get(self, "api_id")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetApiContentResult(GetApiContentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiContentResult(
            api_id=self.api_id,
            content=self.content,
            id=self.id)


def get_api_content(api_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiContentResult:
    """
    This data source provides details about a specific Api Content resource in Oracle Cloud Infrastructure API Gateway service.

    Get the raw API content.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_content = oci.ApiGateway.get_api_content(api_id=test_api["id"])
    ```


    :param _builtins.str api_id: The ocid of the API.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApiGateway/getApiContent:getApiContent', __args__, opts=opts, typ=GetApiContentResult).value

    return AwaitableGetApiContentResult(
        api_id=pulumi.get(__ret__, 'api_id'),
        content=pulumi.get(__ret__, 'content'),
        id=pulumi.get(__ret__, 'id'))
def get_api_content_output(api_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiContentResult]:
    """
    This data source provides details about a specific Api Content resource in Oracle Cloud Infrastructure API Gateway service.

    Get the raw API content.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_content = oci.ApiGateway.get_api_content(api_id=test_api["id"])
    ```


    :param _builtins.str api_id: The ocid of the API.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApiGateway/getApiContent:getApiContent', __args__, opts=opts, typ=GetApiContentResult)
    return __ret__.apply(lambda __response__: GetApiContentResult(
        api_id=pulumi.get(__response__, 'api_id'),
        content=pulumi.get(__response__, 'content'),
        id=pulumi.get(__response__, 'id')))
