# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigArgs', 'Config']

@pulumi.input_type
class ConfigArgs:
    def __init__(__self__, *,
                 apm_domain_id: pulumi.Input[_builtins.str],
                 config_type: pulumi.Input[_builtins.str],
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 attach_install_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input['ConfigConfigArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_text: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 in_use_bies: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 match_agents_with_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 opc_dry_run: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 overrides: Optional[pulumi.Input['ConfigOverridesArgs']] = None,
                 process_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Config resource.
        :param pulumi.Input[_builtins.str] apm_domain_id: (Updatable) The APM Domain ID the request is intended for.
        :param pulumi.Input[_builtins.str] config_type: (Updatable) The type of configuration item.
        :param pulumi.Input[_builtins.str] agent_version: (Updatable) The version of the referenced agent bundle.
        :param pulumi.Input[_builtins.str] attach_install_dir: (Updatable) The directory owned by runAsUser.
        :param pulumi.Input['ConfigConfigArgs'] config: (Updatable) Collection of agent configuration files. For agents that use a single configuration file, this SHOULD contain a single entry and the file name MAY be an empty string. For multiple entries, you should use multiple blocks of `config_map`. To apply a different configuration in a subset of the agents, put this block anywhere in the body of the configuration and edit <some variable> and <some content> {{ <some variable> | default <some content> }} Example: com.oracle.apm.agent.tracer.enable.jfr = {{ isJfrEnabled | default false }} Then, in the configuration's overrides, specify a different value for <some variable> along with the desired agent filter. Example: "agentFilter": "ApplicationType='Tomcat'" "overrideMap": { "isJfrEnabled": true }
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional string that describes what the options are intended or used for.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]] dimensions: (Updatable) A list of dimensions for the metric. This variable should not be used.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param pulumi.Input[_builtins.str] filter_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        :param pulumi.Input[_builtins.str] filter_text: (Updatable) The string that defines the Span Filter expression.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] group: (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]] in_use_bies: The list of configuration items that reference the span filter.
        :param pulumi.Input[_builtins.str] management_agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent that will provision the APM Agent.
        :param pulumi.Input[_builtins.str] match_agents_with_attribute_value: The agent attribute VALUE by which an agent configuration is matched to an agent.  Each agent configuration object must specify a different value.  The attribute KEY corresponding to this VALUE is in the matchAgentsWithAttributeKey field.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]] metrics: (Updatable) The list of metrics in this group.
        :param pulumi.Input[_builtins.str] namespace: (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        :param pulumi.Input[_builtins.str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[_builtins.str] options: (Updatable) The options are stored here as JSON.
        :param pulumi.Input['ConfigOverridesArgs'] overrides: (Updatable) Agent configuration overrides that should apply to a subset of the agents associated with an Agent Config object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] process_filters: (Updatable) Filter patterns used to discover active Java processes for provisioning the APM Agent.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]] rules: (Updatable)
        :param pulumi.Input[_builtins.str] run_as_user: (Updatable) The OS user that should be used to discover Java processes.
        :param pulumi.Input[_builtins.str] service_name: (Updatable) The name of the service being monitored. This argument enables you to filter by service and view traces and other signals in the APM Explorer user interface. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        pulumi.set(__self__, "config_type", config_type)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if attach_install_dir is not None:
            pulumi.set(__self__, "attach_install_dir", attach_install_dir)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if filter_id is not None:
            pulumi.set(__self__, "filter_id", filter_id)
        if filter_text is not None:
            pulumi.set(__self__, "filter_text", filter_text)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if in_use_bies is not None:
            pulumi.set(__self__, "in_use_bies", in_use_bies)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if match_agents_with_attribute_value is not None:
            pulumi.set(__self__, "match_agents_with_attribute_value", match_agents_with_attribute_value)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if opc_dry_run is not None:
            pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if process_filters is not None:
            pulumi.set(__self__, "process_filters", process_filters)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The APM Domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "apm_domain_id", value)

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The type of configuration item.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_type", value)

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The version of the referenced agent bundle.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_version", value)

    @_builtins.property
    @pulumi.getter(name="attachInstallDir")
    def attach_install_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The directory owned by runAsUser.
        """
        return pulumi.get(self, "attach_install_dir")

    @attach_install_dir.setter
    def attach_install_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attach_install_dir", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ConfigConfigArgs']]:
        """
        (Updatable) Collection of agent configuration files. For agents that use a single configuration file, this SHOULD contain a single entry and the file name MAY be an empty string. For multiple entries, you should use multiple blocks of `config_map`. To apply a different configuration in a subset of the agents, put this block anywhere in the body of the configuration and edit <some variable> and <some content> {{ <some variable> | default <some content> }} Example: com.oracle.apm.agent.tracer.enable.jfr = {{ isJfrEnabled | default false }} Then, in the configuration's overrides, specify a different value for <some variable> along with the desired agent filter. Example: "agentFilter": "ApplicationType='Tomcat'" "overrideMap": { "isJfrEnabled": true }
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ConfigConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional string that describes what the options are intended or used for.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]]:
        """
        (Updatable) A list of dimensions for the metric. This variable should not be used.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="filterId")
    def filter_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        """
        return pulumi.get(self, "filter_id")

    @filter_id.setter
    def filter_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_id", value)

    @_builtins.property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @filter_text.setter
    def filter_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_text", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="inUseBies")
    def in_use_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]]:
        """
        The list of configuration items that reference the span filter.
        """
        return pulumi.get(self, "in_use_bies")

    @in_use_bies.setter
    def in_use_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]]):
        pulumi.set(self, "in_use_bies", value)

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent that will provision the APM Agent.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_agent_id", value)

    @_builtins.property
    @pulumi.getter(name="matchAgentsWithAttributeValue")
    def match_agents_with_attribute_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent attribute VALUE by which an agent configuration is matched to an agent.  Each agent configuration object must specify a different value.  The attribute KEY corresponding to this VALUE is in the matchAgentsWithAttributeKey field.
        """
        return pulumi.get(self, "match_agents_with_attribute_value")

    @match_agents_with_attribute_value.setter
    def match_agents_with_attribute_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_agents_with_attribute_value", value)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]]:
        """
        (Updatable) The list of metrics in this group.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @opc_dry_run.setter
    def opc_dry_run(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opc_dry_run", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The options are stored here as JSON.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input['ConfigOverridesArgs']]:
        """
        (Updatable) Agent configuration overrides that should apply to a subset of the agents associated with an Agent Config object.
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input['ConfigOverridesArgs']]):
        pulumi.set(self, "overrides", value)

    @_builtins.property
    @pulumi.getter(name="processFilters")
    def process_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Filter patterns used to discover active Java processes for provisioning the APM Agent.
        """
        return pulumi.get(self, "process_filters")

    @process_filters.setter
    def process_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "process_filters", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OS user that should be used to discover Java processes.
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_as_user", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the service being monitored. This argument enables you to filter by service and view traces and other signals in the APM Explorer user interface. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _ConfigState:
    def __init__(__self__, *,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attach_install_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input['ConfigConfigArgs']] = None,
                 config_type: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_text: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 in_use_bies: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 match_agents_with_attribute_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 match_agents_with_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 opc_dry_run: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 overrides: Optional[pulumi.Input['ConfigOverridesArgs']] = None,
                 process_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Config resources.
        :param pulumi.Input[_builtins.str] agent_version: (Updatable) The version of the referenced agent bundle.
        :param pulumi.Input[_builtins.str] apm_domain_id: (Updatable) The APM Domain ID the request is intended for.
        :param pulumi.Input[_builtins.str] attach_install_dir: (Updatable) The directory owned by runAsUser.
        :param pulumi.Input['ConfigConfigArgs'] config: (Updatable) Collection of agent configuration files. For agents that use a single configuration file, this SHOULD contain a single entry and the file name MAY be an empty string. For multiple entries, you should use multiple blocks of `config_map`. To apply a different configuration in a subset of the agents, put this block anywhere in the body of the configuration and edit <some variable> and <some content> {{ <some variable> | default <some content> }} Example: com.oracle.apm.agent.tracer.enable.jfr = {{ isJfrEnabled | default false }} Then, in the configuration's overrides, specify a different value for <some variable> along with the desired agent filter. Example: "agentFilter": "ApplicationType='Tomcat'" "overrideMap": { "isJfrEnabled": true }
        :param pulumi.Input[_builtins.str] config_type: (Updatable) The type of configuration item.
        :param pulumi.Input[_builtins.str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional string that describes what the options are intended or used for.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]] dimensions: (Updatable) A list of dimensions for the metric. This variable should not be used.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param pulumi.Input[_builtins.str] etag: For optimistic concurrency control. See `if-match`.
        :param pulumi.Input[_builtins.str] filter_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        :param pulumi.Input[_builtins.str] filter_text: (Updatable) The string that defines the Span Filter expression.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] group: (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]] in_use_bies: The list of configuration items that reference the span filter.
        :param pulumi.Input[_builtins.str] management_agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent that will provision the APM Agent.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] match_agents_with_attribute_keys: The agent attribute KEY by which an Agent configuration is matched to an agent.  All agent configuration objects share the same key. It is [ServiceName, service.name] by default.  The attribute VALUE corresponding to this KEY is in the matchAgentsWithAttributeValue field.
        :param pulumi.Input[_builtins.str] match_agents_with_attribute_value: The agent attribute VALUE by which an agent configuration is matched to an agent.  Each agent configuration object must specify a different value.  The attribute KEY corresponding to this VALUE is in the matchAgentsWithAttributeKey field.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]] metrics: (Updatable) The list of metrics in this group.
        :param pulumi.Input[_builtins.str] namespace: (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        :param pulumi.Input[_builtins.str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[_builtins.str] options: (Updatable) The options are stored here as JSON.
        :param pulumi.Input['ConfigOverridesArgs'] overrides: (Updatable) Agent configuration overrides that should apply to a subset of the agents associated with an Agent Config object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] process_filters: (Updatable) Filter patterns used to discover active Java processes for provisioning the APM Agent.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]] rules: (Updatable)
        :param pulumi.Input[_builtins.str] run_as_user: (Updatable) The OS user that should be used to discover Java processes.
        :param pulumi.Input[_builtins.str] service_name: (Updatable) The name of the service being monitored. This argument enables you to filter by service and view traces and other signals in the APM Explorer user interface. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[_builtins.str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        :param pulumi.Input[_builtins.str] updated_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if apm_domain_id is not None:
            pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if attach_install_dir is not None:
            pulumi.set(__self__, "attach_install_dir", attach_install_dir)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_type is not None:
            pulumi.set(__self__, "config_type", config_type)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if filter_id is not None:
            pulumi.set(__self__, "filter_id", filter_id)
        if filter_text is not None:
            pulumi.set(__self__, "filter_text", filter_text)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if in_use_bies is not None:
            pulumi.set(__self__, "in_use_bies", in_use_bies)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if match_agents_with_attribute_keys is not None:
            pulumi.set(__self__, "match_agents_with_attribute_keys", match_agents_with_attribute_keys)
        if match_agents_with_attribute_value is not None:
            pulumi.set(__self__, "match_agents_with_attribute_value", match_agents_with_attribute_value)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if opc_dry_run is not None:
            pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if process_filters is not None:
            pulumi.set(__self__, "process_filters", process_filters)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The version of the referenced agent bundle.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_version", value)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The APM Domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apm_domain_id", value)

    @_builtins.property
    @pulumi.getter(name="attachInstallDir")
    def attach_install_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The directory owned by runAsUser.
        """
        return pulumi.get(self, "attach_install_dir")

    @attach_install_dir.setter
    def attach_install_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attach_install_dir", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ConfigConfigArgs']]:
        """
        (Updatable) Collection of agent configuration files. For agents that use a single configuration file, this SHOULD contain a single entry and the file name MAY be an empty string. For multiple entries, you should use multiple blocks of `config_map`. To apply a different configuration in a subset of the agents, put this block anywhere in the body of the configuration and edit <some variable> and <some content> {{ <some variable> | default <some content> }} Example: com.oracle.apm.agent.tracer.enable.jfr = {{ isJfrEnabled | default false }} Then, in the configuration's overrides, specify a different value for <some variable> along with the desired agent filter. Example: "agentFilter": "ApplicationType='Tomcat'" "overrideMap": { "isJfrEnabled": true }
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ConfigConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The type of configuration item.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_type", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional string that describes what the options are intended or used for.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]]:
        """
        (Updatable) A list of dimensions for the metric. This variable should not be used.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For optimistic concurrency control. See `if-match`.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="filterId")
    def filter_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        """
        return pulumi.get(self, "filter_id")

    @filter_id.setter
    def filter_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_id", value)

    @_builtins.property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @filter_text.setter
    def filter_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_text", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="inUseBies")
    def in_use_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]]:
        """
        The list of configuration items that reference the span filter.
        """
        return pulumi.get(self, "in_use_bies")

    @in_use_bies.setter
    def in_use_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigInUseByArgs']]]]):
        pulumi.set(self, "in_use_bies", value)

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent that will provision the APM Agent.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_agent_id", value)

    @_builtins.property
    @pulumi.getter(name="matchAgentsWithAttributeKeys")
    def match_agents_with_attribute_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The agent attribute KEY by which an Agent configuration is matched to an agent.  All agent configuration objects share the same key. It is [ServiceName, service.name] by default.  The attribute VALUE corresponding to this KEY is in the matchAgentsWithAttributeValue field.
        """
        return pulumi.get(self, "match_agents_with_attribute_keys")

    @match_agents_with_attribute_keys.setter
    def match_agents_with_attribute_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match_agents_with_attribute_keys", value)

    @_builtins.property
    @pulumi.getter(name="matchAgentsWithAttributeValue")
    def match_agents_with_attribute_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent attribute VALUE by which an agent configuration is matched to an agent.  Each agent configuration object must specify a different value.  The attribute KEY corresponding to this VALUE is in the matchAgentsWithAttributeKey field.
        """
        return pulumi.get(self, "match_agents_with_attribute_value")

    @match_agents_with_attribute_value.setter
    def match_agents_with_attribute_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_agents_with_attribute_value", value)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]]:
        """
        (Updatable) The list of metrics in this group.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @opc_dry_run.setter
    def opc_dry_run(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opc_dry_run", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The options are stored here as JSON.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input['ConfigOverridesArgs']]:
        """
        (Updatable) Agent configuration overrides that should apply to a subset of the agents associated with an Agent Config object.
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input['ConfigOverridesArgs']]):
        pulumi.set(self, "overrides", value)

    @_builtins.property
    @pulumi.getter(name="processFilters")
    def process_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Filter patterns used to discover active Java processes for provisioning the APM Agent.
        """
        return pulumi.get(self, "process_filters")

    @process_filters.setter
    def process_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "process_filters", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OS user that should be used to discover Java processes.
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_as_user", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the service being monitored. This argument enables you to filter by service and view traces and other signals in the APM Explorer user interface. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by", value)


@pulumi.type_token("oci:ApmConfig/config:Config")
class Config(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attach_install_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['ConfigConfigArgs', 'ConfigConfigArgsDict']]] = None,
                 config_type: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigDimensionArgs', 'ConfigDimensionArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_text: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 in_use_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigInUseByArgs', 'ConfigInUseByArgsDict']]]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 match_agents_with_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigMetricArgs', 'ConfigMetricArgsDict']]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 opc_dry_run: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 overrides: Optional[pulumi.Input[Union['ConfigOverridesArgs', 'ConfigOverridesArgsDict']]] = None,
                 process_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigRuleArgs', 'ConfigRuleArgsDict']]]]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Config resource in Oracle Cloud Infrastructure Apm Config service.

        Creates a new configuration item.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_config = oci.apmconfig.Config("test_config",
            apm_domain_id=test_apm_domain["id"],
            config_type=config_config_type,
            agent_version=config_agent_version,
            attach_install_dir=config_attach_install_dir,
            config={
                "config_maps": [{
                    "file_name": config_config_config_map_file_name,
                    "body": config_config_config_map_body,
                    "content_type": config_config_config_map_content_type,
                }],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=config_description,
            dimensions=[{
                "name": config_dimensions_name,
                "value_source": config_dimensions_value_source,
            }],
            display_name=config_display_name,
            filter_id=test_filter["id"],
            filter_text=config_filter_text,
            freeform_tags={
                "bar-key": "value",
            },
            group=config_group,
            management_agent_id=test_management_agent["id"],
            match_agents_with_attribute_value=config_match_agents_with_attribute_value,
            metrics=[{
                "description": config_metrics_description,
                "name": config_metrics_name,
                "unit": config_metrics_unit,
                "value_source": config_metrics_value_source,
            }],
            namespace=config_namespace,
            opc_dry_run=config_opc_dry_run,
            options=config_options,
            overrides={
                "override_lists": [{
                    "agent_filter": config_overrides_override_list_agent_filter,
                    "override_map": config_overrides_override_list_override_map,
                }],
            },
            process_filters=config_process_filter,
            rules=[{
                "display_name": config_rules_display_name,
                "filter_text": config_rules_filter_text,
                "is_apply_to_error_spans": config_rules_is_apply_to_error_spans,
                "is_enabled": config_rules_is_enabled,
                "priority": config_rules_priority,
                "satisfied_response_time": config_rules_satisfied_response_time,
                "tolerating_response_time": config_rules_tolerating_response_time,
            }],
            run_as_user=config_run_as_user,
            service_name=test_service["name"])
        ```

        ## Import

        Configs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmConfig/config:Config test_config "configs/{configId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_version: (Updatable) The version of the referenced agent bundle.
        :param pulumi.Input[_builtins.str] apm_domain_id: (Updatable) The APM Domain ID the request is intended for.
        :param pulumi.Input[_builtins.str] attach_install_dir: (Updatable) The directory owned by runAsUser.
        :param pulumi.Input[Union['ConfigConfigArgs', 'ConfigConfigArgsDict']] config: (Updatable) Collection of agent configuration files. For agents that use a single configuration file, this SHOULD contain a single entry and the file name MAY be an empty string. For multiple entries, you should use multiple blocks of `config_map`. To apply a different configuration in a subset of the agents, put this block anywhere in the body of the configuration and edit <some variable> and <some content> {{ <some variable> | default <some content> }} Example: com.oracle.apm.agent.tracer.enable.jfr = {{ isJfrEnabled | default false }} Then, in the configuration's overrides, specify a different value for <some variable> along with the desired agent filter. Example: "agentFilter": "ApplicationType='Tomcat'" "overrideMap": { "isJfrEnabled": true }
        :param pulumi.Input[_builtins.str] config_type: (Updatable) The type of configuration item.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional string that describes what the options are intended or used for.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigDimensionArgs', 'ConfigDimensionArgsDict']]]] dimensions: (Updatable) A list of dimensions for the metric. This variable should not be used.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param pulumi.Input[_builtins.str] filter_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        :param pulumi.Input[_builtins.str] filter_text: (Updatable) The string that defines the Span Filter expression.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] group: (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigInUseByArgs', 'ConfigInUseByArgsDict']]]] in_use_bies: The list of configuration items that reference the span filter.
        :param pulumi.Input[_builtins.str] management_agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent that will provision the APM Agent.
        :param pulumi.Input[_builtins.str] match_agents_with_attribute_value: The agent attribute VALUE by which an agent configuration is matched to an agent.  Each agent configuration object must specify a different value.  The attribute KEY corresponding to this VALUE is in the matchAgentsWithAttributeKey field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigMetricArgs', 'ConfigMetricArgsDict']]]] metrics: (Updatable) The list of metrics in this group.
        :param pulumi.Input[_builtins.str] namespace: (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        :param pulumi.Input[_builtins.str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[_builtins.str] options: (Updatable) The options are stored here as JSON.
        :param pulumi.Input[Union['ConfigOverridesArgs', 'ConfigOverridesArgsDict']] overrides: (Updatable) Agent configuration overrides that should apply to a subset of the agents associated with an Agent Config object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] process_filters: (Updatable) Filter patterns used to discover active Java processes for provisioning the APM Agent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigRuleArgs', 'ConfigRuleArgsDict']]]] rules: (Updatable)
        :param pulumi.Input[_builtins.str] run_as_user: (Updatable) The OS user that should be used to discover Java processes.
        :param pulumi.Input[_builtins.str] service_name: (Updatable) The name of the service being monitored. This argument enables you to filter by service and view traces and other signals in the APM Explorer user interface. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Config resource in Oracle Cloud Infrastructure Apm Config service.

        Creates a new configuration item.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_config = oci.apmconfig.Config("test_config",
            apm_domain_id=test_apm_domain["id"],
            config_type=config_config_type,
            agent_version=config_agent_version,
            attach_install_dir=config_attach_install_dir,
            config={
                "config_maps": [{
                    "file_name": config_config_config_map_file_name,
                    "body": config_config_config_map_body,
                    "content_type": config_config_config_map_content_type,
                }],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=config_description,
            dimensions=[{
                "name": config_dimensions_name,
                "value_source": config_dimensions_value_source,
            }],
            display_name=config_display_name,
            filter_id=test_filter["id"],
            filter_text=config_filter_text,
            freeform_tags={
                "bar-key": "value",
            },
            group=config_group,
            management_agent_id=test_management_agent["id"],
            match_agents_with_attribute_value=config_match_agents_with_attribute_value,
            metrics=[{
                "description": config_metrics_description,
                "name": config_metrics_name,
                "unit": config_metrics_unit,
                "value_source": config_metrics_value_source,
            }],
            namespace=config_namespace,
            opc_dry_run=config_opc_dry_run,
            options=config_options,
            overrides={
                "override_lists": [{
                    "agent_filter": config_overrides_override_list_agent_filter,
                    "override_map": config_overrides_override_list_override_map,
                }],
            },
            process_filters=config_process_filter,
            rules=[{
                "display_name": config_rules_display_name,
                "filter_text": config_rules_filter_text,
                "is_apply_to_error_spans": config_rules_is_apply_to_error_spans,
                "is_enabled": config_rules_is_enabled,
                "priority": config_rules_priority,
                "satisfied_response_time": config_rules_satisfied_response_time,
                "tolerating_response_time": config_rules_tolerating_response_time,
            }],
            run_as_user=config_run_as_user,
            service_name=test_service["name"])
        ```

        ## Import

        Configs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmConfig/config:Config test_config "configs/{configId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param ConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attach_install_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['ConfigConfigArgs', 'ConfigConfigArgsDict']]] = None,
                 config_type: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigDimensionArgs', 'ConfigDimensionArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_text: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 in_use_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigInUseByArgs', 'ConfigInUseByArgsDict']]]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 match_agents_with_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigMetricArgs', 'ConfigMetricArgsDict']]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 opc_dry_run: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 overrides: Optional[pulumi.Input[Union['ConfigOverridesArgs', 'ConfigOverridesArgsDict']]] = None,
                 process_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigRuleArgs', 'ConfigRuleArgsDict']]]]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigArgs.__new__(ConfigArgs)

            __props__.__dict__["agent_version"] = agent_version
            if apm_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'apm_domain_id'")
            __props__.__dict__["apm_domain_id"] = apm_domain_id
            __props__.__dict__["attach_install_dir"] = attach_install_dir
            __props__.__dict__["config"] = config
            if config_type is None and not opts.urn:
                raise TypeError("Missing required property 'config_type'")
            __props__.__dict__["config_type"] = config_type
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["dimensions"] = dimensions
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["filter_id"] = filter_id
            __props__.__dict__["filter_text"] = filter_text
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["group"] = group
            __props__.__dict__["in_use_bies"] = in_use_bies
            __props__.__dict__["management_agent_id"] = management_agent_id
            __props__.__dict__["match_agents_with_attribute_value"] = match_agents_with_attribute_value
            __props__.__dict__["metrics"] = metrics
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["opc_dry_run"] = opc_dry_run
            __props__.__dict__["options"] = options
            __props__.__dict__["overrides"] = overrides
            __props__.__dict__["process_filters"] = process_filters
            __props__.__dict__["rules"] = rules
            __props__.__dict__["run_as_user"] = run_as_user
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["created_by"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["match_agents_with_attribute_keys"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["updated_by"] = None
        super(Config, __self__).__init__(
            'oci:ApmConfig/config:Config',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_version: Optional[pulumi.Input[_builtins.str]] = None,
            apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            attach_install_dir: Optional[pulumi.Input[_builtins.str]] = None,
            config: Optional[pulumi.Input[Union['ConfigConfigArgs', 'ConfigConfigArgsDict']]] = None,
            config_type: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigDimensionArgs', 'ConfigDimensionArgsDict']]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            filter_id: Optional[pulumi.Input[_builtins.str]] = None,
            filter_text: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            group: Optional[pulumi.Input[_builtins.str]] = None,
            in_use_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigInUseByArgs', 'ConfigInUseByArgsDict']]]]] = None,
            management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            match_agents_with_attribute_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            match_agents_with_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigMetricArgs', 'ConfigMetricArgsDict']]]]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            opc_dry_run: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[_builtins.str]] = None,
            overrides: Optional[pulumi.Input[Union['ConfigOverridesArgs', 'ConfigOverridesArgsDict']]] = None,
            process_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigRuleArgs', 'ConfigRuleArgsDict']]]]] = None,
            run_as_user: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            updated_by: Optional[pulumi.Input[_builtins.str]] = None) -> 'Config':
        """
        Get an existing Config resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_version: (Updatable) The version of the referenced agent bundle.
        :param pulumi.Input[_builtins.str] apm_domain_id: (Updatable) The APM Domain ID the request is intended for.
        :param pulumi.Input[_builtins.str] attach_install_dir: (Updatable) The directory owned by runAsUser.
        :param pulumi.Input[Union['ConfigConfigArgs', 'ConfigConfigArgsDict']] config: (Updatable) Collection of agent configuration files. For agents that use a single configuration file, this SHOULD contain a single entry and the file name MAY be an empty string. For multiple entries, you should use multiple blocks of `config_map`. To apply a different configuration in a subset of the agents, put this block anywhere in the body of the configuration and edit <some variable> and <some content> {{ <some variable> | default <some content> }} Example: com.oracle.apm.agent.tracer.enable.jfr = {{ isJfrEnabled | default false }} Then, in the configuration's overrides, specify a different value for <some variable> along with the desired agent filter. Example: "agentFilter": "ApplicationType='Tomcat'" "overrideMap": { "isJfrEnabled": true }
        :param pulumi.Input[_builtins.str] config_type: (Updatable) The type of configuration item.
        :param pulumi.Input[_builtins.str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional string that describes what the options are intended or used for.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigDimensionArgs', 'ConfigDimensionArgsDict']]]] dimensions: (Updatable) A list of dimensions for the metric. This variable should not be used.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param pulumi.Input[_builtins.str] etag: For optimistic concurrency control. See `if-match`.
        :param pulumi.Input[_builtins.str] filter_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        :param pulumi.Input[_builtins.str] filter_text: (Updatable) The string that defines the Span Filter expression.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] group: (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigInUseByArgs', 'ConfigInUseByArgsDict']]]] in_use_bies: The list of configuration items that reference the span filter.
        :param pulumi.Input[_builtins.str] management_agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent that will provision the APM Agent.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] match_agents_with_attribute_keys: The agent attribute KEY by which an Agent configuration is matched to an agent.  All agent configuration objects share the same key. It is [ServiceName, service.name] by default.  The attribute VALUE corresponding to this KEY is in the matchAgentsWithAttributeValue field.
        :param pulumi.Input[_builtins.str] match_agents_with_attribute_value: The agent attribute VALUE by which an agent configuration is matched to an agent.  Each agent configuration object must specify a different value.  The attribute KEY corresponding to this VALUE is in the matchAgentsWithAttributeKey field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigMetricArgs', 'ConfigMetricArgsDict']]]] metrics: (Updatable) The list of metrics in this group.
        :param pulumi.Input[_builtins.str] namespace: (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        :param pulumi.Input[_builtins.str] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[_builtins.str] options: (Updatable) The options are stored here as JSON.
        :param pulumi.Input[Union['ConfigOverridesArgs', 'ConfigOverridesArgsDict']] overrides: (Updatable) Agent configuration overrides that should apply to a subset of the agents associated with an Agent Config object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] process_filters: (Updatable) Filter patterns used to discover active Java processes for provisioning the APM Agent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigRuleArgs', 'ConfigRuleArgsDict']]]] rules: (Updatable)
        :param pulumi.Input[_builtins.str] run_as_user: (Updatable) The OS user that should be used to discover Java processes.
        :param pulumi.Input[_builtins.str] service_name: (Updatable) The name of the service being monitored. This argument enables you to filter by service and view traces and other signals in the APM Explorer user interface. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[_builtins.str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        :param pulumi.Input[_builtins.str] updated_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigState.__new__(_ConfigState)

        __props__.__dict__["agent_version"] = agent_version
        __props__.__dict__["apm_domain_id"] = apm_domain_id
        __props__.__dict__["attach_install_dir"] = attach_install_dir
        __props__.__dict__["config"] = config
        __props__.__dict__["config_type"] = config_type
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["etag"] = etag
        __props__.__dict__["filter_id"] = filter_id
        __props__.__dict__["filter_text"] = filter_text
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["group"] = group
        __props__.__dict__["in_use_bies"] = in_use_bies
        __props__.__dict__["management_agent_id"] = management_agent_id
        __props__.__dict__["match_agents_with_attribute_keys"] = match_agents_with_attribute_keys
        __props__.__dict__["match_agents_with_attribute_value"] = match_agents_with_attribute_value
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["opc_dry_run"] = opc_dry_run
        __props__.__dict__["options"] = options
        __props__.__dict__["overrides"] = overrides
        __props__.__dict__["process_filters"] = process_filters
        __props__.__dict__["rules"] = rules
        __props__.__dict__["run_as_user"] = run_as_user
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["updated_by"] = updated_by
        return Config(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The version of the referenced agent bundle.
        """
        return pulumi.get(self, "agent_version")

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The APM Domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @_builtins.property
    @pulumi.getter(name="attachInstallDir")
    def attach_install_dir(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The directory owned by runAsUser.
        """
        return pulumi.get(self, "attach_install_dir")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.ConfigConfig']:
        """
        (Updatable) Collection of agent configuration files. For agents that use a single configuration file, this SHOULD contain a single entry and the file name MAY be an empty string. For multiple entries, you should use multiple blocks of `config_map`. To apply a different configuration in a subset of the agents, put this block anywhere in the body of the configuration and edit <some variable> and <some content> {{ <some variable> | default <some content> }} Example: com.oracle.apm.agent.tracer.enable.jfr = {{ isJfrEnabled | default false }} Then, in the configuration's overrides, specify a different value for <some variable> along with the desired agent filter. Example: "agentFilter": "ApplicationType='Tomcat'" "overrideMap": { "isJfrEnabled": true }
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The type of configuration item.
        """
        return pulumi.get(self, "config_type")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) An optional string that describes what the options are intended or used for.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Sequence['outputs.ConfigDimension']]:
        """
        (Updatable) A list of dimensions for the metric. This variable should not be used.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        For optimistic concurrency control. See `if-match`.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="filterId")
    def filter_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        """
        return pulumi.get(self, "filter_id")

    @_builtins.property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter(name="inUseBies")
    def in_use_bies(self) -> pulumi.Output[Sequence['outputs.ConfigInUseBy']]:
        """
        The list of configuration items that reference the span filter.
        """
        return pulumi.get(self, "in_use_bies")

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent that will provision the APM Agent.
        """
        return pulumi.get(self, "management_agent_id")

    @_builtins.property
    @pulumi.getter(name="matchAgentsWithAttributeKeys")
    def match_agents_with_attribute_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The agent attribute KEY by which an Agent configuration is matched to an agent.  All agent configuration objects share the same key. It is [ServiceName, service.name] by default.  The attribute VALUE corresponding to this KEY is in the matchAgentsWithAttributeValue field.
        """
        return pulumi.get(self, "match_agents_with_attribute_keys")

    @_builtins.property
    @pulumi.getter(name="matchAgentsWithAttributeValue")
    def match_agents_with_attribute_value(self) -> pulumi.Output[_builtins.str]:
        """
        The agent attribute VALUE by which an agent configuration is matched to an agent.  Each agent configuration object must specify a different value.  The attribute KEY corresponding to this VALUE is in the matchAgentsWithAttributeKey field.
        """
        return pulumi.get(self, "match_agents_with_attribute_value")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Sequence['outputs.ConfigMetric']]:
        """
        (Updatable) The list of metrics in this group.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The namespace to which the metrics are published. It must be one of several predefined namespaces.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The options are stored here as JSON.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def overrides(self) -> pulumi.Output['outputs.ConfigOverrides']:
        """
        (Updatable) Agent configuration overrides that should apply to a subset of the agents associated with an Agent Config object.
        """
        return pulumi.get(self, "overrides")

    @_builtins.property
    @pulumi.getter(name="processFilters")
    def process_filters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) Filter patterns used to discover active Java processes for provisioning the APM Agent.
        """
        return pulumi.get(self, "process_filters")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.ConfigRule']]:
        """
        (Updatable)
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OS user that should be used to discover Java processes.
        """
        return pulumi.get(self, "run_as_user")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of the service being monitored. This argument enables you to filter by service and view traces and other signals in the APM Explorer user interface. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "updated_by")

