# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVantagePointResult',
    'AwaitableGetVantagePointResult',
    'get_vantage_point',
    'get_vantage_point_output',
]

@pulumi.output_type
class GetVantagePointResult:
    """
    A collection of values returned by getVantagePoint.
    """
    def __init__(__self__, apm_domain_id=None, display_name=None, id=None, items=None, name=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> _builtins.str:
        return pulumi.get(self, "apm_domain_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVantagePointItemResult']:
        """
        List of PublicVantagePointSummary items.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Unique permanent name of the vantage point.
        """
        return pulumi.get(self, "name")


class AwaitableGetVantagePointResult(GetVantagePointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVantagePointResult(
            apm_domain_id=self.apm_domain_id,
            display_name=self.display_name,
            id=self.id,
            items=self.items,
            name=self.name)


def get_vantage_point(apm_domain_id: Optional[_builtins.str] = None,
                      display_name: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVantagePointResult:
    """
    This data source provides details about a specific Public Vantage Point resource in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

    Returns a list of public vantage points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_vantage_point = oci.ApmSynthetics.get_vantage_point(apm_domain_id=test_apm_domain["id"],
        display_name=public_vantage_point_display_name,
        name=public_vantage_point_name)
    ```


    :param _builtins.str apm_domain_id: The APM domain ID the request is intended for.
    :param _builtins.str display_name: A filter to return only the resources that match the entire display name.
    :param _builtins.str name: A filter to return only the resources that match the entire name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['displayName'] = display_name
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getVantagePoint:getVantagePoint', __args__, opts=opts, typ=GetVantagePointResult).value

    return AwaitableGetVantagePointResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        name=pulumi.get(__ret__, 'name'))
def get_vantage_point_output(apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                             display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVantagePointResult]:
    """
    This data source provides details about a specific Public Vantage Point resource in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

    Returns a list of public vantage points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_vantage_point = oci.ApmSynthetics.get_vantage_point(apm_domain_id=test_apm_domain["id"],
        display_name=public_vantage_point_display_name,
        name=public_vantage_point_name)
    ```


    :param _builtins.str apm_domain_id: The APM domain ID the request is intended for.
    :param _builtins.str display_name: A filter to return only the resources that match the entire display name.
    :param _builtins.str name: A filter to return only the resources that match the entire name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['displayName'] = display_name
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmSynthetics/getVantagePoint:getVantagePoint', __args__, opts=opts, typ=GetVantagePointResult)
    return __ret__.apply(lambda __response__: GetVantagePointResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        name=pulumi.get(__response__, 'name')))
