# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ContainerRepositoryReadme',
    'GetContainerImageLayerResult',
    'GetContainerImageVersionResult',
    'GetContainerImagesContainerImageCollectionResult',
    'GetContainerImagesContainerImageCollectionItemResult',
    'GetContainerImagesContainerImageCollectionItemLayerResult',
    'GetContainerImagesContainerImageCollectionItemVersionResult',
    'GetContainerImagesFilterResult',
    'GetContainerRepositoriesContainerRepositoryCollectionResult',
    'GetContainerRepositoriesContainerRepositoryCollectionItemResult',
    'GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult',
    'GetContainerRepositoriesFilterResult',
    'GetContainerRepositoryReadmeResult',
    'GetContainerSignaturesContainerImageSignatureCollectionResult',
    'GetContainerSignaturesContainerImageSignatureCollectionItemResult',
    'GetContainerSignaturesFilterResult',
    'GetGenericArtifactsFilterResult',
    'GetGenericArtifactsGenericArtifactCollectionResult',
    'GetGenericArtifactsGenericArtifactCollectionItemResult',
    'GetRepositoriesFilterResult',
    'GetRepositoriesRepositoryCollectionResult',
    'GetRepositoriesRepositoryCollectionItemResult',
]

@pulumi.output_type
class ContainerRepositoryReadme(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 format: _builtins.str):
        """
        :param _builtins.str content: (Updatable) Readme content. Avoid entering confidential information.
        :param _builtins.str format: (Updatable) Readme format. Supported formats are text/plain and text/markdown.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "format", format)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        (Updatable) Readme content. Avoid entering confidential information.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        (Updatable) Readme format. Supported formats are text/plain and text/markdown.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class GetContainerImageLayerResult(dict):
    def __init__(__self__, *,
                 digest: _builtins.str,
                 size_in_bytes: _builtins.str,
                 time_created: _builtins.str):
        """
        :param _builtins.str digest: The sha256 digest of the image layer.
        :param _builtins.str size_in_bytes: The size of the layer in bytes.
        :param _builtins.str time_created: The creation time of the version.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> _builtins.str:
        """
        The sha256 digest of the image layer.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> _builtins.str:
        """
        The size of the layer in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetContainerImageVersionResult(dict):
    def __init__(__self__, *,
                 created_by: _builtins.str,
                 time_created: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str created_by: The OCID of the user or principal that pushed the version.
        :param _builtins.str time_created: The creation time of the version.
        :param _builtins.str version: The version name.
        """
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The OCID of the user or principal that pushed the version.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version name.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetContainerImagesContainerImageCollectionItemResult'],
                 remaining_items_count: _builtins.int):
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "remaining_items_count", remaining_items_count)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetContainerImagesContainerImageCollectionItemResult']:
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="remainingItemsCount")
    def remaining_items_count(self) -> _builtins.int:
        return pulumi.get(self, "remaining_items_count")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 created_by: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 digest: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 layers: Sequence['outputs.GetContainerImagesContainerImageCollectionItemLayerResult'],
                 layers_size_in_bytes: _builtins.str,
                 manifest_size_in_bytes: _builtins.int,
                 pull_count: _builtins.str,
                 repository_id: _builtins.str,
                 repository_name: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_last_pulled: _builtins.str,
                 version: _builtins.str,
                 versions: Sequence['outputs.GetContainerImagesContainerImageCollectionItemVersionResult']):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param _builtins.str created_by: The OCID of the user or principal that pushed the version.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str digest: The sha256 digest of the image layer.
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image.  Example: `ocid1.containerimage.oc1..exampleuniqueID`
        :param Sequence['GetContainerImagesContainerImageCollectionItemLayerArgs'] layers: Layers of which the image is composed, ordered by the layer digest.
        :param _builtins.str layers_size_in_bytes: The total size of the container image layers in bytes.
        :param _builtins.int manifest_size_in_bytes: The size of the container image manifest in bytes.
        :param _builtins.str pull_count: Total number of pulls.
        :param _builtins.str repository_id: A filter to return container images only for the specified container repository OCID.
        :param _builtins.str repository_name: A filter to return container images or container image signatures that match the repository name.  Example: `foo` or `foo*`
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param Mapping[str, _builtins.str] system_tags: The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The creation time of the version.
        :param _builtins.str time_last_pulled: An RFC 3339 timestamp indicating when the image was last pulled.
        :param _builtins.str version: A filter to return container images that match the version.  Example: `foo` or `foo*`
        :param Sequence['GetContainerImagesContainerImageCollectionItemVersionArgs'] versions: The versions associated with this image.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "layers", layers)
        pulumi.set(__self__, "layers_size_in_bytes", layers_size_in_bytes)
        pulumi.set(__self__, "manifest_size_in_bytes", manifest_size_in_bytes)
        pulumi.set(__self__, "pull_count", pull_count)
        pulumi.set(__self__, "repository_id", repository_id)
        pulumi.set(__self__, "repository_name", repository_name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_pulled", time_last_pulled)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The OCID of the user or principal that pushed the version.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> _builtins.str:
        """
        The sha256 digest of the image layer.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image.  Example: `ocid1.containerimage.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def layers(self) -> Sequence['outputs.GetContainerImagesContainerImageCollectionItemLayerResult']:
        """
        Layers of which the image is composed, ordered by the layer digest.
        """
        return pulumi.get(self, "layers")

    @_builtins.property
    @pulumi.getter(name="layersSizeInBytes")
    def layers_size_in_bytes(self) -> _builtins.str:
        """
        The total size of the container image layers in bytes.
        """
        return pulumi.get(self, "layers_size_in_bytes")

    @_builtins.property
    @pulumi.getter(name="manifestSizeInBytes")
    def manifest_size_in_bytes(self) -> _builtins.int:
        """
        The size of the container image manifest in bytes.
        """
        return pulumi.get(self, "manifest_size_in_bytes")

    @_builtins.property
    @pulumi.getter(name="pullCount")
    def pull_count(self) -> _builtins.str:
        """
        Total number of pulls.
        """
        return pulumi.get(self, "pull_count")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        """
        A filter to return container images only for the specified container repository OCID.
        """
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> _builtins.str:
        """
        A filter to return container images or container image signatures that match the repository name.  Example: `foo` or `foo*`
        """
        return pulumi.get(self, "repository_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastPulled")
    def time_last_pulled(self) -> _builtins.str:
        """
        An RFC 3339 timestamp indicating when the image was last pulled.
        """
        return pulumi.get(self, "time_last_pulled")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        A filter to return container images that match the version.  Example: `foo` or `foo*`
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetContainerImagesContainerImageCollectionItemVersionResult']:
        """
        The versions associated with this image.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionItemLayerResult(dict):
    def __init__(__self__, *,
                 digest: _builtins.str,
                 size_in_bytes: _builtins.str,
                 time_created: _builtins.str):
        """
        :param _builtins.str digest: The sha256 digest of the image layer.
        :param _builtins.str size_in_bytes: The size of the layer in bytes.
        :param _builtins.str time_created: The creation time of the version.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> _builtins.str:
        """
        The sha256 digest of the image layer.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> _builtins.str:
        """
        The size of the layer in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionItemVersionResult(dict):
    def __init__(__self__, *,
                 created_by: _builtins.str,
                 time_created: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str created_by: The OCID of the user or principal that pushed the version.
        :param _builtins.str time_created: The creation time of the version.
        :param _builtins.str version: A filter to return container images that match the version.  Example: `foo` or `foo*`
        """
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The OCID of the user or principal that pushed the version.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        A filter to return container images that match the version.  Example: `foo` or `foo*`
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetContainerImagesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetContainerRepositoriesContainerRepositoryCollectionResult(dict):
    def __init__(__self__, *,
                 image_count: _builtins.int,
                 items: Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemResult'],
                 layer_count: _builtins.int,
                 layers_size_in_bytes: _builtins.str,
                 remaining_items_count: _builtins.int,
                 repository_count: _builtins.int):
        """
        :param _builtins.int image_count: Total number of images.
        :param _builtins.int layer_count: Total number of layers.
        :param _builtins.str layers_size_in_bytes: Total storage in bytes consumed by layers.
        """
        pulumi.set(__self__, "image_count", image_count)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "layer_count", layer_count)
        pulumi.set(__self__, "layers_size_in_bytes", layers_size_in_bytes)
        pulumi.set(__self__, "remaining_items_count", remaining_items_count)
        pulumi.set(__self__, "repository_count", repository_count)

    @_builtins.property
    @pulumi.getter(name="imageCount")
    def image_count(self) -> _builtins.int:
        """
        Total number of images.
        """
        return pulumi.get(self, "image_count")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemResult']:
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="layerCount")
    def layer_count(self) -> _builtins.int:
        """
        Total number of layers.
        """
        return pulumi.get(self, "layer_count")

    @_builtins.property
    @pulumi.getter(name="layersSizeInBytes")
    def layers_size_in_bytes(self) -> _builtins.str:
        """
        Total storage in bytes consumed by layers.
        """
        return pulumi.get(self, "layers_size_in_bytes")

    @_builtins.property
    @pulumi.getter(name="remainingItemsCount")
    def remaining_items_count(self) -> _builtins.int:
        return pulumi.get(self, "remaining_items_count")

    @_builtins.property
    @pulumi.getter(name="repositoryCount")
    def repository_count(self) -> _builtins.int:
        return pulumi.get(self, "repository_count")


@pulumi.output_type
class GetContainerRepositoriesContainerRepositoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 billable_size_in_gbs: _builtins.str,
                 compartment_id: _builtins.str,
                 created_by: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 image_count: _builtins.int,
                 is_immutable: _builtins.bool,
                 is_public: _builtins.bool,
                 layer_count: _builtins.int,
                 layers_size_in_bytes: _builtins.str,
                 namespace: _builtins.str,
                 readmes: Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_last_pushed: _builtins.str):
        """
        :param _builtins.str billable_size_in_gbs: Total storage size in GBs that will be charged.
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param _builtins.str created_by: The id of the user or principal that created the resource.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container repository.  Example: `ocid1.containerrepo.oc1..exampleuniqueID`
        :param _builtins.int image_count: Total number of images.
        :param _builtins.bool is_immutable: Whether the repository is immutable. Images cannot be overwritten in an immutable repository.
        :param _builtins.bool is_public: A filter to return resources that match the isPublic value.
        :param _builtins.int layer_count: Total number of layers.
        :param _builtins.str layers_size_in_bytes: Total storage in bytes consumed by layers.
        :param _builtins.str namespace: The tenancy namespace used in the container repository path.
        :param Sequence['GetContainerRepositoriesContainerRepositoryCollectionItemReadmeArgs'] readmes: Container repository readme.
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param Mapping[str, _builtins.str] system_tags: The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: An RFC 3339 timestamp indicating when the repository was created.
        :param _builtins.str time_last_pushed: An RFC 3339 timestamp indicating when an image was last pushed to the repository.
        """
        pulumi.set(__self__, "billable_size_in_gbs", billable_size_in_gbs)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_count", image_count)
        pulumi.set(__self__, "is_immutable", is_immutable)
        pulumi.set(__self__, "is_public", is_public)
        pulumi.set(__self__, "layer_count", layer_count)
        pulumi.set(__self__, "layers_size_in_bytes", layers_size_in_bytes)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "readmes", readmes)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_pushed", time_last_pushed)

    @_builtins.property
    @pulumi.getter(name="billableSizeInGbs")
    def billable_size_in_gbs(self) -> _builtins.str:
        """
        Total storage size in GBs that will be charged.
        """
        return pulumi.get(self, "billable_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The id of the user or principal that created the resource.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container repository.  Example: `ocid1.containerrepo.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageCount")
    def image_count(self) -> _builtins.int:
        """
        Total number of images.
        """
        return pulumi.get(self, "image_count")

    @_builtins.property
    @pulumi.getter(name="isImmutable")
    def is_immutable(self) -> _builtins.bool:
        """
        Whether the repository is immutable. Images cannot be overwritten in an immutable repository.
        """
        return pulumi.get(self, "is_immutable")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> _builtins.bool:
        """
        A filter to return resources that match the isPublic value.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter(name="layerCount")
    def layer_count(self) -> _builtins.int:
        """
        Total number of layers.
        """
        return pulumi.get(self, "layer_count")

    @_builtins.property
    @pulumi.getter(name="layersSizeInBytes")
    def layers_size_in_bytes(self) -> _builtins.str:
        """
        Total storage in bytes consumed by layers.
        """
        return pulumi.get(self, "layers_size_in_bytes")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The tenancy namespace used in the container repository path.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def readmes(self) -> Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult']:
        """
        Container repository readme.
        """
        return pulumi.get(self, "readmes")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        An RFC 3339 timestamp indicating when the repository was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastPushed")
    def time_last_pushed(self) -> _builtins.str:
        """
        An RFC 3339 timestamp indicating when an image was last pushed to the repository.
        """
        return pulumi.get(self, "time_last_pushed")


@pulumi.output_type
class GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 format: _builtins.str):
        """
        :param _builtins.str content: Readme content. Avoid entering confidential information.
        :param _builtins.str format: Readme format. Supported formats are text/plain and text/markdown.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "format", format)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Readme content. Avoid entering confidential information.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        Readme format. Supported formats are text/plain and text/markdown.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class GetContainerRepositoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetContainerRepositoryReadmeResult(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 format: _builtins.str):
        """
        :param _builtins.str content: Readme content. Avoid entering confidential information.
        :param _builtins.str format: Readme format. Supported formats are text/plain and text/markdown.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "format", format)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Readme content. Avoid entering confidential information.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        Readme format. Supported formats are text/plain and text/markdown.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class GetContainerSignaturesContainerImageSignatureCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetContainerSignaturesContainerImageSignatureCollectionItemResult'],
                 remaining_items_count: _builtins.int):
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "remaining_items_count", remaining_items_count)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetContainerSignaturesContainerImageSignatureCollectionItemResult']:
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="remainingItemsCount")
    def remaining_items_count(self) -> _builtins.int:
        return pulumi.get(self, "remaining_items_count")


@pulumi.output_type
class GetContainerSignaturesContainerImageSignatureCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 created_by: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 image_id: _builtins.str,
                 kms_key_id: _builtins.str,
                 kms_key_version_id: _builtins.str,
                 message: _builtins.str,
                 signature: _builtins.str,
                 signing_algorithm: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param _builtins.str created_by: The id of the user or principal that created the resource.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image signature.  Example: `ocid1.containerimagesignature.oc1..exampleuniqueID`
        :param _builtins.str image_id: A filter to return a container image summary only for the specified container image OCID.
        :param _builtins.str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        :param _builtins.str kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        :param _builtins.str message: The base64 encoded signature payload that was signed.
        :param _builtins.str signature: The signature of the message field using the kmsKeyId, the kmsKeyVersionId, and the signingAlgorithm.
        :param _builtins.str signing_algorithm: The algorithm to be used for signing. These are the only supported signing algorithms for container images.
        :param _builtins.str state: The current state of the container image signature.
        :param Mapping[str, _builtins.str] system_tags: The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: An RFC 3339 timestamp indicating when the image was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "signature", signature)
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The id of the user or principal that created the resource.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image signature.  Example: `ocid1.containerimagesignature.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        A filter to return a container image summary only for the specified container image OCID.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "kms_key_version_id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        The base64 encoded signature payload that was signed.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def signature(self) -> _builtins.str:
        """
        The signature of the message field using the kmsKeyId, the kmsKeyVersionId, and the signingAlgorithm.
        """
        return pulumi.get(self, "signature")

    @_builtins.property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> _builtins.str:
        """
        The algorithm to be used for signing. These are the only supported signing algorithms for container images.
        """
        return pulumi.get(self, "signing_algorithm")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the container image signature.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        An RFC 3339 timestamp indicating when the image was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetContainerSignaturesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetGenericArtifactsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetGenericArtifactsGenericArtifactCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetGenericArtifactsGenericArtifactCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetGenericArtifactsGenericArtifactCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetGenericArtifactsGenericArtifactCollectionItemResult(dict):
    def __init__(__self__, *,
                 artifact_id: _builtins.str,
                 artifact_path: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 repository_id: _builtins.str,
                 sha256: _builtins.str,
                 size_in_bytes: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str artifact_path: Filter results by a prefix for the `artifactPath` and and return artifacts that begin with the specified prefix in their path.
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: A filter to return the resources for the specified OCID.
        :param _builtins.str repository_id: A filter to return the artifacts only for the specified repository OCID.
        :param _builtins.str sha256: Filter results by a specified SHA256 digest for the artifact.
        :param _builtins.str size_in_bytes: The size of the artifact in bytes.
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param _builtins.str time_created: An RFC 3339 timestamp indicating when the repository was created.
        :param _builtins.str version: Filter results by a prefix for `version` and return artifacts that that begin with the specified prefix in their version.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "artifact_path", artifact_path)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "repository_id", repository_id)
        pulumi.set(__self__, "sha256", sha256)
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> _builtins.str:
        return pulumi.get(self, "artifact_id")

    @_builtins.property
    @pulumi.getter(name="artifactPath")
    def artifact_path(self) -> _builtins.str:
        """
        Filter results by a prefix for the `artifactPath` and and return artifacts that begin with the specified prefix in their path.
        """
        return pulumi.get(self, "artifact_path")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A filter to return the resources for the specified OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        """
        A filter to return the artifacts only for the specified repository OCID.
        """
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter
    def sha256(self) -> _builtins.str:
        """
        Filter results by a specified SHA256 digest for the artifact.
        """
        return pulumi.get(self, "sha256")

    @_builtins.property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> _builtins.str:
        """
        The size of the artifact in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        An RFC 3339 timestamp indicating when the repository was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Filter results by a prefix for `version` and return artifacts that that begin with the specified prefix in their version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetRepositoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRepositoriesRepositoryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRepositoriesRepositoryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRepositoriesRepositoryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRepositoriesRepositoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_immutable: _builtins.bool,
                 repository_type: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: The repository description.
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: A filter to return the resources for the specified OCID.
        :param _builtins.bool is_immutable: A filter to return resources that match the isImmutable value.
        :param _builtins.str repository_type: The repository's supported artifact type.
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param _builtins.str time_created: An RFC 3339 timestamp indicating when the repository was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_immutable", is_immutable)
        pulumi.set(__self__, "repository_type", repository_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The repository description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A filter to return the resources for the specified OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isImmutable")
    def is_immutable(self) -> _builtins.bool:
        """
        A filter to return resources that match the isImmutable value.
        """
        return pulumi.get(self, "is_immutable")

    @_builtins.property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> _builtins.str:
        """
        The repository's supported artifact type.
        """
        return pulumi.get(self, "repository_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        An RFC 3339 timestamp indicating when the repository was created.
        """
        return pulumi.get(self, "time_created")


