# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AutoScalingConfigurationAutoScalingResourcesArgs',
    'AutoScalingConfigurationAutoScalingResourcesArgsDict',
    'AutoScalingConfigurationPolicyArgs',
    'AutoScalingConfigurationPolicyArgsDict',
    'AutoScalingConfigurationPolicyCapacityArgs',
    'AutoScalingConfigurationPolicyCapacityArgsDict',
    'AutoScalingConfigurationPolicyExecutionScheduleArgs',
    'AutoScalingConfigurationPolicyExecutionScheduleArgsDict',
    'AutoScalingConfigurationPolicyResourceActionArgs',
    'AutoScalingConfigurationPolicyResourceActionArgsDict',
    'AutoScalingConfigurationPolicyRuleArgs',
    'AutoScalingConfigurationPolicyRuleArgsDict',
    'AutoScalingConfigurationPolicyRuleActionArgs',
    'AutoScalingConfigurationPolicyRuleActionArgsDict',
    'AutoScalingConfigurationPolicyRuleMetricArgs',
    'AutoScalingConfigurationPolicyRuleMetricArgsDict',
    'AutoScalingConfigurationPolicyRuleMetricThresholdArgs',
    'AutoScalingConfigurationPolicyRuleMetricThresholdArgsDict',
    'GetAutoScalingConfigurationsFilterArgs',
    'GetAutoScalingConfigurationsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class AutoScalingConfigurationAutoScalingResourcesArgsDict(TypedDict):
        id: pulumi.Input[_builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of resource.
        """
elif False:
    AutoScalingConfigurationAutoScalingResourcesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingConfigurationAutoScalingResourcesArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        :param pulumi.Input[_builtins.str] type: The type of resource.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class AutoScalingConfigurationPolicyArgsDict(TypedDict):
        policy_type: pulumi.Input[_builtins.str]
        """
        The type of autoscaling policy.
        """
        capacity: NotRequired[pulumi.Input['AutoScalingConfigurationPolicyCapacityArgsDict']]
        """
        The capacity requirements of the autoscaling policy.
        """
        display_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        execution_schedule: NotRequired[pulumi.Input['AutoScalingConfigurationPolicyExecutionScheduleArgsDict']]
        """
        An execution schedule for an autoscaling policy.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the condition that is assigned after creation.
        """
        is_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the autoscaling policy is enabled.
        """
        resource_action: NotRequired[pulumi.Input['AutoScalingConfigurationPolicyResourceActionArgsDict']]
        """
        An action to run on a resource, such as stopping or starting an instance pool.
        """
        rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyRuleArgsDict']]]]
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
elif False:
    AutoScalingConfigurationPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingConfigurationPolicyArgs:
    def __init__(__self__, *,
                 policy_type: pulumi.Input[_builtins.str],
                 capacity: Optional[pulumi.Input['AutoScalingConfigurationPolicyCapacityArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_schedule: Optional[pulumi.Input['AutoScalingConfigurationPolicyExecutionScheduleArgs']] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_action: Optional[pulumi.Input['AutoScalingConfigurationPolicyResourceActionArgs']] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyRuleArgs']]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] policy_type: The type of autoscaling policy.
        :param pulumi.Input['AutoScalingConfigurationPolicyCapacityArgs'] capacity: The capacity requirements of the autoscaling policy.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input['AutoScalingConfigurationPolicyExecutionScheduleArgs'] execution_schedule: An execution schedule for an autoscaling policy.
        :param pulumi.Input[_builtins.str] id: ID of the condition that is assigned after creation.
        :param pulumi.Input[_builtins.bool] is_enabled: Whether the autoscaling policy is enabled.
        :param pulumi.Input['AutoScalingConfigurationPolicyResourceActionArgs'] resource_action: An action to run on a resource, such as stopping or starting an instance pool.
        :param pulumi.Input[_builtins.str] time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "policy_type", policy_type)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if execution_schedule is not None:
            pulumi.set(__self__, "execution_schedule", execution_schedule)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if resource_action is not None:
            pulumi.set(__self__, "resource_action", resource_action)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of autoscaling policy.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input['AutoScalingConfigurationPolicyCapacityArgs']]:
        """
        The capacity requirements of the autoscaling policy.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input['AutoScalingConfigurationPolicyCapacityArgs']]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="executionSchedule")
    def execution_schedule(self) -> Optional[pulumi.Input['AutoScalingConfigurationPolicyExecutionScheduleArgs']]:
        """
        An execution schedule for an autoscaling policy.
        """
        return pulumi.get(self, "execution_schedule")

    @execution_schedule.setter
    def execution_schedule(self, value: Optional[pulumi.Input['AutoScalingConfigurationPolicyExecutionScheduleArgs']]):
        pulumi.set(self, "execution_schedule", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceAction")
    def resource_action(self) -> Optional[pulumi.Input['AutoScalingConfigurationPolicyResourceActionArgs']]:
        """
        An action to run on a resource, such as stopping or starting an instance pool.
        """
        return pulumi.get(self, "resource_action")

    @resource_action.setter
    def resource_action(self, value: Optional[pulumi.Input['AutoScalingConfigurationPolicyResourceActionArgs']]):
        pulumi.set(self, "resource_action", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyRuleArgs']]]]:
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class AutoScalingConfigurationPolicyCapacityArgsDict(TypedDict):
        initial: NotRequired[pulumi.Input[_builtins.int]]
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.

        For a schedule-based autoscaling policy, this value is the target pool size to scale to when executing the schedule that's defined in the autoscaling policy.
        """
        max: NotRequired[pulumi.Input[_builtins.int]]
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).

        For a schedule-based autoscaling policy, this value is not used.
        """
        min: NotRequired[pulumi.Input[_builtins.int]]
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).

        For a schedule-based autoscaling policy, this value is not used.
        """
elif False:
    AutoScalingConfigurationPolicyCapacityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingConfigurationPolicyCapacityArgs:
    def __init__(__self__, *,
                 initial: Optional[pulumi.Input[_builtins.int]] = None,
                 max: Optional[pulumi.Input[_builtins.int]] = None,
                 min: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] initial: For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
               
               For a schedule-based autoscaling policy, this value is the target pool size to scale to when executing the schedule that's defined in the autoscaling policy.
        :param pulumi.Input[_builtins.int] max: For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
               
               For a schedule-based autoscaling policy, this value is not used.
        :param pulumi.Input[_builtins.int] min: For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
               
               For a schedule-based autoscaling policy, this value is not used.
        """
        if initial is not None:
            pulumi.set(__self__, "initial", initial)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def initial(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.

        For a schedule-based autoscaling policy, this value is the target pool size to scale to when executing the schedule that's defined in the autoscaling policy.
        """
        return pulumi.get(self, "initial")

    @initial.setter
    def initial(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial", value)

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).

        For a schedule-based autoscaling policy, this value is not used.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max", value)

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).

        For a schedule-based autoscaling policy, this value is not used.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min", value)


if not MYPY:
    class AutoScalingConfigurationPolicyExecutionScheduleArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        """
        A cron expression that represents the time at which to execute the autoscaling policy.

        Cron expressions have this format: `<second> <minute> <hour> <day of month> <month> <day of week> <year>`

        You can use special characters that are supported with the Quartz cron implementation.

        You must specify `0` as the value for seconds.

        Example: `0 15 10 ? * *`
        """
        timezone: pulumi.Input[_builtins.str]
        """
        The time zone for the execution schedule.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of execution schedule.
        """
elif False:
    AutoScalingConfigurationPolicyExecutionScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingConfigurationPolicyExecutionScheduleArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 timezone: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] expression: A cron expression that represents the time at which to execute the autoscaling policy.
               
               Cron expressions have this format: `<second> <minute> <hour> <day of month> <month> <day of week> <year>`
               
               You can use special characters that are supported with the Quartz cron implementation.
               
               You must specify `0` as the value for seconds.
               
               Example: `0 15 10 ? * *`
        :param pulumi.Input[_builtins.str] timezone: The time zone for the execution schedule.
        :param pulumi.Input[_builtins.str] type: The type of execution schedule.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        A cron expression that represents the time at which to execute the autoscaling policy.

        Cron expressions have this format: `<second> <minute> <hour> <day of month> <month> <day of week> <year>`

        You can use special characters that are supported with the Quartz cron implementation.

        You must specify `0` as the value for seconds.

        Example: `0 15 10 ? * *`
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Input[_builtins.str]:
        """
        The time zone for the execution schedule.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of execution schedule.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class AutoScalingConfigurationPolicyResourceActionArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        action_type: pulumi.Input[_builtins.str]
        """
        The category of action to run on the resource.
        """
elif False:
    AutoScalingConfigurationPolicyResourceActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingConfigurationPolicyResourceActionArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 action_type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] action_type: The category of action to run on the resource.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "action_type", action_type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[_builtins.str]:
        """
        The category of action to run on the resource.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action_type", value)


if not MYPY:
    class AutoScalingConfigurationPolicyRuleArgsDict(TypedDict):
        display_name: pulumi.Input[_builtins.str]
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        action: NotRequired[pulumi.Input['AutoScalingConfigurationPolicyRuleActionArgsDict']]
        """
        The action to take when autoscaling is triggered.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the condition that is assigned after creation.
        """
        metric: NotRequired[pulumi.Input['AutoScalingConfigurationPolicyRuleMetricArgsDict']]
elif False:
    AutoScalingConfigurationPolicyRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingConfigurationPolicyRuleArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 action: Optional[pulumi.Input['AutoScalingConfigurationPolicyRuleActionArgs']] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 metric: Optional[pulumi.Input['AutoScalingConfigurationPolicyRuleMetricArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input['AutoScalingConfigurationPolicyRuleActionArgs'] action: The action to take when autoscaling is triggered.
        :param pulumi.Input[_builtins.str] id: ID of the condition that is assigned after creation.
        """
        pulumi.set(__self__, "display_name", display_name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['AutoScalingConfigurationPolicyRuleActionArgs']]:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['AutoScalingConfigurationPolicyRuleActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input['AutoScalingConfigurationPolicyRuleMetricArgs']]:
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input['AutoScalingConfigurationPolicyRuleMetricArgs']]):
        pulumi.set(self, "metric", value)


if not MYPY:
    class AutoScalingConfigurationPolicyRuleActionArgsDict(TypedDict):
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of action to take.
        """
        value: NotRequired[pulumi.Input[_builtins.int]]
        """
        To scale out (increase the number of instances), provide a positive value. To scale in (decrease the number of instances), provide a negative value.
        """
elif False:
    AutoScalingConfigurationPolicyRuleActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingConfigurationPolicyRuleActionArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The type of action to take.
        :param pulumi.Input[_builtins.int] value: To scale out (increase the number of instances), provide a positive value. To scale in (decrease the number of instances), provide a negative value.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        To scale out (increase the number of instances), provide a positive value. To scale in (decrease the number of instances), provide a negative value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AutoScalingConfigurationPolicyRuleMetricArgsDict(TypedDict):
        metric_compartment_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The OCID of the compartment containing the metrics.
        """
        metric_source: NotRequired[pulumi.Input[_builtins.str]]
        """
        Source of the metric data for creating the alarm used to trigger autoscaling actions.

        The following values are supported:
        * `COMPUTE_AGENT`: CPU or memory metrics emitted by the Compute Instance Monitoring plugin.
        * `CUSTOM_QUERY`: A custom Monitoring Query Language (MQL) expression.
        """
        metric_type: NotRequired[pulumi.Input[_builtins.str]]
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The namespace for the query.
        """
        pending_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING" or vice versa. For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING"; likewise, the alarm must persist in not breaching the condition for five minutes before the alarm updates its state to "OK."

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT3M. Maximum: PT1H. Default: PT3M.
        """
        query: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval: `1m`-`60m` (also `1h`). You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`.

        Example of threshold alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85

        -----
        """
        resource_group: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource group for the query.
        """
        threshold: NotRequired[pulumi.Input['AutoScalingConfigurationPolicyRuleMetricThresholdArgsDict']]
elif False:
    AutoScalingConfigurationPolicyRuleMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingConfigurationPolicyRuleMetricArgs:
    def __init__(__self__, *,
                 metric_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_source: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 threshold: Optional[pulumi.Input['AutoScalingConfigurationPolicyRuleMetricThresholdArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] metric_compartment_id: The OCID of the compartment containing the metrics.
        :param pulumi.Input[_builtins.str] metric_source: Source of the metric data for creating the alarm used to trigger autoscaling actions.
               
               The following values are supported:
               * `COMPUTE_AGENT`: CPU or memory metrics emitted by the Compute Instance Monitoring plugin.
               * `CUSTOM_QUERY`: A custom Monitoring Query Language (MQL) expression.
        :param pulumi.Input[_builtins.str] namespace: The namespace for the query.
        :param pulumi.Input[_builtins.str] pending_duration: The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING" or vice versa. For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING"; likewise, the alarm must persist in not breaching the condition for five minutes before the alarm updates its state to "OK."
               
               The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT3M. Maximum: PT1H. Default: PT3M.
        :param pulumi.Input[_builtins.str] query: The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval: `1m`-`60m` (also `1h`). You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`.
               
               Example of threshold alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85
               
               -----
        :param pulumi.Input[_builtins.str] resource_group: The resource group for the query.
        """
        if metric_compartment_id is not None:
            pulumi.set(__self__, "metric_compartment_id", metric_compartment_id)
        if metric_source is not None:
            pulumi.set(__self__, "metric_source", metric_source)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if pending_duration is not None:
            pulumi.set(__self__, "pending_duration", pending_duration)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter(name="metricCompartmentId")
    def metric_compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment containing the metrics.
        """
        return pulumi.get(self, "metric_compartment_id")

    @metric_compartment_id.setter
    def metric_compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="metricSource")
    def metric_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source of the metric data for creating the alarm used to trigger autoscaling actions.

        The following values are supported:
        * `COMPUTE_AGENT`: CPU or memory metrics emitted by the Compute Instance Monitoring plugin.
        * `CUSTOM_QUERY`: A custom Monitoring Query Language (MQL) expression.
        """
        return pulumi.get(self, "metric_source")

    @metric_source.setter
    def metric_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_source", value)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_type", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace for the query.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="pendingDuration")
    def pending_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING" or vice versa. For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING"; likewise, the alarm must persist in not breaching the condition for five minutes before the alarm updates its state to "OK."

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT3M. Maximum: PT1H. Default: PT3M.
        """
        return pulumi.get(self, "pending_duration")

    @pending_duration.setter
    def pending_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pending_duration", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval: `1m`-`60m` (also `1h`). You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`.

        Example of threshold alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85

        -----
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group for the query.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input['AutoScalingConfigurationPolicyRuleMetricThresholdArgs']]:
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input['AutoScalingConfigurationPolicyRuleMetricThresholdArgs']]):
        pulumi.set(self, "threshold", value)


if not MYPY:
    class AutoScalingConfigurationPolicyRuleMetricThresholdArgsDict(TypedDict):
        operator: NotRequired[pulumi.Input[_builtins.str]]
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        value: NotRequired[pulumi.Input[_builtins.int]]
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    AutoScalingConfigurationPolicyRuleMetricThresholdArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingConfigurationPolicyRuleMetricThresholdArgs:
    def __init__(__self__, *,
                 operator: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] operator: The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        :param pulumi.Input[_builtins.int] value: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operator", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class GetAutoScalingConfigurationsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetAutoScalingConfigurationsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAutoScalingConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


