# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'SessionKeyDetails',
    'SessionTargetResourceDetails',
    'GetBastionsBastionResult',
    'GetBastionsFilterResult',
    'GetSessionKeyDetailResult',
    'GetSessionTargetResourceDetailResult',
    'GetSessionsFilterResult',
    'GetSessionsSessionResult',
    'GetSessionsSessionKeyDetailResult',
    'GetSessionsSessionTargetResourceDetailResult',
]

@pulumi.output_type
class SessionKeyDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeyContent":
            suggest = "public_key_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SessionKeyDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SessionKeyDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SessionKeyDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key_content: _builtins.str):
        """
        :param _builtins.str public_key_content: The public key in OpenSSH format of the SSH key pair for the session. When you connect to the session, you must provide the private key of the same SSH key pair.
        """
        pulumi.set(__self__, "public_key_content", public_key_content)

    @_builtins.property
    @pulumi.getter(name="publicKeyContent")
    def public_key_content(self) -> _builtins.str:
        """
        The public key in OpenSSH format of the SSH key pair for the session. When you connect to the session, you must provide the private key of the same SSH key pair.
        """
        return pulumi.get(self, "public_key_content")


@pulumi.output_type
class SessionTargetResourceDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sessionType":
            suggest = "session_type"
        elif key == "targetResourceDisplayName":
            suggest = "target_resource_display_name"
        elif key == "targetResourceFqdn":
            suggest = "target_resource_fqdn"
        elif key == "targetResourceId":
            suggest = "target_resource_id"
        elif key == "targetResourceOperatingSystemUserName":
            suggest = "target_resource_operating_system_user_name"
        elif key == "targetResourcePort":
            suggest = "target_resource_port"
        elif key == "targetResourcePrivateIpAddress":
            suggest = "target_resource_private_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SessionTargetResourceDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SessionTargetResourceDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SessionTargetResourceDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 session_type: _builtins.str,
                 target_resource_display_name: Optional[_builtins.str] = None,
                 target_resource_fqdn: Optional[_builtins.str] = None,
                 target_resource_id: Optional[_builtins.str] = None,
                 target_resource_operating_system_user_name: Optional[_builtins.str] = None,
                 target_resource_port: Optional[_builtins.int] = None,
                 target_resource_private_ip_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str session_type: The session type.
        :param _builtins.str target_resource_display_name: The display name of the target Compute instance that the session connects to.
        :param _builtins.str target_resource_fqdn: The Fully Qualified Domain Name of the target resource that the session connects to.
        :param _builtins.str target_resource_id: The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.
        :param _builtins.str target_resource_operating_system_user_name: The name of the user on the target resource operating system that the session uses for the connection.
        :param _builtins.int target_resource_port: The port number to connect to on the target resource.
        :param _builtins.str target_resource_private_ip_address: The private IP address of the target resource that the session connects to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "session_type", session_type)
        if target_resource_display_name is not None:
            pulumi.set(__self__, "target_resource_display_name", target_resource_display_name)
        if target_resource_fqdn is not None:
            pulumi.set(__self__, "target_resource_fqdn", target_resource_fqdn)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if target_resource_operating_system_user_name is not None:
            pulumi.set(__self__, "target_resource_operating_system_user_name", target_resource_operating_system_user_name)
        if target_resource_port is not None:
            pulumi.set(__self__, "target_resource_port", target_resource_port)
        if target_resource_private_ip_address is not None:
            pulumi.set(__self__, "target_resource_private_ip_address", target_resource_private_ip_address)

    @_builtins.property
    @pulumi.getter(name="sessionType")
    def session_type(self) -> _builtins.str:
        """
        The session type.
        """
        return pulumi.get(self, "session_type")

    @_builtins.property
    @pulumi.getter(name="targetResourceDisplayName")
    def target_resource_display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the target Compute instance that the session connects to.
        """
        return pulumi.get(self, "target_resource_display_name")

    @_builtins.property
    @pulumi.getter(name="targetResourceFqdn")
    def target_resource_fqdn(self) -> Optional[_builtins.str]:
        """
        The Fully Qualified Domain Name of the target resource that the session connects to.
        """
        return pulumi.get(self, "target_resource_fqdn")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[_builtins.str]:
        """
        The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter(name="targetResourceOperatingSystemUserName")
    def target_resource_operating_system_user_name(self) -> Optional[_builtins.str]:
        """
        The name of the user on the target resource operating system that the session uses for the connection.
        """
        return pulumi.get(self, "target_resource_operating_system_user_name")

    @_builtins.property
    @pulumi.getter(name="targetResourcePort")
    def target_resource_port(self) -> Optional[_builtins.int]:
        """
        The port number to connect to on the target resource.
        """
        return pulumi.get(self, "target_resource_port")

    @_builtins.property
    @pulumi.getter(name="targetResourcePrivateIpAddress")
    def target_resource_private_ip_address(self) -> Optional[_builtins.str]:
        """
        The private IP address of the target resource that the session connects to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_resource_private_ip_address")


@pulumi.output_type
class GetBastionsBastionResult(dict):
    def __init__(__self__, *,
                 bastion_type: _builtins.str,
                 client_cidr_block_allow_lists: Sequence[_builtins.str],
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 dns_proxy_status: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 max_session_ttl_in_seconds: _builtins.int,
                 max_sessions_allowed: _builtins.int,
                 name: _builtins.str,
                 phone_book_entry: _builtins.str,
                 private_endpoint_ip_address: _builtins.str,
                 state: _builtins.str,
                 static_jump_host_ip_addresses: Sequence[_builtins.str],
                 system_tags: Mapping[str, _builtins.str],
                 target_subnet_id: _builtins.str,
                 target_vcn_id: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str bastion_type: The type of bastion.
        :param Sequence[_builtins.str] client_cidr_block_allow_lists: A list of address ranges in CIDR notation that you want to allow to connect to sessions hosted by this bastion.
        :param _builtins.str compartment_id: The unique identifier (OCID) of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str dns_proxy_status: Flag to enable FQDN and SOCKS5 Proxy Support. Example: `ENABLED`, `DISABLED`
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The unique identifier (OCID) of the bastion, which can't be changed after creation.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail.
        :param _builtins.int max_session_ttl_in_seconds: The maximum amount of time that any session on the bastion can remain active.
        :param _builtins.int max_sessions_allowed: The maximum number of active sessions allowed on the bastion.
        :param _builtins.str name: A filter to return only resources that match the entire name given.
        :param _builtins.str phone_book_entry: The phonebook entry of the customer's team, which can't be changed after creation. Not applicable to `standard` bastions.
        :param _builtins.str private_endpoint_ip_address: The private IP address of the created private endpoint.
        :param _builtins.str state: The current state of the bastion.
        :param Sequence[_builtins.str] static_jump_host_ip_addresses: A list of IP addresses of the hosts that the bastion has access to. Not applicable to `standard` bastions.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str target_subnet_id: The unique identifier (OCID) of the subnet that the bastion connects to.
        :param _builtins.str target_vcn_id: The unique identifier (OCID) of the virtual cloud network (VCN) that the bastion connects to.
        :param _builtins.str time_created: The time the bastion was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        :param _builtins.str time_updated: The time the bastion was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "bastion_type", bastion_type)
        pulumi.set(__self__, "client_cidr_block_allow_lists", client_cidr_block_allow_lists)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "dns_proxy_status", dns_proxy_status)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_session_ttl_in_seconds", max_session_ttl_in_seconds)
        pulumi.set(__self__, "max_sessions_allowed", max_sessions_allowed)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_book_entry", phone_book_entry)
        pulumi.set(__self__, "private_endpoint_ip_address", private_endpoint_ip_address)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "static_jump_host_ip_addresses", static_jump_host_ip_addresses)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "target_subnet_id", target_subnet_id)
        pulumi.set(__self__, "target_vcn_id", target_vcn_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="bastionType")
    def bastion_type(self) -> _builtins.str:
        """
        The type of bastion.
        """
        return pulumi.get(self, "bastion_type")

    @_builtins.property
    @pulumi.getter(name="clientCidrBlockAllowLists")
    def client_cidr_block_allow_lists(self) -> Sequence[_builtins.str]:
        """
        A list of address ranges in CIDR notation that you want to allow to connect to sessions hosted by this bastion.
        """
        return pulumi.get(self, "client_cidr_block_allow_lists")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="dnsProxyStatus")
    def dns_proxy_status(self) -> _builtins.str:
        """
        Flag to enable FQDN and SOCKS5 Proxy Support. Example: `ENABLED`, `DISABLED`
        """
        return pulumi.get(self, "dns_proxy_status")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the bastion, which can't be changed after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maxSessionTtlInSeconds")
    def max_session_ttl_in_seconds(self) -> _builtins.int:
        """
        The maximum amount of time that any session on the bastion can remain active.
        """
        return pulumi.get(self, "max_session_ttl_in_seconds")

    @_builtins.property
    @pulumi.getter(name="maxSessionsAllowed")
    def max_sessions_allowed(self) -> _builtins.int:
        """
        The maximum number of active sessions allowed on the bastion.
        """
        return pulumi.get(self, "max_sessions_allowed")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="phoneBookEntry")
    def phone_book_entry(self) -> _builtins.str:
        """
        The phonebook entry of the customer's team, which can't be changed after creation. Not applicable to `standard` bastions.
        """
        return pulumi.get(self, "phone_book_entry")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> _builtins.str:
        """
        The private IP address of the created private endpoint.
        """
        return pulumi.get(self, "private_endpoint_ip_address")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the bastion.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="staticJumpHostIpAddresses")
    def static_jump_host_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        A list of IP addresses of the hosts that the bastion has access to. Not applicable to `standard` bastions.
        """
        return pulumi.get(self, "static_jump_host_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetSubnetId")
    def target_subnet_id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the subnet that the bastion connects to.
        """
        return pulumi.get(self, "target_subnet_id")

    @_builtins.property
    @pulumi.getter(name="targetVcnId")
    def target_vcn_id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the virtual cloud network (VCN) that the bastion connects to.
        """
        return pulumi.get(self, "target_vcn_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the bastion was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the bastion was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetBastionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A filter to return only resources that match the entire name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSessionKeyDetailResult(dict):
    def __init__(__self__, *,
                 public_key_content: _builtins.str):
        """
        :param _builtins.str public_key_content: The public key in OpenSSH format of the SSH key pair for the session. When you connect to the session, you must provide the private key of the same SSH key pair.
        """
        pulumi.set(__self__, "public_key_content", public_key_content)

    @_builtins.property
    @pulumi.getter(name="publicKeyContent")
    def public_key_content(self) -> _builtins.str:
        """
        The public key in OpenSSH format of the SSH key pair for the session. When you connect to the session, you must provide the private key of the same SSH key pair.
        """
        return pulumi.get(self, "public_key_content")


@pulumi.output_type
class GetSessionTargetResourceDetailResult(dict):
    def __init__(__self__, *,
                 session_type: _builtins.str,
                 target_resource_display_name: _builtins.str,
                 target_resource_fqdn: _builtins.str,
                 target_resource_id: _builtins.str,
                 target_resource_operating_system_user_name: _builtins.str,
                 target_resource_port: _builtins.int,
                 target_resource_private_ip_address: _builtins.str):
        """
        :param _builtins.str session_type: The Bastion service recognizes three types of sessions, managed SSH sessions, SSH port forwarding sessions, and Dynamic SSH port forwarding sessions. Managed SSH sessions require that the target resource has an OpenSSH server and the Oracle Cloud Agent both running.
        :param _builtins.str target_resource_display_name: The display name of the target Compute instance that the session connects to.
        :param _builtins.str target_resource_fqdn: The Fully Qualified Domain Name of the target resource that the session connects to.
        :param _builtins.str target_resource_id: The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.
        :param _builtins.str target_resource_operating_system_user_name: The name of the user on the target resource operating system that the session uses for the connection.
        :param _builtins.int target_resource_port: The port number to connect to on the target resource.
        :param _builtins.str target_resource_private_ip_address: The private IP address of the target resource that the session connects to.
        """
        pulumi.set(__self__, "session_type", session_type)
        pulumi.set(__self__, "target_resource_display_name", target_resource_display_name)
        pulumi.set(__self__, "target_resource_fqdn", target_resource_fqdn)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        pulumi.set(__self__, "target_resource_operating_system_user_name", target_resource_operating_system_user_name)
        pulumi.set(__self__, "target_resource_port", target_resource_port)
        pulumi.set(__self__, "target_resource_private_ip_address", target_resource_private_ip_address)

    @_builtins.property
    @pulumi.getter(name="sessionType")
    def session_type(self) -> _builtins.str:
        """
        The Bastion service recognizes three types of sessions, managed SSH sessions, SSH port forwarding sessions, and Dynamic SSH port forwarding sessions. Managed SSH sessions require that the target resource has an OpenSSH server and the Oracle Cloud Agent both running.
        """
        return pulumi.get(self, "session_type")

    @_builtins.property
    @pulumi.getter(name="targetResourceDisplayName")
    def target_resource_display_name(self) -> _builtins.str:
        """
        The display name of the target Compute instance that the session connects to.
        """
        return pulumi.get(self, "target_resource_display_name")

    @_builtins.property
    @pulumi.getter(name="targetResourceFqdn")
    def target_resource_fqdn(self) -> _builtins.str:
        """
        The Fully Qualified Domain Name of the target resource that the session connects to.
        """
        return pulumi.get(self, "target_resource_fqdn")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter(name="targetResourceOperatingSystemUserName")
    def target_resource_operating_system_user_name(self) -> _builtins.str:
        """
        The name of the user on the target resource operating system that the session uses for the connection.
        """
        return pulumi.get(self, "target_resource_operating_system_user_name")

    @_builtins.property
    @pulumi.getter(name="targetResourcePort")
    def target_resource_port(self) -> _builtins.int:
        """
        The port number to connect to on the target resource.
        """
        return pulumi.get(self, "target_resource_port")

    @_builtins.property
    @pulumi.getter(name="targetResourcePrivateIpAddress")
    def target_resource_private_ip_address(self) -> _builtins.str:
        """
        The private IP address of the target resource that the session connects to.
        """
        return pulumi.get(self, "target_resource_private_ip_address")


@pulumi.output_type
class GetSessionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSessionsSessionResult(dict):
    def __init__(__self__, *,
                 bastion_id: _builtins.str,
                 bastion_name: _builtins.str,
                 bastion_public_host_key_info: _builtins.str,
                 bastion_user_name: _builtins.str,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 key_details: Sequence['outputs.GetSessionsSessionKeyDetailResult'],
                 key_type: _builtins.str,
                 lifecycle_details: _builtins.str,
                 session_ttl_in_seconds: _builtins.int,
                 ssh_metadata: Mapping[str, _builtins.str],
                 state: _builtins.str,
                 target_resource_details: Sequence['outputs.GetSessionsSessionTargetResourceDetailResult'],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str bastion_id: The unique identifier (OCID) of the bastion in which to list sessions.
        :param _builtins.str bastion_name: The name of the bastion that is hosting this session.
        :param _builtins.str bastion_public_host_key_info: The public key of the bastion host. You can use this to verify that you're connecting to the correct bastion.
        :param _builtins.str bastion_user_name: The username that the session uses to connect to the target resource.
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param _builtins.str id: The unique identifier (OCID) of the session, which can't be changed after creation.
        :param Sequence['GetSessionsSessionKeyDetailArgs'] key_details: Public key details for a bastion session.
        :param _builtins.str key_type: The type of the key used to connect to the session. PUB is a standard public key in OpenSSH format.
        :param _builtins.str lifecycle_details: A message describing the current session state in more detail.
        :param _builtins.int session_ttl_in_seconds: The amount of time the session can remain active.
        :param Mapping[str, _builtins.str] ssh_metadata: The connection message for the session.
        :param _builtins.str state: The current state of the session.
        :param Sequence['GetSessionsSessionTargetResourceDetailArgs'] target_resource_details: Details about a bastion session's target resource.
        :param _builtins.str time_created: The time the session was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        :param _builtins.str time_updated: The time the session was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "bastion_id", bastion_id)
        pulumi.set(__self__, "bastion_name", bastion_name)
        pulumi.set(__self__, "bastion_public_host_key_info", bastion_public_host_key_info)
        pulumi.set(__self__, "bastion_user_name", bastion_user_name)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_details", key_details)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "session_ttl_in_seconds", session_ttl_in_seconds)
        pulumi.set(__self__, "ssh_metadata", ssh_metadata)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "target_resource_details", target_resource_details)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="bastionId")
    def bastion_id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the bastion in which to list sessions.
        """
        return pulumi.get(self, "bastion_id")

    @_builtins.property
    @pulumi.getter(name="bastionName")
    def bastion_name(self) -> _builtins.str:
        """
        The name of the bastion that is hosting this session.
        """
        return pulumi.get(self, "bastion_name")

    @_builtins.property
    @pulumi.getter(name="bastionPublicHostKeyInfo")
    def bastion_public_host_key_info(self) -> _builtins.str:
        """
        The public key of the bastion host. You can use this to verify that you're connecting to the correct bastion.
        """
        return pulumi.get(self, "bastion_public_host_key_info")

    @_builtins.property
    @pulumi.getter(name="bastionUserName")
    def bastion_user_name(self) -> _builtins.str:
        """
        The username that the session uses to connect to the target resource.
        """
        return pulumi.get(self, "bastion_user_name")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the session, which can't be changed after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Sequence['outputs.GetSessionsSessionKeyDetailResult']:
        """
        Public key details for a bastion session.
        """
        return pulumi.get(self, "key_details")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        """
        The type of the key used to connect to the session. PUB is a standard public key in OpenSSH format.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current session state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="sessionTtlInSeconds")
    def session_ttl_in_seconds(self) -> _builtins.int:
        """
        The amount of time the session can remain active.
        """
        return pulumi.get(self, "session_ttl_in_seconds")

    @_builtins.property
    @pulumi.getter(name="sshMetadata")
    def ssh_metadata(self) -> Mapping[str, _builtins.str]:
        """
        The connection message for the session.
        """
        return pulumi.get(self, "ssh_metadata")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the session.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="targetResourceDetails")
    def target_resource_details(self) -> Sequence['outputs.GetSessionsSessionTargetResourceDetailResult']:
        """
        Details about a bastion session's target resource.
        """
        return pulumi.get(self, "target_resource_details")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the session was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the session was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetSessionsSessionKeyDetailResult(dict):
    def __init__(__self__, *,
                 public_key_content: _builtins.str):
        """
        :param _builtins.str public_key_content: The public key in OpenSSH format of the SSH key pair for the session. When you connect to the session, you must provide the private key of the same SSH key pair.
        """
        pulumi.set(__self__, "public_key_content", public_key_content)

    @_builtins.property
    @pulumi.getter(name="publicKeyContent")
    def public_key_content(self) -> _builtins.str:
        """
        The public key in OpenSSH format of the SSH key pair for the session. When you connect to the session, you must provide the private key of the same SSH key pair.
        """
        return pulumi.get(self, "public_key_content")


@pulumi.output_type
class GetSessionsSessionTargetResourceDetailResult(dict):
    def __init__(__self__, *,
                 session_type: _builtins.str,
                 target_resource_display_name: _builtins.str,
                 target_resource_fqdn: _builtins.str,
                 target_resource_id: _builtins.str,
                 target_resource_operating_system_user_name: _builtins.str,
                 target_resource_port: _builtins.int,
                 target_resource_private_ip_address: _builtins.str):
        """
        :param _builtins.str session_type: The Bastion service recognizes three types of sessions, managed SSH sessions, SSH port forwarding sessions, and Dynamic SSH port forwarding sessions. Managed SSH sessions require that the target resource has an OpenSSH server and the Oracle Cloud Agent both running.
        :param _builtins.str target_resource_display_name: The display name of the target Compute instance that the session connects to.
        :param _builtins.str target_resource_fqdn: The Fully Qualified Domain Name of the target resource that the session connects to.
        :param _builtins.str target_resource_id: The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.
        :param _builtins.str target_resource_operating_system_user_name: The name of the user on the target resource operating system that the session uses for the connection.
        :param _builtins.int target_resource_port: The port number to connect to on the target resource.
        :param _builtins.str target_resource_private_ip_address: The private IP address of the target resource that the session connects to.
        """
        pulumi.set(__self__, "session_type", session_type)
        pulumi.set(__self__, "target_resource_display_name", target_resource_display_name)
        pulumi.set(__self__, "target_resource_fqdn", target_resource_fqdn)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        pulumi.set(__self__, "target_resource_operating_system_user_name", target_resource_operating_system_user_name)
        pulumi.set(__self__, "target_resource_port", target_resource_port)
        pulumi.set(__self__, "target_resource_private_ip_address", target_resource_private_ip_address)

    @_builtins.property
    @pulumi.getter(name="sessionType")
    def session_type(self) -> _builtins.str:
        """
        The Bastion service recognizes three types of sessions, managed SSH sessions, SSH port forwarding sessions, and Dynamic SSH port forwarding sessions. Managed SSH sessions require that the target resource has an OpenSSH server and the Oracle Cloud Agent both running.
        """
        return pulumi.get(self, "session_type")

    @_builtins.property
    @pulumi.getter(name="targetResourceDisplayName")
    def target_resource_display_name(self) -> _builtins.str:
        """
        The display name of the target Compute instance that the session connects to.
        """
        return pulumi.get(self, "target_resource_display_name")

    @_builtins.property
    @pulumi.getter(name="targetResourceFqdn")
    def target_resource_fqdn(self) -> _builtins.str:
        """
        The Fully Qualified Domain Name of the target resource that the session connects to.
        """
        return pulumi.get(self, "target_resource_fqdn")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter(name="targetResourceOperatingSystemUserName")
    def target_resource_operating_system_user_name(self) -> _builtins.str:
        """
        The name of the user on the target resource operating system that the session uses for the connection.
        """
        return pulumi.get(self, "target_resource_operating_system_user_name")

    @_builtins.property
    @pulumi.getter(name="targetResourcePort")
    def target_resource_port(self) -> _builtins.int:
        """
        The port number to connect to on the target resource.
        """
        return pulumi.get(self, "target_resource_port")

    @_builtins.property
    @pulumi.getter(name="targetResourcePrivateIpAddress")
    def target_resource_private_ip_address(self) -> _builtins.str:
        """
        The private IP address of the target resource that the session connects to.
        """
        return pulumi.get(self, "target_resource_private_ip_address")


