# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBdsInstanceApiKeysResult',
    'AwaitableGetBdsInstanceApiKeysResult',
    'get_bds_instance_api_keys',
    'get_bds_instance_api_keys_output',
]

@pulumi.output_type
class GetBdsInstanceApiKeysResult:
    """
    A collection of values returned by getBdsInstanceApiKeys.
    """
    def __init__(__self__, bds_api_keys=None, bds_instance_id=None, display_name=None, filters=None, id=None, state=None, user_id=None):
        if bds_api_keys and not isinstance(bds_api_keys, list):
            raise TypeError("Expected argument 'bds_api_keys' to be a list")
        pulumi.set(__self__, "bds_api_keys", bds_api_keys)
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="bdsApiKeys")
    def bds_api_keys(self) -> Sequence['outputs.GetBdsInstanceApiKeysBdsApiKeyResult']:
        """
        The list of bds_api_keys.
        """
        return pulumi.get(self, "bds_api_keys")

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "bds_instance_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBdsInstanceApiKeysFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current status of the API key.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[_builtins.str]:
        """
        The user OCID for which this API key was created.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetBdsInstanceApiKeysResult(GetBdsInstanceApiKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceApiKeysResult(
            bds_api_keys=self.bds_api_keys,
            bds_instance_id=self.bds_instance_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            user_id=self.user_id)


def get_bds_instance_api_keys(bds_instance_id: Optional[_builtins.str] = None,
                              display_name: Optional[_builtins.str] = None,
                              filters: Optional[Sequence[Union['GetBdsInstanceApiKeysFilterArgs', 'GetBdsInstanceApiKeysFilterArgsDict']]] = None,
                              state: Optional[_builtins.str] = None,
                              user_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceApiKeysResult:
    """
    This data source provides details about a specific Bds Instance Api Key resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns the user's API key information for the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_api_key = oci.BigDataService.get_bds_instance_api_key(api_key_id=test_api_key["id"],
        bds_instance_id=test_bds_instance["id"])
    ```


    :param _builtins.str bds_instance_id: The OCID of the cluster.
    :param _builtins.str state: The current status of the API key.
    :param _builtins.str user_id: The user OCID for which this API key was created.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceApiKeys:getBdsInstanceApiKeys', __args__, opts=opts, typ=GetBdsInstanceApiKeysResult).value

    return AwaitableGetBdsInstanceApiKeysResult(
        bds_api_keys=pulumi.get(__ret__, 'bds_api_keys'),
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_bds_instance_api_keys_output(bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBdsInstanceApiKeysFilterArgs', 'GetBdsInstanceApiKeysFilterArgsDict']]]]] = None,
                                     state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     user_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceApiKeysResult]:
    """
    This data source provides details about a specific Bds Instance Api Key resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns the user's API key information for the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_api_key = oci.BigDataService.get_bds_instance_api_key(api_key_id=test_api_key["id"],
        bds_instance_id=test_bds_instance["id"])
    ```


    :param _builtins.str bds_instance_id: The OCID of the cluster.
    :param _builtins.str state: The current status of the API key.
    :param _builtins.str user_id: The user OCID for which this API key was created.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceApiKeys:getBdsInstanceApiKeys', __args__, opts=opts, typ=GetBdsInstanceApiKeysResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceApiKeysResult(
        bds_api_keys=pulumi.get(__response__, 'bds_api_keys'),
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        user_id=pulumi.get(__response__, 'user_id')))
