# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBdsInstanceNodeBackupConfigurationResult',
    'AwaitableGetBdsInstanceNodeBackupConfigurationResult',
    'get_bds_instance_node_backup_configuration',
    'get_bds_instance_node_backup_configuration_output',
]

@pulumi.output_type
class GetBdsInstanceNodeBackupConfigurationResult:
    """
    A collection of values returned by getBdsInstanceNodeBackupConfiguration.
    """
    def __init__(__self__, backup_type=None, bds_instance_id=None, display_name=None, id=None, level_type_details=None, node_backup_configuration_id=None, number_of_backups_to_retain=None, schedule=None, state=None, time_created=None, time_updated=None, timezone=None):
        if backup_type and not isinstance(backup_type, str):
            raise TypeError("Expected argument 'backup_type' to be a str")
        pulumi.set(__self__, "backup_type", backup_type)
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if level_type_details and not isinstance(level_type_details, list):
            raise TypeError("Expected argument 'level_type_details' to be a list")
        pulumi.set(__self__, "level_type_details", level_type_details)
        if node_backup_configuration_id and not isinstance(node_backup_configuration_id, str):
            raise TypeError("Expected argument 'node_backup_configuration_id' to be a str")
        pulumi.set(__self__, "node_backup_configuration_id", node_backup_configuration_id)
        if number_of_backups_to_retain and not isinstance(number_of_backups_to_retain, int):
            raise TypeError("Expected argument 'number_of_backups_to_retain' to be a int")
        pulumi.set(__self__, "number_of_backups_to_retain", number_of_backups_to_retain)
        if schedule and not isinstance(schedule, str):
            raise TypeError("Expected argument 'schedule' to be a str")
        pulumi.set(__self__, "schedule", schedule)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if timezone and not isinstance(timezone, str):
            raise TypeError("Expected argument 'timezone' to be a str")
        pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> _builtins.str:
        """
        The OCID of the bdsInstance which is the parent resource id.
        """
        return pulumi.get(self, "bds_instance_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier for the NodeBackupConfiguration.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> Sequence['outputs.GetBdsInstanceNodeBackupConfigurationLevelTypeDetailResult']:
        """
        Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        """
        return pulumi.get(self, "level_type_details")

    @_builtins.property
    @pulumi.getter(name="nodeBackupConfigurationId")
    def node_backup_configuration_id(self) -> _builtins.str:
        return pulumi.get(self, "node_backup_configuration_id")

    @_builtins.property
    @pulumi.getter(name="numberOfBackupsToRetain")
    def number_of_backups_to_retain(self) -> _builtins.int:
        """
        Number of backup copies to retain.
        """
        return pulumi.get(self, "number_of_backups_to_retain")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        Day/time recurrence (specified following RFC 5545) at which to trigger the backup process. Currently only DAILY, WEEKLY and MONTHLY frequency is supported. Days of the week are specified using BYDAY field. Time of the day is specified using BYHOUR. Other fields are not supported.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of the NodeBackupConfiguration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the NodeBackupConfiguration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the NodeBackupConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> _builtins.str:
        """
        The time zone of the execution schedule, in IANA time zone database name format
        """
        return pulumi.get(self, "timezone")


class AwaitableGetBdsInstanceNodeBackupConfigurationResult(GetBdsInstanceNodeBackupConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceNodeBackupConfigurationResult(
            backup_type=self.backup_type,
            bds_instance_id=self.bds_instance_id,
            display_name=self.display_name,
            id=self.id,
            level_type_details=self.level_type_details,
            node_backup_configuration_id=self.node_backup_configuration_id,
            number_of_backups_to_retain=self.number_of_backups_to_retain,
            schedule=self.schedule,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            timezone=self.timezone)


def get_bds_instance_node_backup_configuration(bds_instance_id: Optional[_builtins.str] = None,
                                               node_backup_configuration_id: Optional[_builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceNodeBackupConfigurationResult:
    """
    This data source provides details about a specific Bds Instance Node Backup Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns details of the NodeBackupConfiguration identified by the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_node_backup_configuration = oci.BigDataService.get_bds_instance_node_backup_configuration(bds_instance_id=test_bds_instance["id"],
        node_backup_configuration_id=test_configuration["id"])
    ```


    :param _builtins.str bds_instance_id: The OCID of the cluster.
    :param _builtins.str node_backup_configuration_id: Unique Oracle-assigned identifier of the NodeBackupConfiguration.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['nodeBackupConfigurationId'] = node_backup_configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceNodeBackupConfiguration:getBdsInstanceNodeBackupConfiguration', __args__, opts=opts, typ=GetBdsInstanceNodeBackupConfigurationResult).value

    return AwaitableGetBdsInstanceNodeBackupConfigurationResult(
        backup_type=pulumi.get(__ret__, 'backup_type'),
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        level_type_details=pulumi.get(__ret__, 'level_type_details'),
        node_backup_configuration_id=pulumi.get(__ret__, 'node_backup_configuration_id'),
        number_of_backups_to_retain=pulumi.get(__ret__, 'number_of_backups_to_retain'),
        schedule=pulumi.get(__ret__, 'schedule'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        timezone=pulumi.get(__ret__, 'timezone'))
def get_bds_instance_node_backup_configuration_output(bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                      node_backup_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceNodeBackupConfigurationResult]:
    """
    This data source provides details about a specific Bds Instance Node Backup Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns details of the NodeBackupConfiguration identified by the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_node_backup_configuration = oci.BigDataService.get_bds_instance_node_backup_configuration(bds_instance_id=test_bds_instance["id"],
        node_backup_configuration_id=test_configuration["id"])
    ```


    :param _builtins.str bds_instance_id: The OCID of the cluster.
    :param _builtins.str node_backup_configuration_id: Unique Oracle-assigned identifier of the NodeBackupConfiguration.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['nodeBackupConfigurationId'] = node_backup_configuration_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceNodeBackupConfiguration:getBdsInstanceNodeBackupConfiguration', __args__, opts=opts, typ=GetBdsInstanceNodeBackupConfigurationResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceNodeBackupConfigurationResult(
        backup_type=pulumi.get(__response__, 'backup_type'),
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        level_type_details=pulumi.get(__response__, 'level_type_details'),
        node_backup_configuration_id=pulumi.get(__response__, 'node_backup_configuration_id'),
        number_of_backups_to_retain=pulumi.get(__response__, 'number_of_backups_to_retain'),
        schedule=pulumi.get(__response__, 'schedule'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        timezone=pulumi.get(__response__, 'timezone')))
