# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBdsInstanceNodeReplaceConfigurationResult',
    'AwaitableGetBdsInstanceNodeReplaceConfigurationResult',
    'get_bds_instance_node_replace_configuration',
    'get_bds_instance_node_replace_configuration_output',
]

@pulumi.output_type
class GetBdsInstanceNodeReplaceConfigurationResult:
    """
    A collection of values returned by getBdsInstanceNodeReplaceConfiguration.
    """
    def __init__(__self__, bds_instance_id=None, cluster_admin_password=None, display_name=None, duration_in_minutes=None, id=None, level_type_details=None, metric_type=None, node_replace_configuration_id=None, state=None, time_created=None, time_updated=None):
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password and not isinstance(cluster_admin_password, str):
            raise TypeError("Expected argument 'cluster_admin_password' to be a str")
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if duration_in_minutes and not isinstance(duration_in_minutes, int):
            raise TypeError("Expected argument 'duration_in_minutes' to be a int")
        pulumi.set(__self__, "duration_in_minutes", duration_in_minutes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if level_type_details and not isinstance(level_type_details, list):
            raise TypeError("Expected argument 'level_type_details' to be a list")
        pulumi.set(__self__, "level_type_details", level_type_details)
        if metric_type and not isinstance(metric_type, str):
            raise TypeError("Expected argument 'metric_type' to be a str")
        pulumi.set(__self__, "metric_type", metric_type)
        if node_replace_configuration_id and not isinstance(node_replace_configuration_id, str):
            raise TypeError("Expected argument 'node_replace_configuration_id' to be a str")
        pulumi.set(__self__, "node_replace_configuration_id", node_replace_configuration_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> _builtins.str:
        """
        The OCID of the bdsInstance which is the parent resource id.
        """
        return pulumi.get(self, "bds_instance_id")

    @_builtins.property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> _builtins.str:
        return pulumi.get(self, "cluster_admin_password")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="durationInMinutes")
    def duration_in_minutes(self) -> _builtins.int:
        """
        This value is the minimum period of time to wait for metric emission before triggering node replacement. The value is in minutes.
        """
        return pulumi.get(self, "duration_in_minutes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier for the NodeReplaceConfiguration.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> Sequence['outputs.GetBdsInstanceNodeReplaceConfigurationLevelTypeDetailResult']:
        """
        Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
        """
        return pulumi.get(self, "level_type_details")

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> _builtins.str:
        """
        Type of compute instance health metric to use for node replacement
        """
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter(name="nodeReplaceConfigurationId")
    def node_replace_configuration_id(self) -> _builtins.str:
        return pulumi.get(self, "node_replace_configuration_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of the NodeReplaceConfiguration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the NodeReplaceConfiguration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the NodeReplaceConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetBdsInstanceNodeReplaceConfigurationResult(GetBdsInstanceNodeReplaceConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceNodeReplaceConfigurationResult(
            bds_instance_id=self.bds_instance_id,
            cluster_admin_password=self.cluster_admin_password,
            display_name=self.display_name,
            duration_in_minutes=self.duration_in_minutes,
            id=self.id,
            level_type_details=self.level_type_details,
            metric_type=self.metric_type,
            node_replace_configuration_id=self.node_replace_configuration_id,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_bds_instance_node_replace_configuration(bds_instance_id: Optional[_builtins.str] = None,
                                                node_replace_configuration_id: Optional[_builtins.str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceNodeReplaceConfigurationResult:
    """
    This data source provides details about a specific Bds Instance Node Replace Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns details of the nodeReplaceConfiguration identified by the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_node_replace_configuration = oci.BigDataService.get_bds_instance_node_replace_configuration(bds_instance_id=test_bds_instance["id"],
        node_replace_configuration_id=test_configuration["id"])
    ```


    :param _builtins.str bds_instance_id: The OCID of the cluster.
    :param _builtins.str node_replace_configuration_id: Unique Oracle-assigned identifier of the  NodeReplaceConfiguration.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['nodeReplaceConfigurationId'] = node_replace_configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceNodeReplaceConfiguration:getBdsInstanceNodeReplaceConfiguration', __args__, opts=opts, typ=GetBdsInstanceNodeReplaceConfigurationResult).value

    return AwaitableGetBdsInstanceNodeReplaceConfigurationResult(
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        cluster_admin_password=pulumi.get(__ret__, 'cluster_admin_password'),
        display_name=pulumi.get(__ret__, 'display_name'),
        duration_in_minutes=pulumi.get(__ret__, 'duration_in_minutes'),
        id=pulumi.get(__ret__, 'id'),
        level_type_details=pulumi.get(__ret__, 'level_type_details'),
        metric_type=pulumi.get(__ret__, 'metric_type'),
        node_replace_configuration_id=pulumi.get(__ret__, 'node_replace_configuration_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_bds_instance_node_replace_configuration_output(bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                       node_replace_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceNodeReplaceConfigurationResult]:
    """
    This data source provides details about a specific Bds Instance Node Replace Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns details of the nodeReplaceConfiguration identified by the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_node_replace_configuration = oci.BigDataService.get_bds_instance_node_replace_configuration(bds_instance_id=test_bds_instance["id"],
        node_replace_configuration_id=test_configuration["id"])
    ```


    :param _builtins.str bds_instance_id: The OCID of the cluster.
    :param _builtins.str node_replace_configuration_id: Unique Oracle-assigned identifier of the  NodeReplaceConfiguration.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['nodeReplaceConfigurationId'] = node_replace_configuration_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceNodeReplaceConfiguration:getBdsInstanceNodeReplaceConfiguration', __args__, opts=opts, typ=GetBdsInstanceNodeReplaceConfigurationResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceNodeReplaceConfigurationResult(
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        cluster_admin_password=pulumi.get(__response__, 'cluster_admin_password'),
        display_name=pulumi.get(__response__, 'display_name'),
        duration_in_minutes=pulumi.get(__response__, 'duration_in_minutes'),
        id=pulumi.get(__response__, 'id'),
        level_type_details=pulumi.get(__response__, 'level_type_details'),
        metric_type=pulumi.get(__response__, 'metric_type'),
        node_replace_configuration_id=pulumi.get(__response__, 'node_replace_configuration_id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
