# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInternalOccmDemandSignalCatalogsResult',
    'AwaitableGetInternalOccmDemandSignalCatalogsResult',
    'get_internal_occm_demand_signal_catalogs',
    'get_internal_occm_demand_signal_catalogs_output',
]

@pulumi.output_type
class GetInternalOccmDemandSignalCatalogsResult:
    """
    A collection of values returned by getInternalOccmDemandSignalCatalogs.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, occ_customer_group_id=None, occm_demand_signal_catalog_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if occ_customer_group_id and not isinstance(occ_customer_group_id, str):
            raise TypeError("Expected argument 'occ_customer_group_id' to be a str")
        pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if occm_demand_signal_catalog_collections and not isinstance(occm_demand_signal_catalog_collections, list):
            raise TypeError("Expected argument 'occm_demand_signal_catalog_collections' to be a list")
        pulumi.set(__self__, "occm_demand_signal_catalog_collections", occm_demand_signal_catalog_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        compartment id from where demand signal catalog is created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        displayName of demand signal catalog.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInternalOccmDemandSignalCatalogsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> _builtins.str:
        """
        The customer group OCID to which the availability catalog belongs.
        """
        return pulumi.get(self, "occ_customer_group_id")

    @_builtins.property
    @pulumi.getter(name="occmDemandSignalCatalogCollections")
    def occm_demand_signal_catalog_collections(self) -> Sequence['outputs.GetInternalOccmDemandSignalCatalogsOccmDemandSignalCatalogCollectionResult']:
        """
        The list of occm_demand_signal_catalog_collection.
        """
        return pulumi.get(self, "occm_demand_signal_catalog_collections")


class AwaitableGetInternalOccmDemandSignalCatalogsResult(GetInternalOccmDemandSignalCatalogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInternalOccmDemandSignalCatalogsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            occ_customer_group_id=self.occ_customer_group_id,
            occm_demand_signal_catalog_collections=self.occm_demand_signal_catalog_collections)


def get_internal_occm_demand_signal_catalogs(compartment_id: Optional[_builtins.str] = None,
                                             display_name: Optional[_builtins.str] = None,
                                             filters: Optional[Sequence[Union['GetInternalOccmDemandSignalCatalogsFilterArgs', 'GetInternalOccmDemandSignalCatalogsFilterArgsDict']]] = None,
                                             occ_customer_group_id: Optional[_builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInternalOccmDemandSignalCatalogsResult:
    """
    This data source provides the list of Internal Occm Demand Signal Catalogs in Oracle Cloud Infrastructure Capacity Management service.

    This API will list demand signal catalogs for a given customer group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_internal_occm_demand_signal_catalogs = oci.CapacityManagement.get_internal_occm_demand_signal_catalogs(compartment_id=compartment_id,
        occ_customer_group_id=test_occ_customer_group["id"],
        display_name=internal_occm_demand_signal_catalog_display_name)
    ```


    :param _builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param _builtins.str display_name: A filter to return only the resources that match the entire display name. The match is not case sensitive.
    :param _builtins.str occ_customer_group_id: The customer group ocid by which we would filter the list.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['occCustomerGroupId'] = occ_customer_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getInternalOccmDemandSignalCatalogs:getInternalOccmDemandSignalCatalogs', __args__, opts=opts, typ=GetInternalOccmDemandSignalCatalogsResult).value

    return AwaitableGetInternalOccmDemandSignalCatalogsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        occ_customer_group_id=pulumi.get(__ret__, 'occ_customer_group_id'),
        occm_demand_signal_catalog_collections=pulumi.get(__ret__, 'occm_demand_signal_catalog_collections'))
def get_internal_occm_demand_signal_catalogs_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                    display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInternalOccmDemandSignalCatalogsFilterArgs', 'GetInternalOccmDemandSignalCatalogsFilterArgsDict']]]]] = None,
                                                    occ_customer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInternalOccmDemandSignalCatalogsResult]:
    """
    This data source provides the list of Internal Occm Demand Signal Catalogs in Oracle Cloud Infrastructure Capacity Management service.

    This API will list demand signal catalogs for a given customer group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_internal_occm_demand_signal_catalogs = oci.CapacityManagement.get_internal_occm_demand_signal_catalogs(compartment_id=compartment_id,
        occ_customer_group_id=test_occ_customer_group["id"],
        display_name=internal_occm_demand_signal_catalog_display_name)
    ```


    :param _builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param _builtins.str display_name: A filter to return only the resources that match the entire display name. The match is not case sensitive.
    :param _builtins.str occ_customer_group_id: The customer group ocid by which we would filter the list.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['occCustomerGroupId'] = occ_customer_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getInternalOccmDemandSignalCatalogs:getInternalOccmDemandSignalCatalogs', __args__, opts=opts, typ=GetInternalOccmDemandSignalCatalogsResult)
    return __ret__.apply(lambda __response__: GetInternalOccmDemandSignalCatalogsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        occ_customer_group_id=pulumi.get(__response__, 'occ_customer_group_id'),
        occm_demand_signal_catalog_collections=pulumi.get(__response__, 'occm_demand_signal_catalog_collections')))
