# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOccAvailabilityCatalogResult',
    'AwaitableGetOccAvailabilityCatalogResult',
    'get_occ_availability_catalog',
    'get_occ_availability_catalog_output',
]

@pulumi.output_type
class GetOccAvailabilityCatalogResult:
    """
    A collection of values returned by getOccAvailabilityCatalog.
    """
    def __init__(__self__, base64encoded_catalog_details=None, catalog_state=None, compartment_id=None, defined_tags=None, description=None, details=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, metadata_details=None, namespace=None, occ_availability_catalog_id=None, occ_customer_group_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if base64encoded_catalog_details and not isinstance(base64encoded_catalog_details, str):
            raise TypeError("Expected argument 'base64encoded_catalog_details' to be a str")
        pulumi.set(__self__, "base64encoded_catalog_details", base64encoded_catalog_details)
        if catalog_state and not isinstance(catalog_state, str):
            raise TypeError("Expected argument 'catalog_state' to be a str")
        pulumi.set(__self__, "catalog_state", catalog_state)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if details and not isinstance(details, list):
            raise TypeError("Expected argument 'details' to be a list")
        pulumi.set(__self__, "details", details)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if metadata_details and not isinstance(metadata_details, list):
            raise TypeError("Expected argument 'metadata_details' to be a list")
        pulumi.set(__self__, "metadata_details", metadata_details)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if occ_availability_catalog_id and not isinstance(occ_availability_catalog_id, str):
            raise TypeError("Expected argument 'occ_availability_catalog_id' to be a str")
        pulumi.set(__self__, "occ_availability_catalog_id", occ_availability_catalog_id)
        if occ_customer_group_id and not isinstance(occ_customer_group_id, str):
            raise TypeError("Expected argument 'occ_customer_group_id' to be a str")
        pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="base64encodedCatalogDetails")
    def base64encoded_catalog_details(self) -> _builtins.str:
        return pulumi.get(self, "base64encoded_catalog_details")

    @_builtins.property
    @pulumi.getter(name="catalogState")
    def catalog_state(self) -> _builtins.str:
        """
        The different states associated with the availability catalog.
        """
        return pulumi.get(self, "catalog_state")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the tenancy where the availability catalog resides.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Text information about the availability catalog.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Sequence['outputs.GetOccAvailabilityCatalogDetailResult']:
        """
        Details about capacity available for different resources in catalog.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name for the availability catalog.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the availability catalog.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="metadataDetails")
    def metadata_details(self) -> Sequence['outputs.GetOccAvailabilityCatalogMetadataDetailResult']:
        """
        Used for representing the metadata of the catalog. This denotes the version and format of the CSV file for parsing.
        """
        return pulumi.get(self, "metadata_details")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="occAvailabilityCatalogId")
    def occ_availability_catalog_id(self) -> _builtins.str:
        return pulumi.get(self, "occ_availability_catalog_id")

    @_builtins.property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> _builtins.str:
        """
        The customer group OCID to which the availability catalog belongs.
        """
        return pulumi.get(self, "occ_customer_group_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the availability catalog was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the availability catalog was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOccAvailabilityCatalogResult(GetOccAvailabilityCatalogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccAvailabilityCatalogResult(
            base64encoded_catalog_details=self.base64encoded_catalog_details,
            catalog_state=self.catalog_state,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            details=self.details,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            metadata_details=self.metadata_details,
            namespace=self.namespace,
            occ_availability_catalog_id=self.occ_availability_catalog_id,
            occ_customer_group_id=self.occ_customer_group_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_occ_availability_catalog(occ_availability_catalog_id: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccAvailabilityCatalogResult:
    """
    This data source provides details about a specific Occ Availability Catalog resource in Oracle Cloud Infrastructure Capacity Management service.

    Get details about availability catalog.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_availability_catalog = oci.CapacityManagement.get_occ_availability_catalog(occ_availability_catalog_id=test_occ_availability_catalog_oci_capacity_management_occ_availability_catalog["id"])
    ```


    :param _builtins.str occ_availability_catalog_id: The OCID of the availability catalog.
    """
    __args__ = dict()
    __args__['occAvailabilityCatalogId'] = occ_availability_catalog_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getOccAvailabilityCatalog:getOccAvailabilityCatalog', __args__, opts=opts, typ=GetOccAvailabilityCatalogResult).value

    return AwaitableGetOccAvailabilityCatalogResult(
        base64encoded_catalog_details=pulumi.get(__ret__, 'base64encoded_catalog_details'),
        catalog_state=pulumi.get(__ret__, 'catalog_state'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        details=pulumi.get(__ret__, 'details'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        metadata_details=pulumi.get(__ret__, 'metadata_details'),
        namespace=pulumi.get(__ret__, 'namespace'),
        occ_availability_catalog_id=pulumi.get(__ret__, 'occ_availability_catalog_id'),
        occ_customer_group_id=pulumi.get(__ret__, 'occ_customer_group_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_occ_availability_catalog_output(occ_availability_catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOccAvailabilityCatalogResult]:
    """
    This data source provides details about a specific Occ Availability Catalog resource in Oracle Cloud Infrastructure Capacity Management service.

    Get details about availability catalog.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_availability_catalog = oci.CapacityManagement.get_occ_availability_catalog(occ_availability_catalog_id=test_occ_availability_catalog_oci_capacity_management_occ_availability_catalog["id"])
    ```


    :param _builtins.str occ_availability_catalog_id: The OCID of the availability catalog.
    """
    __args__ = dict()
    __args__['occAvailabilityCatalogId'] = occ_availability_catalog_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getOccAvailabilityCatalog:getOccAvailabilityCatalog', __args__, opts=opts, typ=GetOccAvailabilityCatalogResult)
    return __ret__.apply(lambda __response__: GetOccAvailabilityCatalogResult(
        base64encoded_catalog_details=pulumi.get(__response__, 'base64encoded_catalog_details'),
        catalog_state=pulumi.get(__response__, 'catalog_state'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        details=pulumi.get(__response__, 'details'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        metadata_details=pulumi.get(__response__, 'metadata_details'),
        namespace=pulumi.get(__response__, 'namespace'),
        occ_availability_catalog_id=pulumi.get(__response__, 'occ_availability_catalog_id'),
        occ_customer_group_id=pulumi.get(__response__, 'occ_customer_group_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
