# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAgentPluginResult',
    'AwaitableGetAgentPluginResult',
    'get_agent_plugin',
    'get_agent_plugin_output',
]

@pulumi.output_type
class GetAgentPluginResult:
    """
    A collection of values returned by getAgentPlugin.
    """
    def __init__(__self__, agent_id=None, defined_tags=None, desired_state=None, freeform_tags=None, id=None, lifecycle_details=None, name=None, plugin_name=None, plugin_version=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if desired_state and not isinstance(desired_state, str):
            raise TypeError("Expected argument 'desired_state' to be a str")
        pulumi.set(__self__, "desired_state", desired_state)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if plugin_name and not isinstance(plugin_name, str):
            raise TypeError("Expected argument 'plugin_name' to be a str")
        pulumi.set(__self__, "plugin_name", plugin_name)
        if plugin_version and not isinstance(plugin_version, str):
            raise TypeError("Expected argument 'plugin_version' to be a str")
        pulumi.set(__self__, "plugin_version", plugin_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> _builtins.str:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> _builtins.str:
        """
        State to which the customer wants the plugin to move to.
        """
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Plugin identifier, which can be renamed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> _builtins.str:
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> _builtins.str:
        """
        Plugin version.
        """
        return pulumi.get(self, "plugin_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the plugin.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the Agent was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAgentPluginResult(GetAgentPluginResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAgentPluginResult(
            agent_id=self.agent_id,
            defined_tags=self.defined_tags,
            desired_state=self.desired_state,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            plugin_name=self.plugin_name,
            plugin_version=self.plugin_version,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_agent_plugin(agent_id: Optional[_builtins.str] = None,
                     plugin_name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAgentPluginResult:
    """
    This data source provides details about a specific Agent Plugin resource in Oracle Cloud Infrastructure Cloud Bridge service.

    Gets a plugin by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_agent_plugin = oci.CloudBridge.get_agent_plugin(agent_id=test_agent["id"],
        plugin_name=agent_plugin_plugin_name)
    ```


    :param _builtins.str agent_id: Unique Agent identifier path parameter.
    :param _builtins.str plugin_name: Unique plugin identifier path parameter.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['pluginName'] = plugin_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudBridge/getAgentPlugin:getAgentPlugin', __args__, opts=opts, typ=GetAgentPluginResult).value

    return AwaitableGetAgentPluginResult(
        agent_id=pulumi.get(__ret__, 'agent_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        desired_state=pulumi.get(__ret__, 'desired_state'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        plugin_name=pulumi.get(__ret__, 'plugin_name'),
        plugin_version=pulumi.get(__ret__, 'plugin_version'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_agent_plugin_output(agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                            plugin_name: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAgentPluginResult]:
    """
    This data source provides details about a specific Agent Plugin resource in Oracle Cloud Infrastructure Cloud Bridge service.

    Gets a plugin by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_agent_plugin = oci.CloudBridge.get_agent_plugin(agent_id=test_agent["id"],
        plugin_name=agent_plugin_plugin_name)
    ```


    :param _builtins.str agent_id: Unique Agent identifier path parameter.
    :param _builtins.str plugin_name: Unique plugin identifier path parameter.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['pluginName'] = plugin_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudBridge/getAgentPlugin:getAgentPlugin', __args__, opts=opts, typ=GetAgentPluginResult)
    return __ret__.apply(lambda __response__: GetAgentPluginResult(
        agent_id=pulumi.get(__response__, 'agent_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        desired_state=pulumi.get(__response__, 'desired_state'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        plugin_name=pulumi.get(__response__, 'plugin_name'),
        plugin_version=pulumi.get(__response__, 'plugin_version'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
