# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WlpAgentArgs', 'WlpAgent']

@pulumi.input_type
class WlpAgentArgs:
    def __init__(__self__, *,
                 agent_version: pulumi.Input[_builtins.str],
                 certificate_signed_request: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 os_info: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a WlpAgent resource.
        :param pulumi.Input[_builtins.str] agent_version: The version of the agent making the request
        :param pulumi.Input[_builtins.str] certificate_signed_request: (Updatable) The certificate signed request containing domain, organization names, organization units, city, state, country, email and public key, among other certificate details, signed by private key
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID of the host
        :param pulumi.Input[_builtins.str] os_info: Concatenated OS name, OS version and agent architecture; for example, ubuntu_22.0_amd64.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        """
        pulumi.set(__self__, "agent_version", agent_version)
        pulumi.set(__self__, "certificate_signed_request", certificate_signed_request)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "os_info", os_info)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of the agent making the request
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_version", value)

    @_builtins.property
    @pulumi.getter(name="certificateSignedRequest")
    def certificate_signed_request(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The certificate signed request containing domain, organization names, organization units, city, state, country, email and public key, among other certificate details, signed by private key
        """
        return pulumi.get(self, "certificate_signed_request")

    @certificate_signed_request.setter
    def certificate_signed_request(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_signed_request", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Compartment OCID of the host
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="osInfo")
    def os_info(self) -> pulumi.Input[_builtins.str]:
        """
        Concatenated OS name, OS version and agent architecture; for example, ubuntu_22.0_amd64.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_info")

    @os_info.setter
    def os_info(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "os_info", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _WlpAgentState:
    def __init__(__self__, *,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_signed_request: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 os_info: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WlpAgent resources.
        :param pulumi.Input[_builtins.str] agent_version: The version of the agent making the request
        :param pulumi.Input[_builtins.str] certificate_id: The certificate ID returned by Oracle Cloud Infrastructure certificates service
        :param pulumi.Input[_builtins.str] certificate_signed_request: (Updatable) The certificate signed request containing domain, organization names, organization units, city, state, country, email and public key, among other certificate details, signed by private key
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID of the host
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] host_id: OCID for instance in which WlpAgent is installed
        :param pulumi.Input[_builtins.str] os_info: Concatenated OS name, OS version and agent architecture; for example, ubuntu_22.0_amd64.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] tenant_id: TenantId of the host
        :param pulumi.Input[_builtins.str] time_created: The date and time the WlpAgent was created. Format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the WlpAgent was updated. Format defined by RFC3339.
        """
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_signed_request is not None:
            pulumi.set(__self__, "certificate_signed_request", certificate_signed_request)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if os_info is not None:
            pulumi.set(__self__, "os_info", os_info)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the agent making the request
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_version", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate ID returned by Oracle Cloud Infrastructure certificates service
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateSignedRequest")
    def certificate_signed_request(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The certificate signed request containing domain, organization names, organization units, city, state, country, email and public key, among other certificate details, signed by private key
        """
        return pulumi.get(self, "certificate_signed_request")

    @certificate_signed_request.setter
    def certificate_signed_request(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_signed_request", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compartment OCID of the host
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID for instance in which WlpAgent is installed
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_id", value)

    @_builtins.property
    @pulumi.getter(name="osInfo")
    def os_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Concatenated OS name, OS version and agent architecture; for example, ubuntu_22.0_amd64.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_info")

    @os_info.setter
    def os_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_info", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TenantId of the host
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the WlpAgent was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the WlpAgent was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:CloudGuard/wlpAgent:WlpAgent")
class WlpAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_signed_request: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 os_info: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Wlp Agent resource in Oracle Cloud Infrastructure Cloud Guard service.

        Creates and registers a WLP agent for an
        on-premise resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_wlp_agent = oci.cloudguard.WlpAgent("test_wlp_agent",
            agent_version=wlp_agent_agent_version,
            certificate_signed_request=wlp_agent_certificate_signed_request,
            compartment_id=compartment_id,
            os_info=wlp_agent_os_info,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        WlpAgents can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/wlpAgent:WlpAgent test_wlp_agent "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_version: The version of the agent making the request
        :param pulumi.Input[_builtins.str] certificate_signed_request: (Updatable) The certificate signed request containing domain, organization names, organization units, city, state, country, email and public key, among other certificate details, signed by private key
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID of the host
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] os_info: Concatenated OS name, OS version and agent architecture; for example, ubuntu_22.0_amd64.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WlpAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Wlp Agent resource in Oracle Cloud Infrastructure Cloud Guard service.

        Creates and registers a WLP agent for an
        on-premise resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_wlp_agent = oci.cloudguard.WlpAgent("test_wlp_agent",
            agent_version=wlp_agent_agent_version,
            certificate_signed_request=wlp_agent_certificate_signed_request,
            compartment_id=compartment_id,
            os_info=wlp_agent_os_info,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        WlpAgents can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/wlpAgent:WlpAgent test_wlp_agent "id"
        ```

        :param str resource_name: The name of the resource.
        :param WlpAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WlpAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_signed_request: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 os_info: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WlpAgentArgs.__new__(WlpAgentArgs)

            if agent_version is None and not opts.urn:
                raise TypeError("Missing required property 'agent_version'")
            __props__.__dict__["agent_version"] = agent_version
            if certificate_signed_request is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_signed_request'")
            __props__.__dict__["certificate_signed_request"] = certificate_signed_request
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            if os_info is None and not opts.urn:
                raise TypeError("Missing required property 'os_info'")
            __props__.__dict__["os_info"] = os_info
            __props__.__dict__["certificate_id"] = None
            __props__.__dict__["host_id"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(WlpAgent, __self__).__init__(
            'oci:CloudGuard/wlpAgent:WlpAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_version: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_signed_request: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            host_id: Optional[pulumi.Input[_builtins.str]] = None,
            os_info: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'WlpAgent':
        """
        Get an existing WlpAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_version: The version of the agent making the request
        :param pulumi.Input[_builtins.str] certificate_id: The certificate ID returned by Oracle Cloud Infrastructure certificates service
        :param pulumi.Input[_builtins.str] certificate_signed_request: (Updatable) The certificate signed request containing domain, organization names, organization units, city, state, country, email and public key, among other certificate details, signed by private key
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID of the host
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] host_id: OCID for instance in which WlpAgent is installed
        :param pulumi.Input[_builtins.str] os_info: Concatenated OS name, OS version and agent architecture; for example, ubuntu_22.0_amd64.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] tenant_id: TenantId of the host
        :param pulumi.Input[_builtins.str] time_created: The date and time the WlpAgent was created. Format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the WlpAgent was updated. Format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WlpAgentState.__new__(_WlpAgentState)

        __props__.__dict__["agent_version"] = agent_version
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["certificate_signed_request"] = certificate_signed_request
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host_id"] = host_id
        __props__.__dict__["os_info"] = os_info
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return WlpAgent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the agent making the request
        """
        return pulumi.get(self, "agent_version")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate ID returned by Oracle Cloud Infrastructure certificates service
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="certificateSignedRequest")
    def certificate_signed_request(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The certificate signed request containing domain, organization names, organization units, city, state, country, email and public key, among other certificate details, signed by private key
        """
        return pulumi.get(self, "certificate_signed_request")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Compartment OCID of the host
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID for instance in which WlpAgent is installed
        """
        return pulumi.get(self, "host_id")

    @_builtins.property
    @pulumi.getter(name="osInfo")
    def os_info(self) -> pulumi.Output[_builtins.str]:
        """
        Concatenated OS name, OS version and agent architecture; for example, ubuntu_22.0_amd64.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_info")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        TenantId of the host
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the WlpAgent was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the WlpAgent was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

