# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetClusterWorkloadMappingsResult',
    'AwaitableGetClusterWorkloadMappingsResult',
    'get_cluster_workload_mappings',
    'get_cluster_workload_mappings_output',
]

@pulumi.output_type
class GetClusterWorkloadMappingsResult:
    """
    A collection of values returned by getClusterWorkloadMappings.
    """
    def __init__(__self__, cluster_id=None, filters=None, id=None, workload_mappings=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if workload_mappings and not isinstance(workload_mappings, list):
            raise TypeError("Expected argument 'workload_mappings' to be a list")
        pulumi.set(__self__, "workload_mappings", workload_mappings)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetClusterWorkloadMappingsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="workloadMappings")
    def workload_mappings(self) -> Sequence['outputs.GetClusterWorkloadMappingsWorkloadMappingResult']:
        """
        The list of workload_mappings.
        """
        return pulumi.get(self, "workload_mappings")


class AwaitableGetClusterWorkloadMappingsResult(GetClusterWorkloadMappingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterWorkloadMappingsResult(
            cluster_id=self.cluster_id,
            filters=self.filters,
            id=self.id,
            workload_mappings=self.workload_mappings)


def get_cluster_workload_mappings(cluster_id: Optional[_builtins.str] = None,
                                  filters: Optional[Sequence[Union['GetClusterWorkloadMappingsFilterArgs', 'GetClusterWorkloadMappingsFilterArgsDict']]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterWorkloadMappingsResult:
    """
    This data source provides the list of Cluster Workload Mappings in Oracle Cloud Infrastructure Container Engine service.

    List workloadMappings for a provisioned cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_workload_mappings = oci.ContainerEngine.get_cluster_workload_mappings(cluster_id=test_cluster["id"])
    ```


    :param _builtins.str cluster_id: The OCID of the cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getClusterWorkloadMappings:getClusterWorkloadMappings', __args__, opts=opts, typ=GetClusterWorkloadMappingsResult).value

    return AwaitableGetClusterWorkloadMappingsResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        workload_mappings=pulumi.get(__ret__, 'workload_mappings'))
def get_cluster_workload_mappings_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetClusterWorkloadMappingsFilterArgs', 'GetClusterWorkloadMappingsFilterArgsDict']]]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterWorkloadMappingsResult]:
    """
    This data source provides the list of Cluster Workload Mappings in Oracle Cloud Infrastructure Container Engine service.

    List workloadMappings for a provisioned cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_workload_mappings = oci.ContainerEngine.get_cluster_workload_mappings(cluster_id=test_cluster["id"])
    ```


    :param _builtins.str cluster_id: The OCID of the cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ContainerEngine/getClusterWorkloadMappings:getClusterWorkloadMappings', __args__, opts=opts, typ=GetClusterWorkloadMappingsResult)
    return __ret__.apply(lambda __response__: GetClusterWorkloadMappingsResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        workload_mappings=pulumi.get(__response__, 'workload_mappings')))
