# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeCapacityReportArgs', 'ComputeCapacityReport']

@pulumi.input_type
class ComputeCapacityReportArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 shape_availabilities: pulumi.Input[Sequence[pulumi.Input['ComputeCapacityReportShapeAvailabilityArgs']]]):
        """
        The set of arguments for constructing a ComputeCapacityReport resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain for the capacity report.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeCapacityReportShapeAvailabilityArgs']]] shape_availabilities: Information about the shapes in the capacity report.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "shape_availabilities", shape_availabilities)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[_builtins.str]:
        """
        The availability domain for the capacity report.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="shapeAvailabilities")
    def shape_availabilities(self) -> pulumi.Input[Sequence[pulumi.Input['ComputeCapacityReportShapeAvailabilityArgs']]]:
        """
        Information about the shapes in the capacity report.
        """
        return pulumi.get(self, "shape_availabilities")

    @shape_availabilities.setter
    def shape_availabilities(self, value: pulumi.Input[Sequence[pulumi.Input['ComputeCapacityReportShapeAvailabilityArgs']]]):
        pulumi.set(self, "shape_availabilities", value)


@pulumi.input_type
class _ComputeCapacityReportState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shape_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeCapacityReportShapeAvailabilityArgs']]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeCapacityReport resources.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain for the capacity report.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeCapacityReportShapeAvailabilityArgs']]] shape_availabilities: Information about the shapes in the capacity report.
        :param pulumi.Input[_builtins.str] time_created: The date and time the capacity report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if shape_availabilities is not None:
            pulumi.set(__self__, "shape_availabilities", shape_availabilities)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability domain for the capacity report.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="shapeAvailabilities")
    def shape_availabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeCapacityReportShapeAvailabilityArgs']]]]:
        """
        Information about the shapes in the capacity report.
        """
        return pulumi.get(self, "shape_availabilities")

    @shape_availabilities.setter
    def shape_availabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeCapacityReportShapeAvailabilityArgs']]]]):
        pulumi.set(self, "shape_availabilities", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the capacity report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:Core/computeCapacityReport:ComputeCapacityReport")
class ComputeCapacityReport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shape_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeCapacityReportShapeAvailabilityArgs', 'ComputeCapacityReportShapeAvailabilityArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Compute Capacity Report resource in Oracle Cloud Infrastructure Core service.

        Generates a report of the host capacity within an availability domain that is available for you
        to create compute instances. Host capacity is the physical infrastructure that resources such as compute
        instances run on.

        Use the capacity report to determine whether sufficient capacity is available for a shape before
        you create an instance or change the shape of an instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_compute_capacity_report = oci.core.ComputeCapacityReport("test_compute_capacity_report",
            availability_domain=compute_capacity_report_availability_domain,
            compartment_id=compartment_id,
            shape_availabilities=[{
                "instance_shape": compute_capacity_report_shape_availabilities_instance_shape,
                "fault_domain": compute_capacity_report_shape_availabilities_fault_domain,
                "instance_shape_config": {
                    "memory_in_gbs": compute_capacity_report_shape_availabilities_instance_shape_config_memory_in_gbs,
                    "nvmes": compute_capacity_report_shape_availabilities_instance_shape_config_nvmes,
                    "ocpus": compute_capacity_report_shape_availabilities_instance_shape_config_ocpus,
                },
            }])
        ```

        ## Import

        ComputeCapacityReports can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/computeCapacityReport:ComputeCapacityReport test_compute_capacity_report "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain for the capacity report.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeCapacityReportShapeAvailabilityArgs', 'ComputeCapacityReportShapeAvailabilityArgsDict']]]] shape_availabilities: Information about the shapes in the capacity report.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeCapacityReportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Compute Capacity Report resource in Oracle Cloud Infrastructure Core service.

        Generates a report of the host capacity within an availability domain that is available for you
        to create compute instances. Host capacity is the physical infrastructure that resources such as compute
        instances run on.

        Use the capacity report to determine whether sufficient capacity is available for a shape before
        you create an instance or change the shape of an instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_compute_capacity_report = oci.core.ComputeCapacityReport("test_compute_capacity_report",
            availability_domain=compute_capacity_report_availability_domain,
            compartment_id=compartment_id,
            shape_availabilities=[{
                "instance_shape": compute_capacity_report_shape_availabilities_instance_shape,
                "fault_domain": compute_capacity_report_shape_availabilities_fault_domain,
                "instance_shape_config": {
                    "memory_in_gbs": compute_capacity_report_shape_availabilities_instance_shape_config_memory_in_gbs,
                    "nvmes": compute_capacity_report_shape_availabilities_instance_shape_config_nvmes,
                    "ocpus": compute_capacity_report_shape_availabilities_instance_shape_config_ocpus,
                },
            }])
        ```

        ## Import

        ComputeCapacityReports can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/computeCapacityReport:ComputeCapacityReport test_compute_capacity_report "id"
        ```

        :param str resource_name: The name of the resource.
        :param ComputeCapacityReportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeCapacityReportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shape_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeCapacityReportShapeAvailabilityArgs', 'ComputeCapacityReportShapeAvailabilityArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeCapacityReportArgs.__new__(ComputeCapacityReportArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if shape_availabilities is None and not opts.urn:
                raise TypeError("Missing required property 'shape_availabilities'")
            __props__.__dict__["shape_availabilities"] = shape_availabilities
            __props__.__dict__["time_created"] = None
        super(ComputeCapacityReport, __self__).__init__(
            'oci:Core/computeCapacityReport:ComputeCapacityReport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            shape_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeCapacityReportShapeAvailabilityArgs', 'ComputeCapacityReportShapeAvailabilityArgsDict']]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComputeCapacityReport':
        """
        Get an existing ComputeCapacityReport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain for the capacity report.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeCapacityReportShapeAvailabilityArgs', 'ComputeCapacityReportShapeAvailabilityArgsDict']]]] shape_availabilities: Information about the shapes in the capacity report.
        :param pulumi.Input[_builtins.str] time_created: The date and time the capacity report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeCapacityReportState.__new__(_ComputeCapacityReportState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["shape_availabilities"] = shape_availabilities
        __props__.__dict__["time_created"] = time_created
        return ComputeCapacityReport(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The availability domain for the capacity report.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="shapeAvailabilities")
    def shape_availabilities(self) -> pulumi.Output[Sequence['outputs.ComputeCapacityReportShapeAvailability']]:
        """
        Information about the shapes in the capacity report.
        """
        return pulumi.get(self, "shape_availabilities")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the capacity report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

