# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetComputeGlobalImageCapabilitySchemasResult',
    'AwaitableGetComputeGlobalImageCapabilitySchemasResult',
    'get_compute_global_image_capability_schemas',
    'get_compute_global_image_capability_schemas_output',
]

@pulumi.output_type
class GetComputeGlobalImageCapabilitySchemasResult:
    """
    A collection of values returned by getComputeGlobalImageCapabilitySchemas.
    """
    def __init__(__self__, compartment_id=None, compute_global_image_capability_schemas=None, display_name=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_global_image_capability_schemas and not isinstance(compute_global_image_capability_schemas, list):
            raise TypeError("Expected argument 'compute_global_image_capability_schemas' to be a list")
        pulumi.set(__self__, "compute_global_image_capability_schemas", compute_global_image_capability_schemas)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the compartment containing the compute global image capability schema
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeGlobalImageCapabilitySchemas")
    def compute_global_image_capability_schemas(self) -> Sequence['outputs.GetComputeGlobalImageCapabilitySchemasComputeGlobalImageCapabilitySchemaResult']:
        """
        The list of compute_global_image_capability_schemas.
        """
        return pulumi.get(self, "compute_global_image_capability_schemas")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetComputeGlobalImageCapabilitySchemasFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetComputeGlobalImageCapabilitySchemasResult(GetComputeGlobalImageCapabilitySchemasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeGlobalImageCapabilitySchemasResult(
            compartment_id=self.compartment_id,
            compute_global_image_capability_schemas=self.compute_global_image_capability_schemas,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id)


def get_compute_global_image_capability_schemas(compartment_id: Optional[_builtins.str] = None,
                                                display_name: Optional[_builtins.str] = None,
                                                filters: Optional[Sequence[Union['GetComputeGlobalImageCapabilitySchemasFilterArgs', 'GetComputeGlobalImageCapabilitySchemasFilterArgsDict']]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeGlobalImageCapabilitySchemasResult:
    """
    This data source provides the list of Compute Global Image Capability Schemas in Oracle Cloud Infrastructure Core service.

    Lists Compute Global Image Capability Schema in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_global_image_capability_schemas = oci.Core.get_compute_global_image_capability_schemas(compartment_id=compartment_id,
        display_name=compute_global_image_capability_schema_display_name)
    ```


    :param _builtins.str compartment_id: A filter to return only resources that match the given compartment OCID exactly.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeGlobalImageCapabilitySchemas:getComputeGlobalImageCapabilitySchemas', __args__, opts=opts, typ=GetComputeGlobalImageCapabilitySchemasResult).value

    return AwaitableGetComputeGlobalImageCapabilitySchemasResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_global_image_capability_schemas=pulumi.get(__ret__, 'compute_global_image_capability_schemas'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_compute_global_image_capability_schemas_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                       display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetComputeGlobalImageCapabilitySchemasFilterArgs', 'GetComputeGlobalImageCapabilitySchemasFilterArgsDict']]]]] = None,
                                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeGlobalImageCapabilitySchemasResult]:
    """
    This data source provides the list of Compute Global Image Capability Schemas in Oracle Cloud Infrastructure Core service.

    Lists Compute Global Image Capability Schema in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_global_image_capability_schemas = oci.Core.get_compute_global_image_capability_schemas(compartment_id=compartment_id,
        display_name=compute_global_image_capability_schema_display_name)
    ```


    :param _builtins.str compartment_id: A filter to return only resources that match the given compartment OCID exactly.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getComputeGlobalImageCapabilitySchemas:getComputeGlobalImageCapabilitySchemas', __args__, opts=opts, typ=GetComputeGlobalImageCapabilitySchemasResult)
    return __ret__.apply(lambda __response__: GetComputeGlobalImageCapabilitySchemasResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_global_image_capability_schemas=pulumi.get(__response__, 'compute_global_image_capability_schemas'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
