# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetComputeGpuMemoryFabricsResult',
    'AwaitableGetComputeGpuMemoryFabricsResult',
    'get_compute_gpu_memory_fabrics',
    'get_compute_gpu_memory_fabrics_output',
]

@pulumi.output_type
class GetComputeGpuMemoryFabricsResult:
    """
    A collection of values returned by getComputeGpuMemoryFabrics.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, compute_gpu_memory_fabric_collections=None, compute_gpu_memory_fabric_health=None, compute_gpu_memory_fabric_id=None, compute_gpu_memory_fabric_lifecycle_state=None, compute_hpc_island_id=None, compute_network_block_id=None, display_name=None, filters=None, id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_gpu_memory_fabric_collections and not isinstance(compute_gpu_memory_fabric_collections, list):
            raise TypeError("Expected argument 'compute_gpu_memory_fabric_collections' to be a list")
        pulumi.set(__self__, "compute_gpu_memory_fabric_collections", compute_gpu_memory_fabric_collections)
        if compute_gpu_memory_fabric_health and not isinstance(compute_gpu_memory_fabric_health, str):
            raise TypeError("Expected argument 'compute_gpu_memory_fabric_health' to be a str")
        pulumi.set(__self__, "compute_gpu_memory_fabric_health", compute_gpu_memory_fabric_health)
        if compute_gpu_memory_fabric_id and not isinstance(compute_gpu_memory_fabric_id, str):
            raise TypeError("Expected argument 'compute_gpu_memory_fabric_id' to be a str")
        pulumi.set(__self__, "compute_gpu_memory_fabric_id", compute_gpu_memory_fabric_id)
        if compute_gpu_memory_fabric_lifecycle_state and not isinstance(compute_gpu_memory_fabric_lifecycle_state, str):
            raise TypeError("Expected argument 'compute_gpu_memory_fabric_lifecycle_state' to be a str")
        pulumi.set(__self__, "compute_gpu_memory_fabric_lifecycle_state", compute_gpu_memory_fabric_lifecycle_state)
        if compute_hpc_island_id and not isinstance(compute_hpc_island_id, str):
            raise TypeError("Expected argument 'compute_hpc_island_id' to be a str")
        pulumi.set(__self__, "compute_hpc_island_id", compute_hpc_island_id)
        if compute_network_block_id and not isinstance(compute_network_block_id, str):
            raise TypeError("Expected argument 'compute_network_block_id' to be a str")
        pulumi.set(__self__, "compute_network_block_id", compute_network_block_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeGpuMemoryFabricCollections")
    def compute_gpu_memory_fabric_collections(self) -> Sequence['outputs.GetComputeGpuMemoryFabricsComputeGpuMemoryFabricCollectionResult']:
        """
        The list of compute_gpu_memory_fabric_collection.
        """
        return pulumi.get(self, "compute_gpu_memory_fabric_collections")

    @_builtins.property
    @pulumi.getter(name="computeGpuMemoryFabricHealth")
    def compute_gpu_memory_fabric_health(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compute_gpu_memory_fabric_health")

    @_builtins.property
    @pulumi.getter(name="computeGpuMemoryFabricId")
    def compute_gpu_memory_fabric_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compute_gpu_memory_fabric_id")

    @_builtins.property
    @pulumi.getter(name="computeGpuMemoryFabricLifecycleState")
    def compute_gpu_memory_fabric_lifecycle_state(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compute_gpu_memory_fabric_lifecycle_state")

    @_builtins.property
    @pulumi.getter(name="computeHpcIslandId")
    def compute_hpc_island_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique HPC Island
        """
        return pulumi.get(self, "compute_hpc_island_id")

    @_builtins.property
    @pulumi.getter(name="computeNetworkBlockId")
    def compute_network_block_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Network Block
        """
        return pulumi.get(self, "compute_network_block_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetComputeGpuMemoryFabricsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetComputeGpuMemoryFabricsResult(GetComputeGpuMemoryFabricsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeGpuMemoryFabricsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            compute_gpu_memory_fabric_collections=self.compute_gpu_memory_fabric_collections,
            compute_gpu_memory_fabric_health=self.compute_gpu_memory_fabric_health,
            compute_gpu_memory_fabric_id=self.compute_gpu_memory_fabric_id,
            compute_gpu_memory_fabric_lifecycle_state=self.compute_gpu_memory_fabric_lifecycle_state,
            compute_hpc_island_id=self.compute_hpc_island_id,
            compute_network_block_id=self.compute_network_block_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id)


def get_compute_gpu_memory_fabrics(availability_domain: Optional[_builtins.str] = None,
                                   compartment_id: Optional[_builtins.str] = None,
                                   compute_gpu_memory_fabric_health: Optional[_builtins.str] = None,
                                   compute_gpu_memory_fabric_id: Optional[_builtins.str] = None,
                                   compute_gpu_memory_fabric_lifecycle_state: Optional[_builtins.str] = None,
                                   compute_hpc_island_id: Optional[_builtins.str] = None,
                                   compute_network_block_id: Optional[_builtins.str] = None,
                                   display_name: Optional[_builtins.str] = None,
                                   filters: Optional[Sequence[Union['GetComputeGpuMemoryFabricsFilterArgs', 'GetComputeGpuMemoryFabricsFilterArgsDict']]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeGpuMemoryFabricsResult:
    """
    This data source provides the list of Compute Gpu Memory Fabrics in Oracle Cloud Infrastructure Core service.

    Lists the compute GPU memory fabrics that match the specified criteria and compartmentId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_gpu_memory_fabrics = oci.Core.get_compute_gpu_memory_fabrics(compartment_id=compartment_id,
        availability_domain=compute_gpu_memory_fabric_availability_domain,
        compute_gpu_memory_fabric_health=compute_gpu_memory_fabric_compute_gpu_memory_fabric_health,
        compute_gpu_memory_fabric_id=test_compute_gpu_memory_fabric["id"],
        compute_gpu_memory_fabric_lifecycle_state=compute_gpu_memory_fabric_compute_gpu_memory_fabric_lifecycle_state,
        compute_hpc_island_id=test_compute_hpc_island["id"],
        compute_network_block_id=test_compute_network_block["id"],
        display_name=compute_gpu_memory_fabric_display_name)
    ```


    :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str compute_gpu_memory_fabric_health: A filter to return ComputeGpuMemoryFabricSummary resources that match the given fabric health.
    :param _builtins.str compute_gpu_memory_fabric_id: A filter to return only the listings that matches the given GPU memory fabric id.
    :param _builtins.str compute_gpu_memory_fabric_lifecycle_state: A filter to return ComputeGpuMemoryFabricSummary resources that match the given lifecycle state.
    :param _builtins.str compute_hpc_island_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute HPC island.
    :param _builtins.str compute_network_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute network block.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['computeGpuMemoryFabricHealth'] = compute_gpu_memory_fabric_health
    __args__['computeGpuMemoryFabricId'] = compute_gpu_memory_fabric_id
    __args__['computeGpuMemoryFabricLifecycleState'] = compute_gpu_memory_fabric_lifecycle_state
    __args__['computeHpcIslandId'] = compute_hpc_island_id
    __args__['computeNetworkBlockId'] = compute_network_block_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeGpuMemoryFabrics:getComputeGpuMemoryFabrics', __args__, opts=opts, typ=GetComputeGpuMemoryFabricsResult).value

    return AwaitableGetComputeGpuMemoryFabricsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_gpu_memory_fabric_collections=pulumi.get(__ret__, 'compute_gpu_memory_fabric_collections'),
        compute_gpu_memory_fabric_health=pulumi.get(__ret__, 'compute_gpu_memory_fabric_health'),
        compute_gpu_memory_fabric_id=pulumi.get(__ret__, 'compute_gpu_memory_fabric_id'),
        compute_gpu_memory_fabric_lifecycle_state=pulumi.get(__ret__, 'compute_gpu_memory_fabric_lifecycle_state'),
        compute_hpc_island_id=pulumi.get(__ret__, 'compute_hpc_island_id'),
        compute_network_block_id=pulumi.get(__ret__, 'compute_network_block_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_compute_gpu_memory_fabrics_output(availability_domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          compute_gpu_memory_fabric_health: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          compute_gpu_memory_fabric_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          compute_gpu_memory_fabric_lifecycle_state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          compute_hpc_island_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          compute_network_block_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetComputeGpuMemoryFabricsFilterArgs', 'GetComputeGpuMemoryFabricsFilterArgsDict']]]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeGpuMemoryFabricsResult]:
    """
    This data source provides the list of Compute Gpu Memory Fabrics in Oracle Cloud Infrastructure Core service.

    Lists the compute GPU memory fabrics that match the specified criteria and compartmentId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_gpu_memory_fabrics = oci.Core.get_compute_gpu_memory_fabrics(compartment_id=compartment_id,
        availability_domain=compute_gpu_memory_fabric_availability_domain,
        compute_gpu_memory_fabric_health=compute_gpu_memory_fabric_compute_gpu_memory_fabric_health,
        compute_gpu_memory_fabric_id=test_compute_gpu_memory_fabric["id"],
        compute_gpu_memory_fabric_lifecycle_state=compute_gpu_memory_fabric_compute_gpu_memory_fabric_lifecycle_state,
        compute_hpc_island_id=test_compute_hpc_island["id"],
        compute_network_block_id=test_compute_network_block["id"],
        display_name=compute_gpu_memory_fabric_display_name)
    ```


    :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str compute_gpu_memory_fabric_health: A filter to return ComputeGpuMemoryFabricSummary resources that match the given fabric health.
    :param _builtins.str compute_gpu_memory_fabric_id: A filter to return only the listings that matches the given GPU memory fabric id.
    :param _builtins.str compute_gpu_memory_fabric_lifecycle_state: A filter to return ComputeGpuMemoryFabricSummary resources that match the given lifecycle state.
    :param _builtins.str compute_hpc_island_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute HPC island.
    :param _builtins.str compute_network_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute network block.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['computeGpuMemoryFabricHealth'] = compute_gpu_memory_fabric_health
    __args__['computeGpuMemoryFabricId'] = compute_gpu_memory_fabric_id
    __args__['computeGpuMemoryFabricLifecycleState'] = compute_gpu_memory_fabric_lifecycle_state
    __args__['computeHpcIslandId'] = compute_hpc_island_id
    __args__['computeNetworkBlockId'] = compute_network_block_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getComputeGpuMemoryFabrics:getComputeGpuMemoryFabrics', __args__, opts=opts, typ=GetComputeGpuMemoryFabricsResult)
    return __ret__.apply(lambda __response__: GetComputeGpuMemoryFabricsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_gpu_memory_fabric_collections=pulumi.get(__response__, 'compute_gpu_memory_fabric_collections'),
        compute_gpu_memory_fabric_health=pulumi.get(__response__, 'compute_gpu_memory_fabric_health'),
        compute_gpu_memory_fabric_id=pulumi.get(__response__, 'compute_gpu_memory_fabric_id'),
        compute_gpu_memory_fabric_lifecycle_state=pulumi.get(__response__, 'compute_gpu_memory_fabric_lifecycle_state'),
        compute_hpc_island_id=pulumi.get(__response__, 'compute_hpc_island_id'),
        compute_network_block_id=pulumi.get(__response__, 'compute_network_block_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
