# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDrgsResult',
    'AwaitableGetDrgsResult',
    'get_drgs',
    'get_drgs_output',
]

@pulumi.output_type
class GetDrgsResult:
    """
    A collection of values returned by getDrgs.
    """
    def __init__(__self__, compartment_id=None, drgs=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if drgs and not isinstance(drgs, list):
            raise TypeError("Expected argument 'drgs' to be a list")
        pulumi.set(__self__, "drgs", drgs)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the DRG.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def drgs(self) -> Sequence['outputs.GetDrgsDrgResult']:
        """
        The list of drgs.
        """
        return pulumi.get(self, "drgs")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDrgsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDrgsResult(GetDrgsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrgsResult(
            compartment_id=self.compartment_id,
            drgs=self.drgs,
            filters=self.filters,
            id=self.id)


def get_drgs(compartment_id: Optional[_builtins.str] = None,
             filters: Optional[Sequence[Union['GetDrgsFilterArgs', 'GetDrgsFilterArgsDict']]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrgsResult:
    """
    This data source provides the list of Drgs in Oracle Cloud Infrastructure Core service.

    Lists the DRGs in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_drgs = oci.Core.get_drgs(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getDrgs:getDrgs', __args__, opts=opts, typ=GetDrgsResult).value

    return AwaitableGetDrgsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        drgs=pulumi.get(__ret__, 'drgs'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_drgs_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDrgsFilterArgs', 'GetDrgsFilterArgsDict']]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDrgsResult]:
    """
    This data source provides the list of Drgs in Oracle Cloud Infrastructure Core service.

    Lists the DRGs in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_drgs = oci.Core.get_drgs(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getDrgs:getDrgs', __args__, opts=opts, typ=GetDrgsResult)
    return __ret__.apply(lambda __response__: GetDrgsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        drgs=pulumi.get(__response__, 'drgs'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
