# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubnetArgs', 'Subnet']

@pulumi.input_type
class SubnetArgs:
    def __init__(__self__, *,
                 cidr_block: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 vcn_id: pulumi.Input[_builtins.str],
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_options_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_label: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ipv6cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 prohibit_internet_ingress: Optional[pulumi.Input[_builtins.bool]] = None,
                 prohibit_public_ip_on_vnic: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Subnet resource.
        :param pulumi.Input[_builtins.str] cidr_block: (Updatable) The CIDR IP address range of the subnet. The CIDR must maintain the following rules -
               
               a. The CIDR block is valid and correctly formatted. b. The new range is within one of the parent VCN ranges.
               
               Example: `10.0.1.0/24`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the subnet.
        :param pulumi.Input[_builtins.str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN to contain the subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] availability_domain: Controls whether the subnet is regional or specific to an availability domain. Oracle recommends creating regional subnets because they're more flexible and make it easier to implement failover across availability domains. Originally, AD-specific subnets were the only kind available to use.
               
               To create a regional subnet, omit this attribute. Then any resources later created in this subnet (such as a Compute instance) can be created in any availability domain in the region.
               
               To instead create an AD-specific subnet, set this attribute to the availability domain you want this subnet to be in. Then any resources later created in this subnet can only be created in that availability domain.
               
               Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] dhcp_options_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the set of DHCP options the subnet will use. If you don't provide a value, the subnet uses the VCN's default set of DHCP options.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] dns_label: A DNS label for the subnet, used in conjunction with the VNIC's hostname and VCN's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Must be an alphanumeric string that begins with a letter and is unique within the VCN. The value cannot be changed.
               
               This value must be set if you want to use the Internet and VCN Resolver to resolve the hostnames of instances in the subnet. It can only be set if the VCN itself was created with a DNS label.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `subnet123`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] ipv6cidr_block: (Updatable) Use this to enable IPv6 addressing for this subnet. The VCN must be enabled for IPv6. You can't change this subnet characteristic later. All subnets are /64 in size. The subnet portion of the IPv6 address is the fourth hextet from the left (1111 in the following example).
               
               For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).
               
               Example: `2001:0db8:0123:1111::/64`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6cidr_blocks: (Updatable) The list of all IPv6 prefixes (Oracle allocated IPv6 GUA, ULA or private IPv6 prefixes, BYOIPv6 prefixes) for the subnet that meets the following criteria:
               * The prefixes must be valid.
               * Multiple prefixes must not overlap each other or the on-premises network prefix.
               * The number of prefixes must not exceed the limit of IPv6 prefixes allowed to a subnet.
        :param pulumi.Input[_builtins.bool] prohibit_internet_ingress: Whether to disallow ingress internet traffic to VNICs within this subnet. Defaults to false.
               
               For IPv6, if `prohibitInternetIngress` is set to `true`, internet access is not allowed for any IPv6s assigned to VNICs in the subnet. Otherwise, ingress internet traffic is allowed by default.
               
               `prohibitPublicIpOnVnic` will be set to the value of `prohibitInternetIngress` to dictate IPv4 behavior in this subnet. Only one or the other flag should be specified.
               
               Example: `true`
        :param pulumi.Input[_builtins.bool] prohibit_public_ip_on_vnic: Whether VNICs within this subnet can have public IP addresses. Defaults to false, which means VNICs created in this subnet will automatically be assigned public IP addresses unless specified otherwise during instance launch or VNIC creation (with the `assignPublicIp` flag in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/)). If `prohibitPublicIpOnVnic` is set to true, VNICs created in this subnet cannot have public IP addresses (that is, it's a private subnet).
               
               If you intend to use an IPv6 prefix, you should use the flag `prohibitInternetIngress` to specify ingress internet traffic behavior of the subnet.
               
               Example: `true`
        :param pulumi.Input[_builtins.str] route_table_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route table the subnet will use. If you don't provide a value, the subnet uses the VCN's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_list_ids: (Updatable) The OCIDs of the security list or lists the subnet will use. If you don't provide a value, the subnet uses the VCN's default security list. Remember that security lists are associated *with the subnet*, but the rules are applied to the individual VNICs in the subnet.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "vcn_id", vcn_id)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dhcp_options_id is not None:
            pulumi.set(__self__, "dhcp_options_id", dhcp_options_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_label is not None:
            pulumi.set(__self__, "dns_label", dns_label)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ipv6cidr_block is not None:
            pulumi.set(__self__, "ipv6cidr_block", ipv6cidr_block)
        if ipv6cidr_blocks is not None:
            pulumi.set(__self__, "ipv6cidr_blocks", ipv6cidr_blocks)
        if prohibit_internet_ingress is not None:
            pulumi.set(__self__, "prohibit_internet_ingress", prohibit_internet_ingress)
        if prohibit_public_ip_on_vnic is not None:
            pulumi.set(__self__, "prohibit_public_ip_on_vnic", prohibit_public_ip_on_vnic)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if security_list_ids is not None:
            pulumi.set(__self__, "security_list_ids", security_list_ids)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The CIDR IP address range of the subnet. The CIDR must maintain the following rules -

        a. The CIDR block is valid and correctly formatted. b. The new range is within one of the parent VCN ranges.

        Example: `10.0.1.0/24`
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the subnet.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN to contain the subnet.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vcn_id", value)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls whether the subnet is regional or specific to an availability domain. Oracle recommends creating regional subnets because they're more flexible and make it easier to implement failover across availability domains. Originally, AD-specific subnets were the only kind available to use.

        To create a regional subnet, omit this attribute. Then any resources later created in this subnet (such as a Compute instance) can be created in any availability domain in the region.

        To instead create an AD-specific subnet, set this attribute to the availability domain you want this subnet to be in. Then any resources later created in this subnet can only be created in that availability domain.

        Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="dhcpOptionsId")
    def dhcp_options_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the set of DHCP options the subnet will use. If you don't provide a value, the subnet uses the VCN's default set of DHCP options.
        """
        return pulumi.get(self, "dhcp_options_id")

    @dhcp_options_id.setter
    def dhcp_options_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_options_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsLabel")
    def dns_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A DNS label for the subnet, used in conjunction with the VNIC's hostname and VCN's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Must be an alphanumeric string that begins with a letter and is unique within the VCN. The value cannot be changed.

        This value must be set if you want to use the Internet and VCN Resolver to resolve the hostnames of instances in the subnet. It can only be set if the VCN itself was created with a DNS label.

        For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        Example: `subnet123`
        """
        return pulumi.get(self, "dns_label")

    @dns_label.setter
    def dns_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_label", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="ipv6cidrBlock")
    def ipv6cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Use this to enable IPv6 addressing for this subnet. The VCN must be enabled for IPv6. You can't change this subnet characteristic later. All subnets are /64 in size. The subnet portion of the IPv6 address is the fourth hextet from the left (1111 in the following example).

        For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).

        Example: `2001:0db8:0123:1111::/64`
        """
        return pulumi.get(self, "ipv6cidr_block")

    @ipv6cidr_block.setter
    def ipv6cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="ipv6cidrBlocks")
    def ipv6cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The list of all IPv6 prefixes (Oracle allocated IPv6 GUA, ULA or private IPv6 prefixes, BYOIPv6 prefixes) for the subnet that meets the following criteria:
        * The prefixes must be valid.
        * Multiple prefixes must not overlap each other or the on-premises network prefix.
        * The number of prefixes must not exceed the limit of IPv6 prefixes allowed to a subnet.
        """
        return pulumi.get(self, "ipv6cidr_blocks")

    @ipv6cidr_blocks.setter
    def ipv6cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6cidr_blocks", value)

    @_builtins.property
    @pulumi.getter(name="prohibitInternetIngress")
    def prohibit_internet_ingress(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disallow ingress internet traffic to VNICs within this subnet. Defaults to false.

        For IPv6, if `prohibitInternetIngress` is set to `true`, internet access is not allowed for any IPv6s assigned to VNICs in the subnet. Otherwise, ingress internet traffic is allowed by default.

        `prohibitPublicIpOnVnic` will be set to the value of `prohibitInternetIngress` to dictate IPv4 behavior in this subnet. Only one or the other flag should be specified.

        Example: `true`
        """
        return pulumi.get(self, "prohibit_internet_ingress")

    @prohibit_internet_ingress.setter
    def prohibit_internet_ingress(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prohibit_internet_ingress", value)

    @_builtins.property
    @pulumi.getter(name="prohibitPublicIpOnVnic")
    def prohibit_public_ip_on_vnic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether VNICs within this subnet can have public IP addresses. Defaults to false, which means VNICs created in this subnet will automatically be assigned public IP addresses unless specified otherwise during instance launch or VNIC creation (with the `assignPublicIp` flag in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/)). If `prohibitPublicIpOnVnic` is set to true, VNICs created in this subnet cannot have public IP addresses (that is, it's a private subnet).

        If you intend to use an IPv6 prefix, you should use the flag `prohibitInternetIngress` to specify ingress internet traffic behavior of the subnet.

        Example: `true`
        """
        return pulumi.get(self, "prohibit_public_ip_on_vnic")

    @prohibit_public_ip_on_vnic.setter
    def prohibit_public_ip_on_vnic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prohibit_public_ip_on_vnic", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route table the subnet will use. If you don't provide a value, the subnet uses the VCN's default route table.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="securityListIds")
    def security_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The OCIDs of the security list or lists the subnet will use. If you don't provide a value, the subnet uses the VCN's default security list. Remember that security lists are associated *with the subnet*, but the rules are applied to the individual VNICs in the subnet.
        """
        return pulumi.get(self, "security_list_ids")

    @security_list_ids.setter
    def security_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_list_ids", value)


@pulumi.input_type
class _SubnetState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_options_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_label: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ipv6cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6virtual_router_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 prohibit_internet_ingress: Optional[pulumi.Input[_builtins.bool]] = None,
                 prohibit_public_ip_on_vnic: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_router_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_router_mac: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Subnet resources.
        :param pulumi.Input[_builtins.str] availability_domain: Controls whether the subnet is regional or specific to an availability domain. Oracle recommends creating regional subnets because they're more flexible and make it easier to implement failover across availability domains. Originally, AD-specific subnets were the only kind available to use.
               
               To create a regional subnet, omit this attribute. Then any resources later created in this subnet (such as a Compute instance) can be created in any availability domain in the region.
               
               To instead create an AD-specific subnet, set this attribute to the availability domain you want this subnet to be in. Then any resources later created in this subnet can only be created in that availability domain.
               
               Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] cidr_block: (Updatable) The CIDR IP address range of the subnet. The CIDR must maintain the following rules -
               
               a. The CIDR block is valid and correctly formatted. b. The new range is within one of the parent VCN ranges.
               
               Example: `10.0.1.0/24`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] dhcp_options_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the set of DHCP options the subnet will use. If you don't provide a value, the subnet uses the VCN's default set of DHCP options.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] dns_label: A DNS label for the subnet, used in conjunction with the VNIC's hostname and VCN's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Must be an alphanumeric string that begins with a letter and is unique within the VCN. The value cannot be changed.
               
               This value must be set if you want to use the Internet and VCN Resolver to resolve the hostnames of instances in the subnet. It can only be set if the VCN itself was created with a DNS label.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `subnet123`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] ipv6cidr_block: (Updatable) Use this to enable IPv6 addressing for this subnet. The VCN must be enabled for IPv6. You can't change this subnet characteristic later. All subnets are /64 in size. The subnet portion of the IPv6 address is the fourth hextet from the left (1111 in the following example).
               
               For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).
               
               Example: `2001:0db8:0123:1111::/64`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6cidr_blocks: (Updatable) The list of all IPv6 prefixes (Oracle allocated IPv6 GUA, ULA or private IPv6 prefixes, BYOIPv6 prefixes) for the subnet that meets the following criteria:
               * The prefixes must be valid.
               * Multiple prefixes must not overlap each other or the on-premises network prefix.
               * The number of prefixes must not exceed the limit of IPv6 prefixes allowed to a subnet.
        :param pulumi.Input[_builtins.str] ipv6virtual_router_ip: For an IPv6-enabled subnet, this is the IPv6 address of the virtual router.  Example: `2001:0db8:0123:1111:89ab:cdef:1234:5678`
        :param pulumi.Input[_builtins.bool] prohibit_internet_ingress: Whether to disallow ingress internet traffic to VNICs within this subnet. Defaults to false.
               
               For IPv6, if `prohibitInternetIngress` is set to `true`, internet access is not allowed for any IPv6s assigned to VNICs in the subnet. Otherwise, ingress internet traffic is allowed by default.
               
               `prohibitPublicIpOnVnic` will be set to the value of `prohibitInternetIngress` to dictate IPv4 behavior in this subnet. Only one or the other flag should be specified.
               
               Example: `true`
        :param pulumi.Input[_builtins.bool] prohibit_public_ip_on_vnic: Whether VNICs within this subnet can have public IP addresses. Defaults to false, which means VNICs created in this subnet will automatically be assigned public IP addresses unless specified otherwise during instance launch or VNIC creation (with the `assignPublicIp` flag in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/)). If `prohibitPublicIpOnVnic` is set to true, VNICs created in this subnet cannot have public IP addresses (that is, it's a private subnet).
               
               If you intend to use an IPv6 prefix, you should use the flag `prohibitInternetIngress` to specify ingress internet traffic behavior of the subnet.
               
               Example: `true`
        :param pulumi.Input[_builtins.str] route_table_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route table the subnet will use. If you don't provide a value, the subnet uses the VCN's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_list_ids: (Updatable) The OCIDs of the security list or lists the subnet will use. If you don't provide a value, the subnet uses the VCN's default security list. Remember that security lists are associated *with the subnet*, but the rules are applied to the individual VNICs in the subnet.
        :param pulumi.Input[_builtins.str] state: The subnet's current state.
        :param pulumi.Input[_builtins.str] subnet_domain_name: The subnet's domain name, which consists of the subnet's DNS label, the VCN's DNS label, and the `oraclevcn.com` domain.
        :param pulumi.Input[_builtins.str] time_created: The date and time the subnet was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN to contain the subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] virtual_router_ip: The IP address of the virtual router.  Example: `10.0.14.1`
        :param pulumi.Input[_builtins.str] virtual_router_mac: The MAC address of the virtual router.  Example: `00:00:00:00:00:01`
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dhcp_options_id is not None:
            pulumi.set(__self__, "dhcp_options_id", dhcp_options_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_label is not None:
            pulumi.set(__self__, "dns_label", dns_label)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ipv6cidr_block is not None:
            pulumi.set(__self__, "ipv6cidr_block", ipv6cidr_block)
        if ipv6cidr_blocks is not None:
            pulumi.set(__self__, "ipv6cidr_blocks", ipv6cidr_blocks)
        if ipv6virtual_router_ip is not None:
            pulumi.set(__self__, "ipv6virtual_router_ip", ipv6virtual_router_ip)
        if prohibit_internet_ingress is not None:
            pulumi.set(__self__, "prohibit_internet_ingress", prohibit_internet_ingress)
        if prohibit_public_ip_on_vnic is not None:
            pulumi.set(__self__, "prohibit_public_ip_on_vnic", prohibit_public_ip_on_vnic)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if security_list_ids is not None:
            pulumi.set(__self__, "security_list_ids", security_list_ids)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_domain_name is not None:
            pulumi.set(__self__, "subnet_domain_name", subnet_domain_name)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)
        if virtual_router_ip is not None:
            pulumi.set(__self__, "virtual_router_ip", virtual_router_ip)
        if virtual_router_mac is not None:
            pulumi.set(__self__, "virtual_router_mac", virtual_router_mac)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls whether the subnet is regional or specific to an availability domain. Oracle recommends creating regional subnets because they're more flexible and make it easier to implement failover across availability domains. Originally, AD-specific subnets were the only kind available to use.

        To create a regional subnet, omit this attribute. Then any resources later created in this subnet (such as a Compute instance) can be created in any availability domain in the region.

        To instead create an AD-specific subnet, set this attribute to the availability domain you want this subnet to be in. Then any resources later created in this subnet can only be created in that availability domain.

        Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The CIDR IP address range of the subnet. The CIDR must maintain the following rules -

        a. The CIDR block is valid and correctly formatted. b. The new range is within one of the parent VCN ranges.

        Example: `10.0.1.0/24`
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the subnet.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="dhcpOptionsId")
    def dhcp_options_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the set of DHCP options the subnet will use. If you don't provide a value, the subnet uses the VCN's default set of DHCP options.
        """
        return pulumi.get(self, "dhcp_options_id")

    @dhcp_options_id.setter
    def dhcp_options_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_options_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsLabel")
    def dns_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A DNS label for the subnet, used in conjunction with the VNIC's hostname and VCN's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Must be an alphanumeric string that begins with a letter and is unique within the VCN. The value cannot be changed.

        This value must be set if you want to use the Internet and VCN Resolver to resolve the hostnames of instances in the subnet. It can only be set if the VCN itself was created with a DNS label.

        For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        Example: `subnet123`
        """
        return pulumi.get(self, "dns_label")

    @dns_label.setter
    def dns_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_label", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="ipv6cidrBlock")
    def ipv6cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Use this to enable IPv6 addressing for this subnet. The VCN must be enabled for IPv6. You can't change this subnet characteristic later. All subnets are /64 in size. The subnet portion of the IPv6 address is the fourth hextet from the left (1111 in the following example).

        For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).

        Example: `2001:0db8:0123:1111::/64`
        """
        return pulumi.get(self, "ipv6cidr_block")

    @ipv6cidr_block.setter
    def ipv6cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="ipv6cidrBlocks")
    def ipv6cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The list of all IPv6 prefixes (Oracle allocated IPv6 GUA, ULA or private IPv6 prefixes, BYOIPv6 prefixes) for the subnet that meets the following criteria:
        * The prefixes must be valid.
        * Multiple prefixes must not overlap each other or the on-premises network prefix.
        * The number of prefixes must not exceed the limit of IPv6 prefixes allowed to a subnet.
        """
        return pulumi.get(self, "ipv6cidr_blocks")

    @ipv6cidr_blocks.setter
    def ipv6cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6cidr_blocks", value)

    @_builtins.property
    @pulumi.getter(name="ipv6virtualRouterIp")
    def ipv6virtual_router_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For an IPv6-enabled subnet, this is the IPv6 address of the virtual router.  Example: `2001:0db8:0123:1111:89ab:cdef:1234:5678`
        """
        return pulumi.get(self, "ipv6virtual_router_ip")

    @ipv6virtual_router_ip.setter
    def ipv6virtual_router_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6virtual_router_ip", value)

    @_builtins.property
    @pulumi.getter(name="prohibitInternetIngress")
    def prohibit_internet_ingress(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disallow ingress internet traffic to VNICs within this subnet. Defaults to false.

        For IPv6, if `prohibitInternetIngress` is set to `true`, internet access is not allowed for any IPv6s assigned to VNICs in the subnet. Otherwise, ingress internet traffic is allowed by default.

        `prohibitPublicIpOnVnic` will be set to the value of `prohibitInternetIngress` to dictate IPv4 behavior in this subnet. Only one or the other flag should be specified.

        Example: `true`
        """
        return pulumi.get(self, "prohibit_internet_ingress")

    @prohibit_internet_ingress.setter
    def prohibit_internet_ingress(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prohibit_internet_ingress", value)

    @_builtins.property
    @pulumi.getter(name="prohibitPublicIpOnVnic")
    def prohibit_public_ip_on_vnic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether VNICs within this subnet can have public IP addresses. Defaults to false, which means VNICs created in this subnet will automatically be assigned public IP addresses unless specified otherwise during instance launch or VNIC creation (with the `assignPublicIp` flag in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/)). If `prohibitPublicIpOnVnic` is set to true, VNICs created in this subnet cannot have public IP addresses (that is, it's a private subnet).

        If you intend to use an IPv6 prefix, you should use the flag `prohibitInternetIngress` to specify ingress internet traffic behavior of the subnet.

        Example: `true`
        """
        return pulumi.get(self, "prohibit_public_ip_on_vnic")

    @prohibit_public_ip_on_vnic.setter
    def prohibit_public_ip_on_vnic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prohibit_public_ip_on_vnic", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route table the subnet will use. If you don't provide a value, the subnet uses the VCN's default route table.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="securityListIds")
    def security_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The OCIDs of the security list or lists the subnet will use. If you don't provide a value, the subnet uses the VCN's default security list. Remember that security lists are associated *with the subnet*, but the rules are applied to the individual VNICs in the subnet.
        """
        return pulumi.get(self, "security_list_ids")

    @security_list_ids.setter
    def security_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_list_ids", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet's current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subnetDomainName")
    def subnet_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet's domain name, which consists of the subnet's DNS label, the VCN's DNS label, and the `oraclevcn.com` domain.
        """
        return pulumi.get(self, "subnet_domain_name")

    @subnet_domain_name.setter
    def subnet_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the subnet was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN to contain the subnet.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vcn_id", value)

    @_builtins.property
    @pulumi.getter(name="virtualRouterIp")
    def virtual_router_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the virtual router.  Example: `10.0.14.1`
        """
        return pulumi.get(self, "virtual_router_ip")

    @virtual_router_ip.setter
    def virtual_router_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_router_ip", value)

    @_builtins.property
    @pulumi.getter(name="virtualRouterMac")
    def virtual_router_mac(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MAC address of the virtual router.  Example: `00:00:00:00:00:01`
        """
        return pulumi.get(self, "virtual_router_mac")

    @virtual_router_mac.setter
    def virtual_router_mac(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_router_mac", value)


@pulumi.type_token("oci:Core/subnet:Subnet")
class Subnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_options_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_label: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ipv6cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 prohibit_internet_ingress: Optional[pulumi.Input[_builtins.bool]] = None,
                 prohibit_public_ip_on_vnic: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vcn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Subnet resource in Oracle Cloud Infrastructure Core service.

        Creates a new subnet in the specified VCN. You can't change the size of the subnet after creation,
        so it's important to think about the size of subnets you need before creating them.
        For more information, see [VCNs and Subnets](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVCNs.htm).
        For information on the number of subnets you can have in a VCN, see
        [Service Limits](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/servicelimits.htm).

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want the subnet
        to reside. Notice that the subnet doesn't have to be in the same compartment as the VCN, route tables, or
        other Networking Service components. If you're not sure which compartment to use, put the subnet in
        the same compartment as the VCN. For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm). For information about OCIDs,
        see [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally associate a route table with the subnet. If you don't, the subnet will use the
        VCN's default route table. For more information about route tables, see
        [Route Tables](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingroutetables.htm).

        You may optionally associate a security list with the subnet. If you don't, the subnet will use the
        VCN's default security list. For more information about security lists, see
        [Security Lists](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm).

        You may optionally associate a set of DHCP options with the subnet. If you don't, the subnet will use the
        VCN's default set. For more information about DHCP options, see
        [DHCP Options](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingDHCP.htm).

        You may optionally specify a *display name* for the subnet, otherwise a default is provided.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        You can also add a DNS label for the subnet, which is required if you want the Internet and
        VCN Resolver to resolve hostnames for instances in the subnet. For more information, see
        [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_subnet = oci.core.Subnet("test_subnet",
            cidr_block=subnet_cidr_block,
            compartment_id=compartment_id,
            vcn_id=test_vcn["id"],
            availability_domain=subnet_availability_domain,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            dhcp_options_id=test_dhcp_options["id"],
            display_name=subnet_display_name,
            dns_label=subnet_dns_label,
            freeform_tags={
                "Department": "Finance",
            },
            ipv6cidr_block=subnet_ipv6cidr_block,
            ipv6cidr_blocks=subnet_ipv6cidr_blocks,
            prohibit_internet_ingress=subnet_prohibit_internet_ingress,
            prohibit_public_ip_on_vnic=subnet_prohibit_public_ip_on_vnic,
            route_table_id=test_route_table["id"],
            security_list_ids=subnet_security_list_ids)
        ```

        ## Import

        Subnets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/subnet:Subnet test_subnet "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: Controls whether the subnet is regional or specific to an availability domain. Oracle recommends creating regional subnets because they're more flexible and make it easier to implement failover across availability domains. Originally, AD-specific subnets were the only kind available to use.
               
               To create a regional subnet, omit this attribute. Then any resources later created in this subnet (such as a Compute instance) can be created in any availability domain in the region.
               
               To instead create an AD-specific subnet, set this attribute to the availability domain you want this subnet to be in. Then any resources later created in this subnet can only be created in that availability domain.
               
               Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] cidr_block: (Updatable) The CIDR IP address range of the subnet. The CIDR must maintain the following rules -
               
               a. The CIDR block is valid and correctly formatted. b. The new range is within one of the parent VCN ranges.
               
               Example: `10.0.1.0/24`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] dhcp_options_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the set of DHCP options the subnet will use. If you don't provide a value, the subnet uses the VCN's default set of DHCP options.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] dns_label: A DNS label for the subnet, used in conjunction with the VNIC's hostname and VCN's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Must be an alphanumeric string that begins with a letter and is unique within the VCN. The value cannot be changed.
               
               This value must be set if you want to use the Internet and VCN Resolver to resolve the hostnames of instances in the subnet. It can only be set if the VCN itself was created with a DNS label.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `subnet123`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] ipv6cidr_block: (Updatable) Use this to enable IPv6 addressing for this subnet. The VCN must be enabled for IPv6. You can't change this subnet characteristic later. All subnets are /64 in size. The subnet portion of the IPv6 address is the fourth hextet from the left (1111 in the following example).
               
               For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).
               
               Example: `2001:0db8:0123:1111::/64`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6cidr_blocks: (Updatable) The list of all IPv6 prefixes (Oracle allocated IPv6 GUA, ULA or private IPv6 prefixes, BYOIPv6 prefixes) for the subnet that meets the following criteria:
               * The prefixes must be valid.
               * Multiple prefixes must not overlap each other or the on-premises network prefix.
               * The number of prefixes must not exceed the limit of IPv6 prefixes allowed to a subnet.
        :param pulumi.Input[_builtins.bool] prohibit_internet_ingress: Whether to disallow ingress internet traffic to VNICs within this subnet. Defaults to false.
               
               For IPv6, if `prohibitInternetIngress` is set to `true`, internet access is not allowed for any IPv6s assigned to VNICs in the subnet. Otherwise, ingress internet traffic is allowed by default.
               
               `prohibitPublicIpOnVnic` will be set to the value of `prohibitInternetIngress` to dictate IPv4 behavior in this subnet. Only one or the other flag should be specified.
               
               Example: `true`
        :param pulumi.Input[_builtins.bool] prohibit_public_ip_on_vnic: Whether VNICs within this subnet can have public IP addresses. Defaults to false, which means VNICs created in this subnet will automatically be assigned public IP addresses unless specified otherwise during instance launch or VNIC creation (with the `assignPublicIp` flag in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/)). If `prohibitPublicIpOnVnic` is set to true, VNICs created in this subnet cannot have public IP addresses (that is, it's a private subnet).
               
               If you intend to use an IPv6 prefix, you should use the flag `prohibitInternetIngress` to specify ingress internet traffic behavior of the subnet.
               
               Example: `true`
        :param pulumi.Input[_builtins.str] route_table_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route table the subnet will use. If you don't provide a value, the subnet uses the VCN's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_list_ids: (Updatable) The OCIDs of the security list or lists the subnet will use. If you don't provide a value, the subnet uses the VCN's default security list. Remember that security lists are associated *with the subnet*, but the rules are applied to the individual VNICs in the subnet.
        :param pulumi.Input[_builtins.str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN to contain the subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Subnet resource in Oracle Cloud Infrastructure Core service.

        Creates a new subnet in the specified VCN. You can't change the size of the subnet after creation,
        so it's important to think about the size of subnets you need before creating them.
        For more information, see [VCNs and Subnets](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVCNs.htm).
        For information on the number of subnets you can have in a VCN, see
        [Service Limits](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/servicelimits.htm).

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want the subnet
        to reside. Notice that the subnet doesn't have to be in the same compartment as the VCN, route tables, or
        other Networking Service components. If you're not sure which compartment to use, put the subnet in
        the same compartment as the VCN. For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm). For information about OCIDs,
        see [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally associate a route table with the subnet. If you don't, the subnet will use the
        VCN's default route table. For more information about route tables, see
        [Route Tables](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingroutetables.htm).

        You may optionally associate a security list with the subnet. If you don't, the subnet will use the
        VCN's default security list. For more information about security lists, see
        [Security Lists](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm).

        You may optionally associate a set of DHCP options with the subnet. If you don't, the subnet will use the
        VCN's default set. For more information about DHCP options, see
        [DHCP Options](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingDHCP.htm).

        You may optionally specify a *display name* for the subnet, otherwise a default is provided.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        You can also add a DNS label for the subnet, which is required if you want the Internet and
        VCN Resolver to resolve hostnames for instances in the subnet. For more information, see
        [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_subnet = oci.core.Subnet("test_subnet",
            cidr_block=subnet_cidr_block,
            compartment_id=compartment_id,
            vcn_id=test_vcn["id"],
            availability_domain=subnet_availability_domain,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            dhcp_options_id=test_dhcp_options["id"],
            display_name=subnet_display_name,
            dns_label=subnet_dns_label,
            freeform_tags={
                "Department": "Finance",
            },
            ipv6cidr_block=subnet_ipv6cidr_block,
            ipv6cidr_blocks=subnet_ipv6cidr_blocks,
            prohibit_internet_ingress=subnet_prohibit_internet_ingress,
            prohibit_public_ip_on_vnic=subnet_prohibit_public_ip_on_vnic,
            route_table_id=test_route_table["id"],
            security_list_ids=subnet_security_list_ids)
        ```

        ## Import

        Subnets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/subnet:Subnet test_subnet "id"
        ```

        :param str resource_name: The name of the resource.
        :param SubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_options_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_label: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ipv6cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 prohibit_internet_ingress: Optional[pulumi.Input[_builtins.bool]] = None,
                 prohibit_public_ip_on_vnic: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vcn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetArgs.__new__(SubnetArgs)

            __props__.__dict__["availability_domain"] = availability_domain
            if cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'cidr_block'")
            __props__.__dict__["cidr_block"] = cidr_block
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["dhcp_options_id"] = dhcp_options_id
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dns_label"] = dns_label
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["ipv6cidr_block"] = ipv6cidr_block
            __props__.__dict__["ipv6cidr_blocks"] = ipv6cidr_blocks
            __props__.__dict__["prohibit_internet_ingress"] = prohibit_internet_ingress
            __props__.__dict__["prohibit_public_ip_on_vnic"] = prohibit_public_ip_on_vnic
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["security_list_ids"] = security_list_ids
            if vcn_id is None and not opts.urn:
                raise TypeError("Missing required property 'vcn_id'")
            __props__.__dict__["vcn_id"] = vcn_id
            __props__.__dict__["ipv6virtual_router_ip"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subnet_domain_name"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["virtual_router_ip"] = None
            __props__.__dict__["virtual_router_mac"] = None
        super(Subnet, __self__).__init__(
            'oci:Core/subnet:Subnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            dhcp_options_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            dns_label: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ipv6cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv6virtual_router_ip: Optional[pulumi.Input[_builtins.str]] = None,
            prohibit_internet_ingress: Optional[pulumi.Input[_builtins.bool]] = None,
            prohibit_public_ip_on_vnic: Optional[pulumi.Input[_builtins.bool]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            vcn_id: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_router_ip: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_router_mac: Optional[pulumi.Input[_builtins.str]] = None) -> 'Subnet':
        """
        Get an existing Subnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: Controls whether the subnet is regional or specific to an availability domain. Oracle recommends creating regional subnets because they're more flexible and make it easier to implement failover across availability domains. Originally, AD-specific subnets were the only kind available to use.
               
               To create a regional subnet, omit this attribute. Then any resources later created in this subnet (such as a Compute instance) can be created in any availability domain in the region.
               
               To instead create an AD-specific subnet, set this attribute to the availability domain you want this subnet to be in. Then any resources later created in this subnet can only be created in that availability domain.
               
               Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] cidr_block: (Updatable) The CIDR IP address range of the subnet. The CIDR must maintain the following rules -
               
               a. The CIDR block is valid and correctly formatted. b. The new range is within one of the parent VCN ranges.
               
               Example: `10.0.1.0/24`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] dhcp_options_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the set of DHCP options the subnet will use. If you don't provide a value, the subnet uses the VCN's default set of DHCP options.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] dns_label: A DNS label for the subnet, used in conjunction with the VNIC's hostname and VCN's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Must be an alphanumeric string that begins with a letter and is unique within the VCN. The value cannot be changed.
               
               This value must be set if you want to use the Internet and VCN Resolver to resolve the hostnames of instances in the subnet. It can only be set if the VCN itself was created with a DNS label.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `subnet123`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] ipv6cidr_block: (Updatable) Use this to enable IPv6 addressing for this subnet. The VCN must be enabled for IPv6. You can't change this subnet characteristic later. All subnets are /64 in size. The subnet portion of the IPv6 address is the fourth hextet from the left (1111 in the following example).
               
               For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).
               
               Example: `2001:0db8:0123:1111::/64`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6cidr_blocks: (Updatable) The list of all IPv6 prefixes (Oracle allocated IPv6 GUA, ULA or private IPv6 prefixes, BYOIPv6 prefixes) for the subnet that meets the following criteria:
               * The prefixes must be valid.
               * Multiple prefixes must not overlap each other or the on-premises network prefix.
               * The number of prefixes must not exceed the limit of IPv6 prefixes allowed to a subnet.
        :param pulumi.Input[_builtins.str] ipv6virtual_router_ip: For an IPv6-enabled subnet, this is the IPv6 address of the virtual router.  Example: `2001:0db8:0123:1111:89ab:cdef:1234:5678`
        :param pulumi.Input[_builtins.bool] prohibit_internet_ingress: Whether to disallow ingress internet traffic to VNICs within this subnet. Defaults to false.
               
               For IPv6, if `prohibitInternetIngress` is set to `true`, internet access is not allowed for any IPv6s assigned to VNICs in the subnet. Otherwise, ingress internet traffic is allowed by default.
               
               `prohibitPublicIpOnVnic` will be set to the value of `prohibitInternetIngress` to dictate IPv4 behavior in this subnet. Only one or the other flag should be specified.
               
               Example: `true`
        :param pulumi.Input[_builtins.bool] prohibit_public_ip_on_vnic: Whether VNICs within this subnet can have public IP addresses. Defaults to false, which means VNICs created in this subnet will automatically be assigned public IP addresses unless specified otherwise during instance launch or VNIC creation (with the `assignPublicIp` flag in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/)). If `prohibitPublicIpOnVnic` is set to true, VNICs created in this subnet cannot have public IP addresses (that is, it's a private subnet).
               
               If you intend to use an IPv6 prefix, you should use the flag `prohibitInternetIngress` to specify ingress internet traffic behavior of the subnet.
               
               Example: `true`
        :param pulumi.Input[_builtins.str] route_table_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route table the subnet will use. If you don't provide a value, the subnet uses the VCN's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_list_ids: (Updatable) The OCIDs of the security list or lists the subnet will use. If you don't provide a value, the subnet uses the VCN's default security list. Remember that security lists are associated *with the subnet*, but the rules are applied to the individual VNICs in the subnet.
        :param pulumi.Input[_builtins.str] state: The subnet's current state.
        :param pulumi.Input[_builtins.str] subnet_domain_name: The subnet's domain name, which consists of the subnet's DNS label, the VCN's DNS label, and the `oraclevcn.com` domain.
        :param pulumi.Input[_builtins.str] time_created: The date and time the subnet was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN to contain the subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] virtual_router_ip: The IP address of the virtual router.  Example: `10.0.14.1`
        :param pulumi.Input[_builtins.str] virtual_router_mac: The MAC address of the virtual router.  Example: `00:00:00:00:00:01`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetState.__new__(_SubnetState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["dhcp_options_id"] = dhcp_options_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns_label"] = dns_label
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ipv6cidr_block"] = ipv6cidr_block
        __props__.__dict__["ipv6cidr_blocks"] = ipv6cidr_blocks
        __props__.__dict__["ipv6virtual_router_ip"] = ipv6virtual_router_ip
        __props__.__dict__["prohibit_internet_ingress"] = prohibit_internet_ingress
        __props__.__dict__["prohibit_public_ip_on_vnic"] = prohibit_public_ip_on_vnic
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["security_list_ids"] = security_list_ids
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_domain_name"] = subnet_domain_name
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vcn_id"] = vcn_id
        __props__.__dict__["virtual_router_ip"] = virtual_router_ip
        __props__.__dict__["virtual_router_mac"] = virtual_router_mac
        return Subnet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        Controls whether the subnet is regional or specific to an availability domain. Oracle recommends creating regional subnets because they're more flexible and make it easier to implement failover across availability domains. Originally, AD-specific subnets were the only kind available to use.

        To create a regional subnet, omit this attribute. Then any resources later created in this subnet (such as a Compute instance) can be created in any availability domain in the region.

        To instead create an AD-specific subnet, set this attribute to the availability domain you want this subnet to be in. Then any resources later created in this subnet can only be created in that availability domain.

        Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The CIDR IP address range of the subnet. The CIDR must maintain the following rules -

        a. The CIDR block is valid and correctly formatted. b. The new range is within one of the parent VCN ranges.

        Example: `10.0.1.0/24`
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the subnet.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="dhcpOptionsId")
    def dhcp_options_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the set of DHCP options the subnet will use. If you don't provide a value, the subnet uses the VCN's default set of DHCP options.
        """
        return pulumi.get(self, "dhcp_options_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="dnsLabel")
    def dns_label(self) -> pulumi.Output[_builtins.str]:
        """
        A DNS label for the subnet, used in conjunction with the VNIC's hostname and VCN's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Must be an alphanumeric string that begins with a letter and is unique within the VCN. The value cannot be changed.

        This value must be set if you want to use the Internet and VCN Resolver to resolve the hostnames of instances in the subnet. It can only be set if the VCN itself was created with a DNS label.

        For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        Example: `subnet123`
        """
        return pulumi.get(self, "dns_label")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="ipv6cidrBlock")
    def ipv6cidr_block(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Use this to enable IPv6 addressing for this subnet. The VCN must be enabled for IPv6. You can't change this subnet characteristic later. All subnets are /64 in size. The subnet portion of the IPv6 address is the fourth hextet from the left (1111 in the following example).

        For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).

        Example: `2001:0db8:0123:1111::/64`
        """
        return pulumi.get(self, "ipv6cidr_block")

    @_builtins.property
    @pulumi.getter(name="ipv6cidrBlocks")
    def ipv6cidr_blocks(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) The list of all IPv6 prefixes (Oracle allocated IPv6 GUA, ULA or private IPv6 prefixes, BYOIPv6 prefixes) for the subnet that meets the following criteria:
        * The prefixes must be valid.
        * Multiple prefixes must not overlap each other or the on-premises network prefix.
        * The number of prefixes must not exceed the limit of IPv6 prefixes allowed to a subnet.
        """
        return pulumi.get(self, "ipv6cidr_blocks")

    @_builtins.property
    @pulumi.getter(name="ipv6virtualRouterIp")
    def ipv6virtual_router_ip(self) -> pulumi.Output[_builtins.str]:
        """
        For an IPv6-enabled subnet, this is the IPv6 address of the virtual router.  Example: `2001:0db8:0123:1111:89ab:cdef:1234:5678`
        """
        return pulumi.get(self, "ipv6virtual_router_ip")

    @_builtins.property
    @pulumi.getter(name="prohibitInternetIngress")
    def prohibit_internet_ingress(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to disallow ingress internet traffic to VNICs within this subnet. Defaults to false.

        For IPv6, if `prohibitInternetIngress` is set to `true`, internet access is not allowed for any IPv6s assigned to VNICs in the subnet. Otherwise, ingress internet traffic is allowed by default.

        `prohibitPublicIpOnVnic` will be set to the value of `prohibitInternetIngress` to dictate IPv4 behavior in this subnet. Only one or the other flag should be specified.

        Example: `true`
        """
        return pulumi.get(self, "prohibit_internet_ingress")

    @_builtins.property
    @pulumi.getter(name="prohibitPublicIpOnVnic")
    def prohibit_public_ip_on_vnic(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether VNICs within this subnet can have public IP addresses. Defaults to false, which means VNICs created in this subnet will automatically be assigned public IP addresses unless specified otherwise during instance launch or VNIC creation (with the `assignPublicIp` flag in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/)). If `prohibitPublicIpOnVnic` is set to true, VNICs created in this subnet cannot have public IP addresses (that is, it's a private subnet).

        If you intend to use an IPv6 prefix, you should use the flag `prohibitInternetIngress` to specify ingress internet traffic behavior of the subnet.

        Example: `true`
        """
        return pulumi.get(self, "prohibit_public_ip_on_vnic")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route table the subnet will use. If you don't provide a value, the subnet uses the VCN's default route table.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter(name="securityListIds")
    def security_list_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) The OCIDs of the security list or lists the subnet will use. If you don't provide a value, the subnet uses the VCN's default security list. Remember that security lists are associated *with the subnet*, but the rules are applied to the individual VNICs in the subnet.
        """
        return pulumi.get(self, "security_list_ids")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The subnet's current state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetDomainName")
    def subnet_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The subnet's domain name, which consists of the subnet's DNS label, the VCN's DNS label, and the `oraclevcn.com` domain.
        """
        return pulumi.get(self, "subnet_domain_name")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the subnet was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN to contain the subnet.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @_builtins.property
    @pulumi.getter(name="virtualRouterIp")
    def virtual_router_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the virtual router.  Example: `10.0.14.1`
        """
        return pulumi.get(self, "virtual_router_ip")

    @_builtins.property
    @pulumi.getter(name="virtualRouterMac")
    def virtual_router_mac(self) -> pulumi.Output[_builtins.str]:
        """
        The MAC address of the virtual router.  Example: `00:00:00:00:00:01`
        """
        return pulumi.get(self, "virtual_router_mac")

