# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeGroupArgs', 'VolumeGroup']

@pulumi.input_type
class VolumeGroupArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 source_details: pulumi.Input['VolumeGroupSourceDetailsArgs'],
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 preserve_volume_replica: Optional[pulumi.Input[_builtins.bool]] = None,
                 volume_group_replicas: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupVolumeGroupReplicaArgs']]]] = None,
                 volume_group_replicas_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VolumeGroup resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the volume group.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the volume group.
        :param pulumi.Input['VolumeGroupSourceDetailsArgs'] source_details: Specifies the source for a volume group.
        :param pulumi.Input[_builtins.str] backup_policy_id: If provided, specifies the ID of the volume backup policy to assign to the newly created volume group. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume group.
        :param pulumi.Input[_builtins.str] cluster_placement_group_id: The clusterPlacementGroup Id of the volume group for volume group placement.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupVolumeGroupReplicaArgs']]] volume_group_replicas: (Updatable) The list of volume group replicas that this volume group will be enabled to have in the specified destination availability domains.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_ids: (Updatable) Use this for update operation only. This field is not supported during creation. For create use `volume_ids` under `source_details`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the volume's cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm).
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "source_details", source_details)
        if backup_policy_id is not None:
            warnings.warn("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""backup_policy_id is deprecated: The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
        if backup_policy_id is not None:
            pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if preserve_volume_replica is not None:
            pulumi.set(__self__, "preserve_volume_replica", preserve_volume_replica)
        if volume_group_replicas is not None:
            pulumi.set(__self__, "volume_group_replicas", volume_group_replicas)
        if volume_group_replicas_deletion is not None:
            pulumi.set(__self__, "volume_group_replicas_deletion", volume_group_replicas_deletion)
        if volume_ids is not None:
            pulumi.set(__self__, "volume_ids", volume_ids)
        if xrc_kms_key_id is not None:
            pulumi.set(__self__, "xrc_kms_key_id", xrc_kms_key_id)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[_builtins.str]:
        """
        The availability domain of the volume group.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains the volume group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Input['VolumeGroupSourceDetailsArgs']:
        """
        Specifies the source for a volume group.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: pulumi.Input['VolumeGroupSourceDetailsArgs']):
        pulumi.set(self, "source_details", value)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    @_utilities.deprecated("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
    def backup_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If provided, specifies the ID of the volume backup policy to assign to the newly created volume group. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume group.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clusterPlacementGroup Id of the volume group for volume group placement.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="preserveVolumeReplica")
    def preserve_volume_replica(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "preserve_volume_replica")

    @preserve_volume_replica.setter
    def preserve_volume_replica(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve_volume_replica", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupReplicas")
    def volume_group_replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupVolumeGroupReplicaArgs']]]]:
        """
        (Updatable) The list of volume group replicas that this volume group will be enabled to have in the specified destination availability domains.
        """
        return pulumi.get(self, "volume_group_replicas")

    @volume_group_replicas.setter
    def volume_group_replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupVolumeGroupReplicaArgs']]]]):
        pulumi.set(self, "volume_group_replicas", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupReplicasDeletion")
    def volume_group_replicas_deletion(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "volume_group_replicas_deletion")

    @volume_group_replicas_deletion.setter
    def volume_group_replicas_deletion(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "volume_group_replicas_deletion", value)

    @_builtins.property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Use this for update operation only. This field is not supported during creation. For create use `volume_ids` under `source_details`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "volume_ids")

    @volume_ids.setter
    def volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_ids", value)

    @_builtins.property
    @pulumi.getter(name="xrcKmsKeyId")
    def xrc_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the Vault service key which is the master encryption key for the volume's cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm).
        """
        return pulumi.get(self, "xrc_kms_key_id")

    @xrc_kms_key_id.setter
    def xrc_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xrc_kms_key_id", value)


@pulumi.input_type
class _VolumeGroupState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_hydrated: Optional[pulumi.Input[_builtins.bool]] = None,
                 preserve_volume_replica: Optional[pulumi.Input[_builtins.bool]] = None,
                 size_in_gbs: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_mbs: Optional[pulumi.Input[_builtins.str]] = None,
                 source_details: Optional[pulumi.Input['VolumeGroupSourceDetailsArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_group_replicas: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupVolumeGroupReplicaArgs']]]] = None,
                 volume_group_replicas_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeGroup resources.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the volume group.
        :param pulumi.Input[_builtins.str] backup_policy_id: If provided, specifies the ID of the volume backup policy to assign to the newly created volume group. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume group.
        :param pulumi.Input[_builtins.str] cluster_placement_group_id: The clusterPlacementGroup Id of the volume group for volume group placement.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the volume group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_hydrated: Specifies whether the newly created cloned volume group's data has finished copying from the source volume group or backup.
        :param pulumi.Input[_builtins.str] size_in_gbs: The aggregate size of the volume group in GBs.
        :param pulumi.Input[_builtins.str] size_in_mbs: The aggregate size of the volume group in MBs.
        :param pulumi.Input['VolumeGroupSourceDetailsArgs'] source_details: Specifies the source for a volume group.
        :param pulumi.Input[_builtins.str] state: The current state of a volume group.
        :param pulumi.Input[_builtins.str] time_created: The date and time the volume group was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupVolumeGroupReplicaArgs']]] volume_group_replicas: (Updatable) The list of volume group replicas that this volume group will be enabled to have in the specified destination availability domains.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_ids: (Updatable) Use this for update operation only. This field is not supported during creation. For create use `volume_ids` under `source_details`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the volume's cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm).
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_policy_id is not None:
            warnings.warn("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""backup_policy_id is deprecated: The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
        if backup_policy_id is not None:
            pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_hydrated is not None:
            pulumi.set(__self__, "is_hydrated", is_hydrated)
        if preserve_volume_replica is not None:
            pulumi.set(__self__, "preserve_volume_replica", preserve_volume_replica)
        if size_in_gbs is not None:
            pulumi.set(__self__, "size_in_gbs", size_in_gbs)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if volume_group_replicas is not None:
            pulumi.set(__self__, "volume_group_replicas", volume_group_replicas)
        if volume_group_replicas_deletion is not None:
            pulumi.set(__self__, "volume_group_replicas_deletion", volume_group_replicas_deletion)
        if volume_ids is not None:
            pulumi.set(__self__, "volume_ids", volume_ids)
        if xrc_kms_key_id is not None:
            pulumi.set(__self__, "xrc_kms_key_id", xrc_kms_key_id)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability domain of the volume group.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    @_utilities.deprecated("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
    def backup_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If provided, specifies the ID of the volume backup policy to assign to the newly created volume group. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume group.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clusterPlacementGroup Id of the volume group for volume group placement.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment that contains the volume group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isHydrated")
    def is_hydrated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the newly created cloned volume group's data has finished copying from the source volume group or backup.
        """
        return pulumi.get(self, "is_hydrated")

    @is_hydrated.setter
    def is_hydrated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_hydrated", value)

    @_builtins.property
    @pulumi.getter(name="preserveVolumeReplica")
    def preserve_volume_replica(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "preserve_volume_replica")

    @preserve_volume_replica.setter
    def preserve_volume_replica(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve_volume_replica", value)

    @_builtins.property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The aggregate size of the volume group in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @size_in_gbs.setter
    def size_in_gbs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The aggregate size of the volume group in MBs.
        """
        return pulumi.get(self, "size_in_mbs")

    @size_in_mbs.setter
    def size_in_mbs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size_in_mbs", value)

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['VolumeGroupSourceDetailsArgs']]:
        """
        Specifies the source for a volume group.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['VolumeGroupSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of a volume group.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the volume group was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupReplicas")
    def volume_group_replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupVolumeGroupReplicaArgs']]]]:
        """
        (Updatable) The list of volume group replicas that this volume group will be enabled to have in the specified destination availability domains.
        """
        return pulumi.get(self, "volume_group_replicas")

    @volume_group_replicas.setter
    def volume_group_replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupVolumeGroupReplicaArgs']]]]):
        pulumi.set(self, "volume_group_replicas", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupReplicasDeletion")
    def volume_group_replicas_deletion(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "volume_group_replicas_deletion")

    @volume_group_replicas_deletion.setter
    def volume_group_replicas_deletion(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "volume_group_replicas_deletion", value)

    @_builtins.property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Use this for update operation only. This field is not supported during creation. For create use `volume_ids` under `source_details`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "volume_ids")

    @volume_ids.setter
    def volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_ids", value)

    @_builtins.property
    @pulumi.getter(name="xrcKmsKeyId")
    def xrc_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the Vault service key which is the master encryption key for the volume's cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm).
        """
        return pulumi.get(self, "xrc_kms_key_id")

    @xrc_kms_key_id.setter
    def xrc_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xrc_kms_key_id", value)


@pulumi.type_token("oci:Core/volumeGroup:VolumeGroup")
class VolumeGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 preserve_volume_replica: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_details: Optional[pulumi.Input[Union['VolumeGroupSourceDetailsArgs', 'VolumeGroupSourceDetailsArgsDict']]] = None,
                 volume_group_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupVolumeGroupReplicaArgs', 'VolumeGroupVolumeGroupReplicaArgsDict']]]]] = None,
                 volume_group_replicas_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_volume_group = oci.core.VolumeGroup("test_volume_group",
            availability_domain=volume_group_availability_domain,
            compartment_id=compartment_id,
            source_details={
                "type": "volumeIds",
                "volume_ids": [volume_group_source_id],
            },
            backup_policy_id=test_volume_backup_policies["volumeBackupPolicies"][0]["id"],
            cluster_placement_group_id=test_group["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=volume_group_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            volume_group_replicas=[{
                "availability_domain": volume_group_volume_group_replicas_availability_domain,
                "display_name": volume_group_volume_group_replicas_display_name,
                "xrr_kms_key_id": test_key["id"],
            }],
            volume_ids=[volume_group_source_id],
            xrc_kms_key_id=test_key["id"])
        ```

        ## Import

        VolumeGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/volumeGroup:VolumeGroup test_volume_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the volume group.
        :param pulumi.Input[_builtins.str] backup_policy_id: If provided, specifies the ID of the volume backup policy to assign to the newly created volume group. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume group.
        :param pulumi.Input[_builtins.str] cluster_placement_group_id: The clusterPlacementGroup Id of the volume group for volume group placement.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the volume group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['VolumeGroupSourceDetailsArgs', 'VolumeGroupSourceDetailsArgsDict']] source_details: Specifies the source for a volume group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupVolumeGroupReplicaArgs', 'VolumeGroupVolumeGroupReplicaArgsDict']]]] volume_group_replicas: (Updatable) The list of volume group replicas that this volume group will be enabled to have in the specified destination availability domains.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_ids: (Updatable) Use this for update operation only. This field is not supported during creation. For create use `volume_ids` under `source_details`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the volume's cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_volume_group = oci.core.VolumeGroup("test_volume_group",
            availability_domain=volume_group_availability_domain,
            compartment_id=compartment_id,
            source_details={
                "type": "volumeIds",
                "volume_ids": [volume_group_source_id],
            },
            backup_policy_id=test_volume_backup_policies["volumeBackupPolicies"][0]["id"],
            cluster_placement_group_id=test_group["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=volume_group_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            volume_group_replicas=[{
                "availability_domain": volume_group_volume_group_replicas_availability_domain,
                "display_name": volume_group_volume_group_replicas_display_name,
                "xrr_kms_key_id": test_key["id"],
            }],
            volume_ids=[volume_group_source_id],
            xrc_kms_key_id=test_key["id"])
        ```

        ## Import

        VolumeGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/volumeGroup:VolumeGroup test_volume_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param VolumeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 preserve_volume_replica: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_details: Optional[pulumi.Input[Union['VolumeGroupSourceDetailsArgs', 'VolumeGroupSourceDetailsArgsDict']]] = None,
                 volume_group_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupVolumeGroupReplicaArgs', 'VolumeGroupVolumeGroupReplicaArgsDict']]]]] = None,
                 volume_group_replicas_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeGroupArgs.__new__(VolumeGroupArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["backup_policy_id"] = backup_policy_id
            __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["preserve_volume_replica"] = preserve_volume_replica
            if source_details is None and not opts.urn:
                raise TypeError("Missing required property 'source_details'")
            __props__.__dict__["source_details"] = source_details
            __props__.__dict__["volume_group_replicas"] = volume_group_replicas
            __props__.__dict__["volume_group_replicas_deletion"] = volume_group_replicas_deletion
            __props__.__dict__["volume_ids"] = volume_ids
            __props__.__dict__["xrc_kms_key_id"] = xrc_kms_key_id
            __props__.__dict__["is_hydrated"] = None
            __props__.__dict__["size_in_gbs"] = None
            __props__.__dict__["size_in_mbs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(VolumeGroup, __self__).__init__(
            'oci:Core/volumeGroup:VolumeGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_hydrated: Optional[pulumi.Input[_builtins.bool]] = None,
            preserve_volume_replica: Optional[pulumi.Input[_builtins.bool]] = None,
            size_in_gbs: Optional[pulumi.Input[_builtins.str]] = None,
            size_in_mbs: Optional[pulumi.Input[_builtins.str]] = None,
            source_details: Optional[pulumi.Input[Union['VolumeGroupSourceDetailsArgs', 'VolumeGroupSourceDetailsArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            volume_group_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupVolumeGroupReplicaArgs', 'VolumeGroupVolumeGroupReplicaArgsDict']]]]] = None,
            volume_group_replicas_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
            volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            xrc_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VolumeGroup':
        """
        Get an existing VolumeGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the volume group.
        :param pulumi.Input[_builtins.str] backup_policy_id: If provided, specifies the ID of the volume backup policy to assign to the newly created volume group. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume group.
        :param pulumi.Input[_builtins.str] cluster_placement_group_id: The clusterPlacementGroup Id of the volume group for volume group placement.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the volume group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_hydrated: Specifies whether the newly created cloned volume group's data has finished copying from the source volume group or backup.
        :param pulumi.Input[_builtins.str] size_in_gbs: The aggregate size of the volume group in GBs.
        :param pulumi.Input[_builtins.str] size_in_mbs: The aggregate size of the volume group in MBs.
        :param pulumi.Input[Union['VolumeGroupSourceDetailsArgs', 'VolumeGroupSourceDetailsArgsDict']] source_details: Specifies the source for a volume group.
        :param pulumi.Input[_builtins.str] state: The current state of a volume group.
        :param pulumi.Input[_builtins.str] time_created: The date and time the volume group was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupVolumeGroupReplicaArgs', 'VolumeGroupVolumeGroupReplicaArgsDict']]]] volume_group_replicas: (Updatable) The list of volume group replicas that this volume group will be enabled to have in the specified destination availability domains.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_ids: (Updatable) Use this for update operation only. This field is not supported during creation. For create use `volume_ids` under `source_details`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the volume's cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeGroupState.__new__(_VolumeGroupState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["backup_policy_id"] = backup_policy_id
        __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_hydrated"] = is_hydrated
        __props__.__dict__["preserve_volume_replica"] = preserve_volume_replica
        __props__.__dict__["size_in_gbs"] = size_in_gbs
        __props__.__dict__["size_in_mbs"] = size_in_mbs
        __props__.__dict__["source_details"] = source_details
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["volume_group_replicas"] = volume_group_replicas
        __props__.__dict__["volume_group_replicas_deletion"] = volume_group_replicas_deletion
        __props__.__dict__["volume_ids"] = volume_ids
        __props__.__dict__["xrc_kms_key_id"] = xrc_kms_key_id
        return VolumeGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The availability domain of the volume group.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    @_utilities.deprecated("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
    def backup_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        If provided, specifies the ID of the volume backup policy to assign to the newly created volume group. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume group.
        """
        return pulumi.get(self, "backup_policy_id")

    @_builtins.property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The clusterPlacementGroup Id of the volume group for volume group placement.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains the volume group.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isHydrated")
    def is_hydrated(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether the newly created cloned volume group's data has finished copying from the source volume group or backup.
        """
        return pulumi.get(self, "is_hydrated")

    @_builtins.property
    @pulumi.getter(name="preserveVolumeReplica")
    def preserve_volume_replica(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "preserve_volume_replica")

    @_builtins.property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> pulumi.Output[_builtins.str]:
        """
        The aggregate size of the volume group in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> pulumi.Output[_builtins.str]:
        """
        The aggregate size of the volume group in MBs.
        """
        return pulumi.get(self, "size_in_mbs")

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Output['outputs.VolumeGroupSourceDetails']:
        """
        Specifies the source for a volume group.
        """
        return pulumi.get(self, "source_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of a volume group.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the volume group was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="volumeGroupReplicas")
    def volume_group_replicas(self) -> pulumi.Output[Sequence['outputs.VolumeGroupVolumeGroupReplica']]:
        """
        (Updatable) The list of volume group replicas that this volume group will be enabled to have in the specified destination availability domains.
        """
        return pulumi.get(self, "volume_group_replicas")

    @_builtins.property
    @pulumi.getter(name="volumeGroupReplicasDeletion")
    def volume_group_replicas_deletion(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "volume_group_replicas_deletion")

    @_builtins.property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) Use this for update operation only. This field is not supported during creation. For create use `volume_ids` under `source_details`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "volume_ids")

    @_builtins.property
    @pulumi.getter(name="xrcKmsKeyId")
    def xrc_kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the Vault service key which is the master encryption key for the volume's cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm).
        """
        return pulumi.get(self, "xrc_kms_key_id")

