# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousContainerDatabaseVersionsResult',
    'AwaitableGetAutonomousContainerDatabaseVersionsResult',
    'get_autonomous_container_database_versions',
    'get_autonomous_container_database_versions_output',
]

@pulumi.output_type
class GetAutonomousContainerDatabaseVersionsResult:
    """
    A collection of values returned by getAutonomousContainerDatabaseVersions.
    """
    def __init__(__self__, autonomous_container_database_versions=None, compartment_id=None, filters=None, id=None, service_component=None):
        if autonomous_container_database_versions and not isinstance(autonomous_container_database_versions, list):
            raise TypeError("Expected argument 'autonomous_container_database_versions' to be a list")
        pulumi.set(__self__, "autonomous_container_database_versions", autonomous_container_database_versions)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_component and not isinstance(service_component, str):
            raise TypeError("Expected argument 'service_component' to be a str")
        pulumi.set(__self__, "service_component", service_component)

    @_builtins.property
    @pulumi.getter(name="autonomousContainerDatabaseVersions")
    def autonomous_container_database_versions(self) -> Sequence['outputs.GetAutonomousContainerDatabaseVersionsAutonomousContainerDatabaseVersionResult']:
        """
        The list of autonomous_container_database_versions.
        """
        return pulumi.get(self, "autonomous_container_database_versions")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousContainerDatabaseVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="serviceComponent")
    def service_component(self) -> _builtins.str:
        return pulumi.get(self, "service_component")


class AwaitableGetAutonomousContainerDatabaseVersionsResult(GetAutonomousContainerDatabaseVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousContainerDatabaseVersionsResult(
            autonomous_container_database_versions=self.autonomous_container_database_versions,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            service_component=self.service_component)


def get_autonomous_container_database_versions(compartment_id: Optional[_builtins.str] = None,
                                               filters: Optional[Sequence[Union['GetAutonomousContainerDatabaseVersionsFilterArgs', 'GetAutonomousContainerDatabaseVersionsFilterArgsDict']]] = None,
                                               service_component: Optional[_builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousContainerDatabaseVersionsResult:
    """
    This data source provides the list of Autonomous Container Database Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Autonomous Container Database versions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database_versions = oci.Database.get_autonomous_container_database_versions(compartment_id=compartment_id,
        service_component=autonomous_container_database_version_service_component)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str service_component: The service component to use, either ADBD or EXACC.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['serviceComponent'] = service_component
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousContainerDatabaseVersions:getAutonomousContainerDatabaseVersions', __args__, opts=opts, typ=GetAutonomousContainerDatabaseVersionsResult).value

    return AwaitableGetAutonomousContainerDatabaseVersionsResult(
        autonomous_container_database_versions=pulumi.get(__ret__, 'autonomous_container_database_versions'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        service_component=pulumi.get(__ret__, 'service_component'))
def get_autonomous_container_database_versions_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousContainerDatabaseVersionsFilterArgs', 'GetAutonomousContainerDatabaseVersionsFilterArgsDict']]]]] = None,
                                                      service_component: Optional[pulumi.Input[_builtins.str]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousContainerDatabaseVersionsResult]:
    """
    This data source provides the list of Autonomous Container Database Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Autonomous Container Database versions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database_versions = oci.Database.get_autonomous_container_database_versions(compartment_id=compartment_id,
        service_component=autonomous_container_database_version_service_component)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str service_component: The service component to use, either ADBD or EXACC.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['serviceComponent'] = service_component
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousContainerDatabaseVersions:getAutonomousContainerDatabaseVersions', __args__, opts=opts, typ=GetAutonomousContainerDatabaseVersionsResult)
    return __ret__.apply(lambda __response__: GetAutonomousContainerDatabaseVersionsResult(
        autonomous_container_database_versions=pulumi.get(__response__, 'autonomous_container_database_versions'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        service_component=pulumi.get(__response__, 'service_component')))
