# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDataGuardAssociationsResult',
    'AwaitableGetDataGuardAssociationsResult',
    'get_data_guard_associations',
    'get_data_guard_associations_output',
]

@pulumi.output_type
class GetDataGuardAssociationsResult:
    """
    A collection of values returned by getDataGuardAssociations.
    """
    def __init__(__self__, data_guard_associations=None, database_id=None, filters=None, id=None):
        if data_guard_associations and not isinstance(data_guard_associations, list):
            raise TypeError("Expected argument 'data_guard_associations' to be a list")
        pulumi.set(__self__, "data_guard_associations", data_guard_associations)
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="dataGuardAssociations")
    def data_guard_associations(self) -> Sequence['outputs.GetDataGuardAssociationsDataGuardAssociationResult']:
        """
        The list of data_guard_associations.
        """
        return pulumi.get(self, "data_guard_associations")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the reporting database.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDataGuardAssociationsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDataGuardAssociationsResult(GetDataGuardAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataGuardAssociationsResult(
            data_guard_associations=self.data_guard_associations,
            database_id=self.database_id,
            filters=self.filters,
            id=self.id)


def get_data_guard_associations(database_id: Optional[_builtins.str] = None,
                                filters: Optional[Sequence[Union['GetDataGuardAssociationsFilterArgs', 'GetDataGuardAssociationsFilterArgsDict']]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataGuardAssociationsResult:
    """
    This data source provides the list of Data Guard Associations in Oracle Cloud Infrastructure Database service.

    Lists all Data Guard associations for the specified database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_guard_associations = oci.Database.get_data_guard_associations(database_id=test_database["id"])
    ```


    :param _builtins.str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDataGuardAssociations:getDataGuardAssociations', __args__, opts=opts, typ=GetDataGuardAssociationsResult).value

    return AwaitableGetDataGuardAssociationsResult(
        data_guard_associations=pulumi.get(__ret__, 'data_guard_associations'),
        database_id=pulumi.get(__ret__, 'database_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_data_guard_associations_output(database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDataGuardAssociationsFilterArgs', 'GetDataGuardAssociationsFilterArgsDict']]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataGuardAssociationsResult]:
    """
    This data source provides the list of Data Guard Associations in Oracle Cloud Infrastructure Database service.

    Lists all Data Guard associations for the specified database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_guard_associations = oci.Database.get_data_guard_associations(database_id=test_database["id"])
    ```


    :param _builtins.str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDataGuardAssociations:getDataGuardAssociations', __args__, opts=opts, typ=GetDataGuardAssociationsResult)
    return __ret__.apply(lambda __response__: GetDataGuardAssociationsResult(
        data_guard_associations=pulumi.get(__response__, 'data_guard_associations'),
        database_id=pulumi.get(__response__, 'database_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
