# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetExecutionWindowResult',
    'AwaitableGetExecutionWindowResult',
    'get_execution_window',
    'get_execution_window_output',
]

@pulumi.output_type
class GetExecutionWindowResult:
    """
    A collection of values returned by getExecutionWindow.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, estimated_time_in_mins=None, execution_resource_id=None, execution_window_id=None, freeform_tags=None, id=None, is_enforced_duration=None, lifecycle_details=None, lifecycle_substate=None, state=None, time_created=None, time_ended=None, time_scheduled=None, time_started=None, time_updated=None, total_time_taken_in_mins=None, window_duration_in_mins=None, window_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if estimated_time_in_mins and not isinstance(estimated_time_in_mins, int):
            raise TypeError("Expected argument 'estimated_time_in_mins' to be a int")
        pulumi.set(__self__, "estimated_time_in_mins", estimated_time_in_mins)
        if execution_resource_id and not isinstance(execution_resource_id, str):
            raise TypeError("Expected argument 'execution_resource_id' to be a str")
        pulumi.set(__self__, "execution_resource_id", execution_resource_id)
        if execution_window_id and not isinstance(execution_window_id, str):
            raise TypeError("Expected argument 'execution_window_id' to be a str")
        pulumi.set(__self__, "execution_window_id", execution_window_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enforced_duration and not isinstance(is_enforced_duration, bool):
            raise TypeError("Expected argument 'is_enforced_duration' to be a bool")
        pulumi.set(__self__, "is_enforced_duration", is_enforced_duration)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_substate and not isinstance(lifecycle_substate, str):
            raise TypeError("Expected argument 'lifecycle_substate' to be a str")
        pulumi.set(__self__, "lifecycle_substate", lifecycle_substate)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_scheduled and not isinstance(time_scheduled, str):
            raise TypeError("Expected argument 'time_scheduled' to be a str")
        pulumi.set(__self__, "time_scheduled", time_scheduled)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if total_time_taken_in_mins and not isinstance(total_time_taken_in_mins, int):
            raise TypeError("Expected argument 'total_time_taken_in_mins' to be a int")
        pulumi.set(__self__, "total_time_taken_in_mins", total_time_taken_in_mins)
        if window_duration_in_mins and not isinstance(window_duration_in_mins, int):
            raise TypeError("Expected argument 'window_duration_in_mins' to be a int")
        pulumi.set(__self__, "window_duration_in_mins", window_duration_in_mins)
        if window_type and not isinstance(window_type, str):
            raise TypeError("Expected argument 'window_type' to be a str")
        pulumi.set(__self__, "window_type", window_type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the execution window.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the execution window. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="estimatedTimeInMins")
    def estimated_time_in_mins(self) -> _builtins.int:
        """
        The estimated time of the execution window in minutes.
        """
        return pulumi.get(self, "estimated_time_in_mins")

    @_builtins.property
    @pulumi.getter(name="executionResourceId")
    def execution_resource_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution resource the execution window belongs to.
        """
        return pulumi.get(self, "execution_resource_id")

    @_builtins.property
    @pulumi.getter(name="executionWindowId")
    def execution_window_id(self) -> _builtins.str:
        return pulumi.get(self, "execution_window_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution window.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnforcedDuration")
    def is_enforced_duration(self) -> _builtins.bool:
        """
        Indicates if duration the user plans to allocate for scheduling window is strictly enforced. The default value is `FALSE`.
        """
        return pulumi.get(self, "is_enforced_duration")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> _builtins.str:
        """
        The current sub-state of the execution window. Valid states are DURATION_EXCEEDED, MAINTENANCE_IN_PROGRESS and WAITING.
        """
        return pulumi.get(self, "lifecycle_substate")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Schedule Policy. Valid states are CREATED, SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the execution window was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> _builtins.str:
        """
        The date and time that the execution window ended.
        """
        return pulumi.get(self, "time_ended")

    @_builtins.property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> _builtins.str:
        """
        The scheduled start date and time of the execution window.
        """
        return pulumi.get(self, "time_scheduled")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time that the execution window was started.
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The last date and time that the execution window was updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="totalTimeTakenInMins")
    def total_time_taken_in_mins(self) -> _builtins.int:
        """
        The total time taken by corresponding resource activity in minutes.
        """
        return pulumi.get(self, "total_time_taken_in_mins")

    @_builtins.property
    @pulumi.getter(name="windowDurationInMins")
    def window_duration_in_mins(self) -> _builtins.int:
        """
        Duration window allows user to set a duration they plan to allocate for Scheduling window. The duration is in minutes.
        """
        return pulumi.get(self, "window_duration_in_mins")

    @_builtins.property
    @pulumi.getter(name="windowType")
    def window_type(self) -> _builtins.str:
        """
        The execution window is of PLANNED or UNPLANNED type.
        """
        return pulumi.get(self, "window_type")


class AwaitableGetExecutionWindowResult(GetExecutionWindowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExecutionWindowResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            estimated_time_in_mins=self.estimated_time_in_mins,
            execution_resource_id=self.execution_resource_id,
            execution_window_id=self.execution_window_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_enforced_duration=self.is_enforced_duration,
            lifecycle_details=self.lifecycle_details,
            lifecycle_substate=self.lifecycle_substate,
            state=self.state,
            time_created=self.time_created,
            time_ended=self.time_ended,
            time_scheduled=self.time_scheduled,
            time_started=self.time_started,
            time_updated=self.time_updated,
            total_time_taken_in_mins=self.total_time_taken_in_mins,
            window_duration_in_mins=self.window_duration_in_mins,
            window_type=self.window_type)


def get_execution_window(execution_window_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExecutionWindowResult:
    """
    This data source provides details about a specific Execution Window resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified execution window.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_execution_window = oci.Database.get_execution_window(execution_window_id=test_execution_window_oci_database_execution_window["id"])
    ```


    :param _builtins.str execution_window_id: The execution window [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['executionWindowId'] = execution_window_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExecutionWindow:getExecutionWindow', __args__, opts=opts, typ=GetExecutionWindowResult).value

    return AwaitableGetExecutionWindowResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        estimated_time_in_mins=pulumi.get(__ret__, 'estimated_time_in_mins'),
        execution_resource_id=pulumi.get(__ret__, 'execution_resource_id'),
        execution_window_id=pulumi.get(__ret__, 'execution_window_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_enforced_duration=pulumi.get(__ret__, 'is_enforced_duration'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lifecycle_substate=pulumi.get(__ret__, 'lifecycle_substate'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_scheduled=pulumi.get(__ret__, 'time_scheduled'),
        time_started=pulumi.get(__ret__, 'time_started'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        total_time_taken_in_mins=pulumi.get(__ret__, 'total_time_taken_in_mins'),
        window_duration_in_mins=pulumi.get(__ret__, 'window_duration_in_mins'),
        window_type=pulumi.get(__ret__, 'window_type'))
def get_execution_window_output(execution_window_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExecutionWindowResult]:
    """
    This data source provides details about a specific Execution Window resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified execution window.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_execution_window = oci.Database.get_execution_window(execution_window_id=test_execution_window_oci_database_execution_window["id"])
    ```


    :param _builtins.str execution_window_id: The execution window [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['executionWindowId'] = execution_window_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExecutionWindow:getExecutionWindow', __args__, opts=opts, typ=GetExecutionWindowResult)
    return __ret__.apply(lambda __response__: GetExecutionWindowResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        estimated_time_in_mins=pulumi.get(__response__, 'estimated_time_in_mins'),
        execution_resource_id=pulumi.get(__response__, 'execution_resource_id'),
        execution_window_id=pulumi.get(__response__, 'execution_window_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_enforced_duration=pulumi.get(__response__, 'is_enforced_duration'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lifecycle_substate=pulumi.get(__response__, 'lifecycle_substate'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        time_scheduled=pulumi.get(__response__, 'time_scheduled'),
        time_started=pulumi.get(__response__, 'time_started'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        total_time_taken_in_mins=pulumi.get(__response__, 'total_time_taken_in_mins'),
        window_duration_in_mins=pulumi.get(__response__, 'window_duration_in_mins'),
        window_type=pulumi.get(__response__, 'window_type')))
