# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExecutionWindowsResult',
    'AwaitableGetExecutionWindowsResult',
    'get_execution_windows',
    'get_execution_windows_output',
]

@pulumi.output_type
class GetExecutionWindowsResult:
    """
    A collection of values returned by getExecutionWindows.
    """
    def __init__(__self__, compartment_id=None, display_name=None, execution_resource_id=None, execution_windows=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if execution_resource_id and not isinstance(execution_resource_id, str):
            raise TypeError("Expected argument 'execution_resource_id' to be a str")
        pulumi.set(__self__, "execution_resource_id", execution_resource_id)
        if execution_windows and not isinstance(execution_windows, list):
            raise TypeError("Expected argument 'execution_windows' to be a list")
        pulumi.set(__self__, "execution_windows", execution_windows)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the execution window. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="executionResourceId")
    def execution_resource_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution resource the execution window belongs to.
        """
        return pulumi.get(self, "execution_resource_id")

    @_builtins.property
    @pulumi.getter(name="executionWindows")
    def execution_windows(self) -> Sequence['outputs.GetExecutionWindowsExecutionWindowResult']:
        """
        The list of execution_windows.
        """
        return pulumi.get(self, "execution_windows")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExecutionWindowsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Schedule Policy. Valid states are CREATED, SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        """
        return pulumi.get(self, "state")


class AwaitableGetExecutionWindowsResult(GetExecutionWindowsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExecutionWindowsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            execution_resource_id=self.execution_resource_id,
            execution_windows=self.execution_windows,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_execution_windows(compartment_id: Optional[_builtins.str] = None,
                          display_name: Optional[_builtins.str] = None,
                          execution_resource_id: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetExecutionWindowsFilterArgs', 'GetExecutionWindowsFilterArgsDict']]] = None,
                          state: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExecutionWindowsResult:
    """
    This data source provides the list of Execution Windows in Oracle Cloud Infrastructure Database service.

    Lists the execution window resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_execution_windows = oci.Database.get_execution_windows(compartment_id=compartment_id,
        display_name=execution_window_display_name,
        execution_resource_id=test_resource["id"],
        state=execution_window_state)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str execution_resource_id: A filter to return only resources that match the given resource id exactly.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['executionResourceId'] = execution_resource_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExecutionWindows:getExecutionWindows', __args__, opts=opts, typ=GetExecutionWindowsResult).value

    return AwaitableGetExecutionWindowsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        execution_resource_id=pulumi.get(__ret__, 'execution_resource_id'),
        execution_windows=pulumi.get(__ret__, 'execution_windows'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_execution_windows_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 execution_resource_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExecutionWindowsFilterArgs', 'GetExecutionWindowsFilterArgsDict']]]]] = None,
                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExecutionWindowsResult]:
    """
    This data source provides the list of Execution Windows in Oracle Cloud Infrastructure Database service.

    Lists the execution window resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_execution_windows = oci.Database.get_execution_windows(compartment_id=compartment_id,
        display_name=execution_window_display_name,
        execution_resource_id=test_resource["id"],
        state=execution_window_state)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str execution_resource_id: A filter to return only resources that match the given resource id exactly.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['executionResourceId'] = execution_resource_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExecutionWindows:getExecutionWindows', __args__, opts=opts, typ=GetExecutionWindowsResult)
    return __ret__.apply(lambda __response__: GetExecutionWindowsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        execution_resource_id=pulumi.get(__response__, 'execution_resource_id'),
        execution_windows=pulumi.get(__response__, 'execution_windows'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
