# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKeyStoreResult',
    'AwaitableGetKeyStoreResult',
    'get_key_store',
    'get_key_store_output',
]

@pulumi.output_type
class GetKeyStoreResult:
    """
    A collection of values returned by getKeyStore.
    """
    def __init__(__self__, associated_databases=None, compartment_id=None, confirm_details_trigger=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, key_store_id=None, lifecycle_details=None, state=None, system_tags=None, time_created=None, type_details=None):
        if associated_databases and not isinstance(associated_databases, list):
            raise TypeError("Expected argument 'associated_databases' to be a list")
        pulumi.set(__self__, "associated_databases", associated_databases)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if confirm_details_trigger and not isinstance(confirm_details_trigger, int):
            raise TypeError("Expected argument 'confirm_details_trigger' to be a int")
        pulumi.set(__self__, "confirm_details_trigger", confirm_details_trigger)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_store_id and not isinstance(key_store_id, str):
            raise TypeError("Expected argument 'key_store_id' to be a str")
        pulumi.set(__self__, "key_store_id", key_store_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if type_details and not isinstance(type_details, list):
            raise TypeError("Expected argument 'type_details' to be a list")
        pulumi.set(__self__, "type_details", type_details)

    @_builtins.property
    @pulumi.getter(name="associatedDatabases")
    def associated_databases(self) -> Sequence['outputs.GetKeyStoreAssociatedDatabaseResult']:
        """
        List of databases associated with the key store.
        """
        return pulumi.get(self, "associated_databases")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="confirmDetailsTrigger")
    def confirm_details_trigger(self) -> _builtins.int:
        return pulumi.get(self, "confirm_details_trigger")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the key store. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> _builtins.str:
        return pulumi.get(self, "key_store_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the key store.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time that the key store was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="typeDetails")
    def type_details(self) -> Sequence['outputs.GetKeyStoreTypeDetailResult']:
        """
        Key store type details.
        """
        return pulumi.get(self, "type_details")


class AwaitableGetKeyStoreResult(GetKeyStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyStoreResult(
            associated_databases=self.associated_databases,
            compartment_id=self.compartment_id,
            confirm_details_trigger=self.confirm_details_trigger,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            key_store_id=self.key_store_id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            type_details=self.type_details)


def get_key_store(key_store_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyStoreResult:
    """
    This data source provides details about a specific Key Store resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified key store.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_key_store = oci.Database.get_key_store(key_store_id=test_key_store_oci_database_key_store["id"])
    ```


    :param _builtins.str key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
    """
    __args__ = dict()
    __args__['keyStoreId'] = key_store_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getKeyStore:getKeyStore', __args__, opts=opts, typ=GetKeyStoreResult).value

    return AwaitableGetKeyStoreResult(
        associated_databases=pulumi.get(__ret__, 'associated_databases'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        confirm_details_trigger=pulumi.get(__ret__, 'confirm_details_trigger'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        key_store_id=pulumi.get(__ret__, 'key_store_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        type_details=pulumi.get(__ret__, 'type_details'))
def get_key_store_output(key_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyStoreResult]:
    """
    This data source provides details about a specific Key Store resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified key store.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_key_store = oci.Database.get_key_store(key_store_id=test_key_store_oci_database_key_store["id"])
    ```


    :param _builtins.str key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
    """
    __args__ = dict()
    __args__['keyStoreId'] = key_store_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getKeyStore:getKeyStore', __args__, opts=opts, typ=GetKeyStoreResult)
    return __ret__.apply(lambda __response__: GetKeyStoreResult(
        associated_databases=pulumi.get(__response__, 'associated_databases'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        confirm_details_trigger=pulumi.get(__response__, 'confirm_details_trigger'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        key_store_id=pulumi.get(__response__, 'key_store_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        type_details=pulumi.get(__response__, 'type_details')))
