# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPluggableDatabaseSnapshotResult',
    'AwaitableGetPluggableDatabaseSnapshotResult',
    'get_pluggable_database_snapshot',
    'get_pluggable_database_snapshot_output',
]

@pulumi.output_type
class GetPluggableDatabaseSnapshotResult:
    """
    A collection of values returned by getPluggableDatabaseSnapshot.
    """
    def __init__(__self__, cluster_id=None, compartment_id=None, defined_tags=None, freeform_tags=None, id=None, lifecycle_details=None, name=None, pluggable_database_id=None, pluggable_database_snapshot_id=None, state=None, system_tags=None, time_created=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pluggable_database_id and not isinstance(pluggable_database_id, str):
            raise TypeError("Expected argument 'pluggable_database_id' to be a str")
        pulumi.set(__self__, "pluggable_database_id", pluggable_database_id)
        if pluggable_database_snapshot_id and not isinstance(pluggable_database_snapshot_id, str):
            raise TypeError("Expected argument 'pluggable_database_snapshot_id' to be a str")
        pulumi.set(__self__, "pluggable_database_snapshot_id", pluggable_database_snapshot_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Pluggable Database Snapshot.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state of the Exadata Pluggable Database Snapshot.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The user-friendly name for the Database Snapshot. The name should be unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseId")
    def pluggable_database_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Pluggable Database.
        """
        return pulumi.get(self, "pluggable_database_id")

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseSnapshotId")
    def pluggable_database_snapshot_id(self) -> _builtins.str:
        return pulumi.get(self, "pluggable_database_snapshot_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Exadata Pluggable Database Snapshot.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time that the Exadata Pluggable Database Snapshot was created, as expressed in RFC 3339 format. For example: 2023-06-27T21:10:29Z
        """
        return pulumi.get(self, "time_created")


class AwaitableGetPluggableDatabaseSnapshotResult(GetPluggableDatabaseSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPluggableDatabaseSnapshotResult(
            cluster_id=self.cluster_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            pluggable_database_id=self.pluggable_database_id,
            pluggable_database_snapshot_id=self.pluggable_database_snapshot_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created)


def get_pluggable_database_snapshot(pluggable_database_snapshot_id: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPluggableDatabaseSnapshotResult:
    """
    This data source provides details about a specific Pluggable Database Snapshot resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Exadata Pluggable Database Snapshot in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pluggable_database_snapshot = oci.Database.get_pluggable_database_snapshot(pluggable_database_snapshot_id=test_pluggable_database_snapshot_oci_database_pluggable_database_snapshot["id"])
    ```


    :param _builtins.str pluggable_database_snapshot_id: The Exadata Pluggable Database Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['pluggableDatabaseSnapshotId'] = pluggable_database_snapshot_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getPluggableDatabaseSnapshot:getPluggableDatabaseSnapshot', __args__, opts=opts, typ=GetPluggableDatabaseSnapshotResult).value

    return AwaitableGetPluggableDatabaseSnapshotResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        pluggable_database_id=pulumi.get(__ret__, 'pluggable_database_id'),
        pluggable_database_snapshot_id=pulumi.get(__ret__, 'pluggable_database_snapshot_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_pluggable_database_snapshot_output(pluggable_database_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPluggableDatabaseSnapshotResult]:
    """
    This data source provides details about a specific Pluggable Database Snapshot resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Exadata Pluggable Database Snapshot in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pluggable_database_snapshot = oci.Database.get_pluggable_database_snapshot(pluggable_database_snapshot_id=test_pluggable_database_snapshot_oci_database_pluggable_database_snapshot["id"])
    ```


    :param _builtins.str pluggable_database_snapshot_id: The Exadata Pluggable Database Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['pluggableDatabaseSnapshotId'] = pluggable_database_snapshot_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getPluggableDatabaseSnapshot:getPluggableDatabaseSnapshot', __args__, opts=opts, typ=GetPluggableDatabaseSnapshotResult)
    return __ret__.apply(lambda __response__: GetPluggableDatabaseSnapshotResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        pluggable_database_id=pulumi.get(__response__, 'pluggable_database_id'),
        pluggable_database_snapshot_id=pulumi.get(__response__, 'pluggable_database_snapshot_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created')))
