# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VmClusterRemoveVirtualMachineArgs', 'VmClusterRemoveVirtualMachine']

@pulumi.input_type
class VmClusterRemoveVirtualMachineArgs:
    def __init__(__self__, *,
                 db_servers: pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDbServerArgs']]],
                 vm_cluster_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a VmClusterRemoveVirtualMachine resource.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDbServerArgs']]] db_servers: The list of Exacc DB servers for the cluster to be removed.
        :param pulumi.Input[_builtins.str] vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "db_servers", db_servers)
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDbServerArgs']]]:
        """
        The list of Exacc DB servers for the cluster to be removed.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDbServerArgs']]]):
        pulumi.set(self, "db_servers", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_id")

    @vm_cluster_id.setter
    def vm_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_cluster_id", value)


@pulumi.input_type
class _VmClusterRemoveVirtualMachineState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_automation_update_details: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineCloudAutomationUpdateDetailArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 cpus_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 data_collection_options: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDataCollectionOptionArgs']]]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDbServerArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 exascale_db_storage_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineFileSystemConfigurationDetailArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gi_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_patch_history_entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_management_type: Optional[pulumi.Input[_builtins.str]] = None,
                 system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VmClusterRemoveVirtualMachine resources.
        :param pulumi.Input[_builtins.str] availability_domain: The name of the availability domain that the VM cluster is located in.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineCloudAutomationUpdateDetailArgs']]] cloud_automation_update_details: Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        :param pulumi.Input[_builtins.int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDataCollectionOptionArgs']]] data_collection_options: Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDbServerArgs']]] db_servers: The list of Exacc DB servers for the cluster to be removed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Exadata Cloud@Customer VM cluster. The name does not need to be unique.
        :param pulumi.Input[_builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] exascale_db_storage_vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineFileSystemConfigurationDetailArgs']]] file_system_configuration_details: Details of the file system configuration of the VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gi_version: The Oracle Grid Infrastructure software version for the VM cluster.
        :param pulumi.Input[_builtins.bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        :param pulumi.Input[_builtins.bool] is_sparse_diskgroup_enabled: If true, sparse disk group is configured for the VM cluster. If false, sparse disk group is not created.
        :param pulumi.Input[_builtins.str] last_patch_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the VM cluster. The default is LICENSE_INCLUDED.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[_builtins.str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the VM cluster.
        :param pulumi.Input[_builtins.str] state: The current state of the VM cluster.
        :param pulumi.Input[_builtins.str] storage_management_type: Specifies whether the type of storage management for the VM cluster is ASM or Exascale.
        :param pulumi.Input[_builtins.str] system_version: Operating system version of the image.
        :param pulumi.Input[_builtins.str] time_created: The date and time that the VM cluster was created.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[_builtins.str] vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vm_cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        :param pulumi.Input[_builtins.str] vm_cluster_type: The vmcluster type for the VM cluster/Cloud VM cluster.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if cloud_automation_update_details is not None:
            pulumi.set(__self__, "cloud_automation_update_details", cloud_automation_update_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if cpus_enabled is not None:
            pulumi.set(__self__, "cpus_enabled", cpus_enabled)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers is not None:
            pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id is not None:
            pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if exascale_db_storage_vault_id is not None:
            pulumi.set(__self__, "exascale_db_storage_vault_id", exascale_db_storage_vault_id)
        if file_system_configuration_details is not None:
            pulumi.set(__self__, "file_system_configuration_details", file_system_configuration_details)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gi_version is not None:
            pulumi.set(__self__, "gi_version", gi_version)
        if is_local_backup_enabled is not None:
            pulumi.set(__self__, "is_local_backup_enabled", is_local_backup_enabled)
        if is_sparse_diskgroup_enabled is not None:
            pulumi.set(__self__, "is_sparse_diskgroup_enabled", is_sparse_diskgroup_enabled)
        if last_patch_history_entry_id is not None:
            pulumi.set(__self__, "last_patch_history_entry_id", last_patch_history_entry_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if ssh_public_keys is not None:
            pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_management_type is not None:
            pulumi.set(__self__, "storage_management_type", storage_management_type)
        if system_version is not None:
            pulumi.set(__self__, "system_version", system_version)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if vm_cluster_id is not None:
            pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)
        if vm_cluster_network_id is not None:
            pulumi.set(__self__, "vm_cluster_network_id", vm_cluster_network_id)
        if vm_cluster_type is not None:
            pulumi.set(__self__, "vm_cluster_type", vm_cluster_type)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the availability domain that the VM cluster is located in.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="cloudAutomationUpdateDetails")
    def cloud_automation_update_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineCloudAutomationUpdateDetailArgs']]]]:
        """
        Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        """
        return pulumi.get(self, "cloud_automation_update_details")

    @cloud_automation_update_details.setter
    def cloud_automation_update_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineCloudAutomationUpdateDetailArgs']]]]):
        pulumi.set(self, "cloud_automation_update_details", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_model", value)

    @_builtins.property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @cpus_enabled.setter
    def cpus_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpus_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDataCollectionOptionArgs']]]]:
        """
        Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDataCollectionOptionArgs']]]]):
        pulumi.set(self, "data_collection_options", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDbServerArgs']]]]:
        """
        The list of Exacc DB servers for the cluster to be removed.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineDbServerArgs']]]]):
        pulumi.set(self, "db_servers", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name for the Exadata Cloud@Customer VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="exascaleDbStorageVaultId")
    def exascale_db_storage_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "exascale_db_storage_vault_id")

    @exascale_db_storage_vault_id.setter
    def exascale_db_storage_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exascale_db_storage_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemConfigurationDetails")
    def file_system_configuration_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineFileSystemConfigurationDetailArgs']]]]:
        """
        Details of the file system configuration of the VM cluster.
        """
        return pulumi.get(self, "file_system_configuration_details")

    @file_system_configuration_details.setter
    def file_system_configuration_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterRemoveVirtualMachineFileSystemConfigurationDetailArgs']]]]):
        pulumi.set(self, "file_system_configuration_details", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle Grid Infrastructure software version for the VM cluster.
        """
        return pulumi.get(self, "gi_version")

    @gi_version.setter
    def gi_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gi_version", value)

    @_builtins.property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_local_backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, sparse disk group is configured for the VM cluster. If false, sparse disk group is not created.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @is_sparse_diskgroup_enabled.setter
    def is_sparse_diskgroup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sparse_diskgroup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @last_patch_history_entry_id.setter
    def last_patch_history_entry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_patch_history_entry_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle license model that applies to the VM cluster. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The public key portion of one or more key pairs used for SSH access to the VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the VM cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="storageManagementType")
    def storage_management_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the type of storage management for the VM cluster is ASM or Exascale.
        """
        return pulumi.get(self, "storage_management_type")

    @storage_management_type.setter
    def storage_management_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_management_type", value)

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @system_version.setter
    def system_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_version", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_id")

    @vm_cluster_id.setter
    def vm_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterNetworkId")
    def vm_cluster_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        """
        return pulumi.get(self, "vm_cluster_network_id")

    @vm_cluster_network_id.setter
    def vm_cluster_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_network_id", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterType")
    def vm_cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vmcluster type for the VM cluster/Cloud VM cluster.
        """
        return pulumi.get(self, "vm_cluster_type")

    @vm_cluster_type.setter
    def vm_cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_type", value)


@pulumi.type_token("oci:Database/vmClusterRemoveVirtualMachine:VmClusterRemoveVirtualMachine")
class VmClusterRemoveVirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineDbServerArgs', 'VmClusterRemoveVirtualMachineDbServerArgsDict']]]]] = None,
                 vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Vm Cluster Remove Virtual Machine resource in Oracle Cloud Infrastructure Database service.

        Remove Virtual Machines from the VM cluster. Applies to Exadata Cloud@Customer instances only.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vm_cluster_remove_virtual_machine = oci.database.VmClusterRemoveVirtualMachine("test_vm_cluster_remove_virtual_machine",
            db_servers=[{
                "db_server_id": test_db_server["id"],
            }],
            vm_cluster_id=test_vm_cluster["id"])
        ```

        ## Import

        VmClusterRemoveVirtualMachine can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/vmClusterRemoveVirtualMachine:VmClusterRemoveVirtualMachine test_vm_cluster_remove_virtual_machine "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineDbServerArgs', 'VmClusterRemoveVirtualMachineDbServerArgsDict']]]] db_servers: The list of Exacc DB servers for the cluster to be removed.
        :param pulumi.Input[_builtins.str] vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VmClusterRemoveVirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Vm Cluster Remove Virtual Machine resource in Oracle Cloud Infrastructure Database service.

        Remove Virtual Machines from the VM cluster. Applies to Exadata Cloud@Customer instances only.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vm_cluster_remove_virtual_machine = oci.database.VmClusterRemoveVirtualMachine("test_vm_cluster_remove_virtual_machine",
            db_servers=[{
                "db_server_id": test_db_server["id"],
            }],
            vm_cluster_id=test_vm_cluster["id"])
        ```

        ## Import

        VmClusterRemoveVirtualMachine can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/vmClusterRemoveVirtualMachine:VmClusterRemoveVirtualMachine test_vm_cluster_remove_virtual_machine "id"
        ```

        :param str resource_name: The name of the resource.
        :param VmClusterRemoveVirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VmClusterRemoveVirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineDbServerArgs', 'VmClusterRemoveVirtualMachineDbServerArgsDict']]]]] = None,
                 vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VmClusterRemoveVirtualMachineArgs.__new__(VmClusterRemoveVirtualMachineArgs)

            if db_servers is None and not opts.urn:
                raise TypeError("Missing required property 'db_servers'")
            __props__.__dict__["db_servers"] = db_servers
            if vm_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'vm_cluster_id'")
            __props__.__dict__["vm_cluster_id"] = vm_cluster_id
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["cloud_automation_update_details"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["compute_model"] = None
            __props__.__dict__["cpus_enabled"] = None
            __props__.__dict__["data_collection_options"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["exadata_infrastructure_id"] = None
            __props__.__dict__["exascale_db_storage_vault_id"] = None
            __props__.__dict__["file_system_configuration_details"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["gi_version"] = None
            __props__.__dict__["is_local_backup_enabled"] = None
            __props__.__dict__["is_sparse_diskgroup_enabled"] = None
            __props__.__dict__["last_patch_history_entry_id"] = None
            __props__.__dict__["license_model"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["ssh_public_keys"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["storage_management_type"] = None
            __props__.__dict__["system_version"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_zone"] = None
            __props__.__dict__["vm_cluster_network_id"] = None
            __props__.__dict__["vm_cluster_type"] = None
        super(VmClusterRemoveVirtualMachine, __self__).__init__(
            'oci:Database/vmClusterRemoveVirtualMachine:VmClusterRemoveVirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_automation_update_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineCloudAutomationUpdateDetailArgs', 'VmClusterRemoveVirtualMachineCloudAutomationUpdateDetailArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_model: Optional[pulumi.Input[_builtins.str]] = None,
            cpus_enabled: Optional[pulumi.Input[_builtins.int]] = None,
            data_collection_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineDataCollectionOptionArgs', 'VmClusterRemoveVirtualMachineDataCollectionOptionArgsDict']]]]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineDbServerArgs', 'VmClusterRemoveVirtualMachineDbServerArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
            exascale_db_storage_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineFileSystemConfigurationDetailArgs', 'VmClusterRemoveVirtualMachineFileSystemConfigurationDetailArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            gi_version: Optional[pulumi.Input[_builtins.str]] = None,
            is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            last_patch_history_entry_id: Optional[pulumi.Input[_builtins.str]] = None,
            license_model: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            shape: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            storage_management_type: Optional[pulumi.Input[_builtins.str]] = None,
            system_version: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            vm_cluster_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            vm_cluster_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'VmClusterRemoveVirtualMachine':
        """
        Get an existing VmClusterRemoveVirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The name of the availability domain that the VM cluster is located in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineCloudAutomationUpdateDetailArgs', 'VmClusterRemoveVirtualMachineCloudAutomationUpdateDetailArgsDict']]]] cloud_automation_update_details: Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        :param pulumi.Input[_builtins.int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineDataCollectionOptionArgs', 'VmClusterRemoveVirtualMachineDataCollectionOptionArgsDict']]]] data_collection_options: Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineDbServerArgs', 'VmClusterRemoveVirtualMachineDbServerArgsDict']]]] db_servers: The list of Exacc DB servers for the cluster to be removed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Exadata Cloud@Customer VM cluster. The name does not need to be unique.
        :param pulumi.Input[_builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] exascale_db_storage_vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterRemoveVirtualMachineFileSystemConfigurationDetailArgs', 'VmClusterRemoveVirtualMachineFileSystemConfigurationDetailArgsDict']]]] file_system_configuration_details: Details of the file system configuration of the VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gi_version: The Oracle Grid Infrastructure software version for the VM cluster.
        :param pulumi.Input[_builtins.bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        :param pulumi.Input[_builtins.bool] is_sparse_diskgroup_enabled: If true, sparse disk group is configured for the VM cluster. If false, sparse disk group is not created.
        :param pulumi.Input[_builtins.str] last_patch_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the VM cluster. The default is LICENSE_INCLUDED.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[_builtins.str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the VM cluster.
        :param pulumi.Input[_builtins.str] state: The current state of the VM cluster.
        :param pulumi.Input[_builtins.str] storage_management_type: Specifies whether the type of storage management for the VM cluster is ASM or Exascale.
        :param pulumi.Input[_builtins.str] system_version: Operating system version of the image.
        :param pulumi.Input[_builtins.str] time_created: The date and time that the VM cluster was created.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[_builtins.str] vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vm_cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        :param pulumi.Input[_builtins.str] vm_cluster_type: The vmcluster type for the VM cluster/Cloud VM cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VmClusterRemoveVirtualMachineState.__new__(_VmClusterRemoveVirtualMachineState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["cloud_automation_update_details"] = cloud_automation_update_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["cpus_enabled"] = cpus_enabled
        __props__.__dict__["data_collection_options"] = data_collection_options
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_servers"] = db_servers
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
        __props__.__dict__["exascale_db_storage_vault_id"] = exascale_db_storage_vault_id
        __props__.__dict__["file_system_configuration_details"] = file_system_configuration_details
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gi_version"] = gi_version
        __props__.__dict__["is_local_backup_enabled"] = is_local_backup_enabled
        __props__.__dict__["is_sparse_diskgroup_enabled"] = is_sparse_diskgroup_enabled
        __props__.__dict__["last_patch_history_entry_id"] = last_patch_history_entry_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["shape"] = shape
        __props__.__dict__["ssh_public_keys"] = ssh_public_keys
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_management_type"] = storage_management_type
        __props__.__dict__["system_version"] = system_version
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["vm_cluster_id"] = vm_cluster_id
        __props__.__dict__["vm_cluster_network_id"] = vm_cluster_network_id
        __props__.__dict__["vm_cluster_type"] = vm_cluster_type
        return VmClusterRemoveVirtualMachine(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the availability domain that the VM cluster is located in.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="cloudAutomationUpdateDetails")
    def cloud_automation_update_details(self) -> pulumi.Output[Sequence['outputs.VmClusterRemoveVirtualMachineCloudAutomationUpdateDetail']]:
        """
        Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        """
        return pulumi.get(self, "cloud_automation_update_details")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[_builtins.str]:
        """
        The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> pulumi.Output[_builtins.int]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> pulumi.Output[Sequence['outputs.VmClusterRemoveVirtualMachineDataCollectionOption']]:
        """
        Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Output[Sequence['outputs.VmClusterRemoveVirtualMachineDbServer']]:
        """
        The list of Exacc DB servers for the cluster to be removed.
        """
        return pulumi.get(self, "db_servers")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly name for the Exadata Cloud@Customer VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="exascaleDbStorageVaultId")
    def exascale_db_storage_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "exascale_db_storage_vault_id")

    @_builtins.property
    @pulumi.getter(name="fileSystemConfigurationDetails")
    def file_system_configuration_details(self) -> pulumi.Output[Sequence['outputs.VmClusterRemoveVirtualMachineFileSystemConfigurationDetail']]:
        """
        Details of the file system configuration of the VM cluster.
        """
        return pulumi.get(self, "file_system_configuration_details")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle Grid Infrastructure software version for the VM cluster.
        """
        return pulumi.get(self, "gi_version")

    @_builtins.property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, sparse disk group is configured for the VM cluster. If false, sparse disk group is not created.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @_builtins.property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle license model that applies to the VM cluster. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Output[_builtins.str]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The public key portion of one or more key pairs used for SSH access to the VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the VM cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="storageManagementType")
    def storage_management_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether the type of storage management for the VM cluster is ASM or Exascale.
        """
        return pulumi.get(self, "storage_management_type")

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> pulumi.Output[_builtins.str]:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="vmClusterNetworkId")
    def vm_cluster_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        """
        return pulumi.get(self, "vm_cluster_network_id")

    @_builtins.property
    @pulumi.getter(name="vmClusterType")
    def vm_cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        The vmcluster type for the VM cluster/Cloud VM cluster.
        """
        return pulumi.get(self, "vm_cluster_type")

