# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudAsmConfigurationResult',
    'AwaitableGetCloudAsmConfigurationResult',
    'get_cloud_asm_configuration',
    'get_cloud_asm_configuration_output',
]

@pulumi.output_type
class GetCloudAsmConfigurationResult:
    """
    A collection of values returned by getCloudAsmConfiguration.
    """
    def __init__(__self__, cloud_asm_id=None, id=None, init_parameters=None, opc_named_credential_id=None):
        if cloud_asm_id and not isinstance(cloud_asm_id, str):
            raise TypeError("Expected argument 'cloud_asm_id' to be a str")
        pulumi.set(__self__, "cloud_asm_id", cloud_asm_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if init_parameters and not isinstance(init_parameters, list):
            raise TypeError("Expected argument 'init_parameters' to be a list")
        pulumi.set(__self__, "init_parameters", init_parameters)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)

    @_builtins.property
    @pulumi.getter(name="cloudAsmId")
    def cloud_asm_id(self) -> _builtins.str:
        return pulumi.get(self, "cloud_asm_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="initParameters")
    def init_parameters(self) -> Sequence['outputs.GetCloudAsmConfigurationInitParameterResult']:
        """
        An array of initialization parameters for the cloud ASM instances.
        """
        return pulumi.get(self, "init_parameters")

    @_builtins.property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "opc_named_credential_id")


class AwaitableGetCloudAsmConfigurationResult(GetCloudAsmConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudAsmConfigurationResult(
            cloud_asm_id=self.cloud_asm_id,
            id=self.id,
            init_parameters=self.init_parameters,
            opc_named_credential_id=self.opc_named_credential_id)


def get_cloud_asm_configuration(cloud_asm_id: Optional[_builtins.str] = None,
                                opc_named_credential_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudAsmConfigurationResult:
    """
    This data source provides details about a specific Cloud Asm Configuration resource in Oracle Cloud Infrastructure Database Management service.

    Gets configuration details including disk groups for the cloud ASM specified by `cloudAsmId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_asm_configuration = oci.DatabaseManagement.get_cloud_asm_configuration(cloud_asm_id=test_cloud_asm["id"],
        opc_named_credential_id=cloud_asm_configuration_opc_named_credential_id)
    ```


    :param _builtins.str cloud_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud ASM.
    :param _builtins.str opc_named_credential_id: The OCID of the Named Credential.
    """
    __args__ = dict()
    __args__['cloudAsmId'] = cloud_asm_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getCloudAsmConfiguration:getCloudAsmConfiguration', __args__, opts=opts, typ=GetCloudAsmConfigurationResult).value

    return AwaitableGetCloudAsmConfigurationResult(
        cloud_asm_id=pulumi.get(__ret__, 'cloud_asm_id'),
        id=pulumi.get(__ret__, 'id'),
        init_parameters=pulumi.get(__ret__, 'init_parameters'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'))
def get_cloud_asm_configuration_output(cloud_asm_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opc_named_credential_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudAsmConfigurationResult]:
    """
    This data source provides details about a specific Cloud Asm Configuration resource in Oracle Cloud Infrastructure Database Management service.

    Gets configuration details including disk groups for the cloud ASM specified by `cloudAsmId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_asm_configuration = oci.DatabaseManagement.get_cloud_asm_configuration(cloud_asm_id=test_cloud_asm["id"],
        opc_named_credential_id=cloud_asm_configuration_opc_named_credential_id)
    ```


    :param _builtins.str cloud_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud ASM.
    :param _builtins.str opc_named_credential_id: The OCID of the Named Credential.
    """
    __args__ = dict()
    __args__['cloudAsmId'] = cloud_asm_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getCloudAsmConfiguration:getCloudAsmConfiguration', __args__, opts=opts, typ=GetCloudAsmConfigurationResult)
    return __ret__.apply(lambda __response__: GetCloudAsmConfigurationResult(
        cloud_asm_id=pulumi.get(__response__, 'cloud_asm_id'),
        id=pulumi.get(__response__, 'id'),
        init_parameters=pulumi.get(__response__, 'init_parameters'),
        opc_named_credential_id=pulumi.get(__response__, 'opc_named_credential_id')))
